/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.outline.CNFOutlinePage;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class EditorToOutlineAdapterFactory
implements IAdapterFactory {
    private static final Map<IEditorPart, LanguageServer> lsCache = Collections.synchronizedMap(new HashMap());

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adapterType == IContentOutlinePage.class && adaptableObject instanceof IEditorPart && LanguageServersRegistry.getInstance().canUseLanguageServer(((IEditorPart)adaptableObject).getEditorInput())) {
            LanguageServer server = lsCache.remove(adaptableObject);
            if (server != null) {
                return (T)EditorToOutlineAdapterFactory.createOutlinePage(adaptableObject, server);
            }
            IDocument document = LSPEclipseUtils.getDocument(((IEditorPart)adaptableObject).getEditorInput());
            if (document != null) {
                CompletableFuture<List<@NonNull LanguageServer>> languageServers = LanguageServiceAccessor.getLanguageServers(document, capabilities -> LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)capabilities.getDocumentSymbolProvider()));
                List<@NonNull Object> servers = Collections.emptyList();
                try {
                    servers = languageServers.get(50L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    EditorToOutlineAdapterFactory.refreshContentOutlineAsync(languageServers, (IEditorPart)adaptableObject);
                }
                catch (ExecutionException e) {
                    LanguageServerPlugin.logError(e);
                }
                catch (InterruptedException e) {
                    LanguageServerPlugin.logError(e);
                    Thread.currentThread().interrupt();
                }
                if (!servers.isEmpty()) {
                    LanguageServer languageServer = (LanguageServer)servers.get(0);
                    return (T)EditorToOutlineAdapterFactory.createOutlinePage(adaptableObject, languageServer);
                }
            }
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IContentOutlinePage.class};
    }

    private static CNFOutlinePage createOutlinePage(Object adaptableObject, LanguageServer languageServer) {
        ITextEditor textEditor = null;
        if (adaptableObject instanceof ITextEditor) {
            textEditor = (ITextEditor)adaptableObject;
        }
        return new CNFOutlinePage(languageServer, textEditor);
    }

    private static void refreshContentOutlineAsync(CompletableFuture<List<@NonNull LanguageServer>> languageServers, IEditorPart editorPart) {
        languageServers.thenAcceptAsync(servers -> {
            if (!servers.isEmpty()) {
                Display.getDefault().asyncExec(() -> {
                    IViewPart viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.views.ContentOutline");
                    if (viewPart instanceof ContentOutline) {
                        lsCache.put(editorPart, (LanguageServer)servers.get(0));
                        ((ContentOutline)viewPart).partActivated((IWorkbenchPart)editorPart);
                    }
                });
            }
        });
    }
}

