/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;

public class CifCollectUtils {
    private CifCollectUtils() {
    }

    public static Stream<ComplexComponent> getComplexComponentsStream(ComplexComponent comp) {
        return StreamSupport.stream(new ComplexComponentSpliterator(comp, false), false);
    }

    public static Stream<ComplexComponent> getComplexComponentsStream(ComplexComponent comp, boolean traverseCompDefs) {
        return StreamSupport.stream(new ComplexComponentSpliterator(comp, traverseCompDefs), false);
    }

    public static Stream<Event> getEventDeclarationsStream(ComplexComponent comp) {
        return CifCollectUtils.getComplexComponentsStream(comp).flatMap(cc -> cc.getDeclarations().stream()).filter(decl -> decl instanceof Event).map(decl -> (Event)decl);
    }

    public static <T extends Collection<Event>> T collectEvents(ComplexComponent comp, T events) {
        CifCollectUtils.getEventDeclarationsStream(comp).collect(Collectors.toCollection(() -> events));
        return events;
    }

    public static <T extends Collection<Event>> T collectControllableEvents(ComplexComponent comp, T ctrlEvents) {
        CifCollectUtils.getEventDeclarationsStream(comp).filter(ed -> ed.getControllable() != null && ed.getControllable() != false).collect(Collectors.toCollection(() -> ctrlEvents));
        return ctrlEvents;
    }

    public static <T extends Collection<Automaton>> T collectAutomata(ComplexComponent comp, T automata) {
        CifCollectUtils.getComplexComponentsStream(comp).filter(cc -> cc instanceof Automaton).map(cc -> (Automaton)cc).collect(Collectors.toCollection(() -> automata));
        return automata;
    }

    public static <T extends Collection<Declaration>> T collectDeclarations(ComplexComponent comp, T declarations) {
        CifCollectUtils.getComplexComponentsStream(comp).forEach(cc -> {
            boolean bl = declarations.addAll(cc.getDeclarations());
        });
        return declarations;
    }

    public static <T extends Collection<Declaration>> T collectStateVariables(ComplexComponent comp, T variables) {
        CifCollectUtils.getComplexComponentsStream(comp).flatMap(cc -> cc.getDeclarations().stream()).filter(decl -> decl instanceof DiscVariable || decl instanceof InputVariable || decl instanceof ContVariable).collect(Collectors.toCollection(() -> variables));
        return variables;
    }

    public static <T extends Collection<DiscVariable>> T collectDiscVariables(ComplexComponent comp, T variables) {
        CifCollectUtils.getComplexComponentsStream(comp).flatMap(cc -> cc.getDeclarations().stream()).filter(decl -> decl instanceof DiscVariable).map(decl -> (DiscVariable)decl).collect(Collectors.toCollection(() -> variables));
        return variables;
    }

    public static <T extends Collection<Declaration>> T collectDiscAndInputVariables(ComplexComponent comp, T variables) {
        CifCollectUtils.getComplexComponentsStream(comp).flatMap(cc -> cc.getDeclarations().stream()).filter(decl -> decl instanceof DiscVariable || decl instanceof InputVariable).collect(Collectors.toCollection(() -> variables));
        return variables;
    }

    public static <T extends Collection<InputVariable>> T collectInputVariables(ComplexComponent comp, T variables) {
        CifCollectUtils.getComplexComponentsStream(comp).flatMap(cc -> cc.getDeclarations().stream()).filter(decl -> decl instanceof InputVariable).map(decl -> (InputVariable)decl).collect(Collectors.toCollection(() -> variables));
        return variables;
    }

    public static <T extends Collection<AlgVariable>> T collectAlgVariables(ComplexComponent comp, T variables) {
        CifCollectUtils.getComplexComponentsStream(comp).flatMap(cc -> cc.getDeclarations().stream()).filter(decl -> decl instanceof AlgVariable).map(decl -> (AlgVariable)decl).collect(Collectors.toCollection(() -> variables));
        return variables;
    }

    public static <T extends Collection<ContVariable>> T collectContVariables(ComplexComponent comp, T variables) {
        CifCollectUtils.getComplexComponentsStream(comp).flatMap(cc -> cc.getDeclarations().stream()).filter(decl -> decl instanceof ContVariable).map(decl -> (ContVariable)decl).collect(Collectors.toCollection(() -> variables));
        return variables;
    }

    public static <T extends Collection<Constant>> T collectConstants(ComplexComponent comp, T constants) {
        CifCollectUtils.getComplexComponentsStream(comp).flatMap(cc -> cc.getDeclarations().stream()).filter(decl -> decl instanceof Constant).map(decl -> (Constant)decl).collect(Collectors.toCollection(() -> constants));
        return constants;
    }

    public static <T extends Collection<IoDecl>> T collectIoDeclarations(ComplexComponent comp, T declarations) {
        CifCollectUtils.getComplexComponentsStream(comp).forEach(cc -> {
            boolean bl = declarations.addAll(cc.getIoDecls());
        });
        return declarations;
    }

    public static <T extends Collection<EnumDecl>> T collectEnumDecls(ComplexComponent comp, T enumDecls) {
        CifCollectUtils.getComplexComponentsStream(comp, true).flatMap(cc -> cc.getDeclarations().stream()).filter(decl -> decl instanceof EnumDecl).map(decl -> (EnumDecl)decl).collect(Collectors.toCollection(() -> enumDecls));
        return enumDecls;
    }

    private static class ComplexComponentSpliterator
    implements Spliterator<ComplexComponent> {
        private final boolean traverseCompDefs;
        private Deque<ComplexComponent> notDone = new ArrayDeque<ComplexComponent>(32);

        public ComplexComponentSpliterator(ComplexComponent comp, boolean traverseCompDefs) {
            this.traverseCompDefs = traverseCompDefs;
            this.notDone.add(comp);
        }

        @Override
        public int characteristics() {
            return 273;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public boolean tryAdvance(Consumer<? super ComplexComponent> action) {
            if (this.notDone.isEmpty()) {
                return false;
            }
            ComplexComponent comp = this.notDone.poll();
            this.expandGroup(comp);
            action.accept((ComplexComponent)comp);
            return true;
        }

        private void expandGroup(ComplexComponent comp) {
            if (comp instanceof Group) {
                Group grp = (Group)comp;
                for (Component child : grp.getComponents()) {
                    if (!(child instanceof ComplexComponent)) continue;
                    this.notDone.add((ComplexComponent)child);
                }
                if (this.traverseCompDefs) {
                    for (ComponentDef compDef : grp.getDefinitions()) {
                        this.notDone.add(compDef.getBody());
                    }
                }
            }
        }

        @Override
        public Spliterator<ComplexComponent> trySplit() {
            return null;
        }
    }
}

