/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.options;

import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.AlgorithmFactory;
import org.eclipse.elk.core.util.RandomLayoutProvider;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class RandomLayouterOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "org.eclipse.elk.random";
    private static final ElkPadding PADDING_DEFAULT = new ElkPadding(15.0);
    public static final IProperty<ElkPadding> PADDING = new Property(CoreOptions.PADDING, (Object)PADDING_DEFAULT);
    private static final double SPACING_NODE_NODE_DEFAULT = 15.0;
    public static final IProperty<Double> SPACING_NODE_NODE = new Property(CoreOptions.SPACING_NODE_NODE, (Object)15.0);
    private static final int RANDOM_SEED_DEFAULT = 0;
    public static final IProperty<Integer> RANDOM_SEED = new Property(CoreOptions.RANDOM_SEED, (Object)0);
    private static final double ASPECT_RATIO_DEFAULT = (double)1.6f;
    public static final IProperty<Double> ASPECT_RATIO = new Property(CoreOptions.ASPECT_RATIO, (Object)1.6f);

    @Override
    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData(ALGORITHM_ID, "Randomizer", "Distributes the nodes randomly on the plane, leading to very obfuscating layouts. Can be useful to demonstrate the power of \"real\" layout algorithms.", new AlgorithmFactory(RandomLayoutProvider.class, ""), null, "ELK", "images/random.png", null));
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.padding", PADDING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.nodeNode", 15.0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.randomSeed", 0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.aspectRatio", 1.6f);
    }
}

