/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.data;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutCategoryData;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.Pair;

public class LayoutMetaDataService {
    private static LayoutMetaDataService instance;
    private final Map<String, LayoutAlgorithmData> layoutAlgorithmMap = Maps.newLinkedHashMap();
    private final Map<String, LayoutOptionData> layoutOptionMap = Maps.newLinkedHashMap();
    private final Map<String, LayoutOptionData> legacyLayoutOptionMap = Maps.newLinkedHashMap();
    private final Map<String, LayoutCategoryData> layoutCategoryMap = Maps.newLinkedHashMap();
    private final Map<String, LayoutAlgorithmData> algorithmSuffixMap = Maps.newHashMap();
    private final Map<String, LayoutOptionData> optionSuffixMap = Maps.newHashMap();

    public static synchronized LayoutMetaDataService getInstance() {
        if (instance == null) {
            instance = new LayoutMetaDataService();
            instance.registerLayoutMetaDataProvider(new CoreOptions());
            try {
                Class.forName("org.eclipse.elk.core.service.ElkServicePlugin");
            }
            catch (Exception exception) {}
        }
        return instance;
    }

    public static synchronized void unload() {
        if (instance != null) {
            for (LayoutAlgorithmData algoData : instance.getAlgorithmData()) {
                algoData.getInstancePool().clear();
            }
            instance = null;
        }
    }

    public final void registerLayoutMetaDataProvider(ILayoutMetaDataProvider provider) {
        Registry registry = new Registry();
        provider.apply(registry);
        registry.applyDependencies();
    }

    public final LayoutAlgorithmData getAlgorithmData(String id) {
        return this.layoutAlgorithmMap.get(id);
    }

    public final Collection<LayoutAlgorithmData> getAlgorithmData() {
        return Collections.unmodifiableCollection(this.layoutAlgorithmMap.values());
    }

    public final LayoutAlgorithmData getAlgorithmDataBySuffix(String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return null;
        }
        LayoutAlgorithmData data = this.algorithmSuffixMap.get(suffix);
        if (data == null) {
            for (LayoutAlgorithmData d : this.layoutAlgorithmMap.values()) {
                String id = d.getId();
                if (!id.endsWith(suffix) || suffix.length() != id.length() && id.charAt(id.length() - suffix.length() - 1) != '.') continue;
                if (data != null) {
                    return null;
                }
                data = d;
            }
            if (data != null) {
                this.algorithmSuffixMap.put(suffix, data);
            }
        }
        return data;
    }

    public final LayoutAlgorithmData getAlgorithmDataOrDefault(String algorithmId, String defaultId) {
        String finalDefaultId = defaultId == null ? "" : defaultId;
        String finalAlgorithmId = algorithmId == null || algorithmId.isEmpty() ? finalDefaultId : algorithmId;
        LayoutAlgorithmData result = this.getAlgorithmData(finalAlgorithmId);
        if (result != null) {
            return result;
        }
        Collection<LayoutAlgorithmData> allAlgorithmData = this.getAlgorithmData();
        if (!allAlgorithmData.isEmpty()) {
            return allAlgorithmData.iterator().next();
        }
        return null;
    }

    public final LayoutOptionData getOptionData(String id) {
        LayoutOptionData data = this.layoutOptionMap.get(id);
        return data != null ? data : this.legacyLayoutOptionMap.get(id);
    }

    public final Collection<LayoutOptionData> getOptionData() {
        return Collections.unmodifiableCollection(this.layoutOptionMap.values());
    }

    public final LayoutOptionData getOptionDataBySuffix(String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return null;
        }
        LayoutOptionData data = this.optionSuffixMap.get(suffix);
        if (data == null) {
            for (LayoutOptionData d : this.layoutOptionMap.values()) {
                String id = d.getId();
                if (!id.endsWith(suffix) || suffix.length() != id.length() && id.charAt(id.length() - suffix.length() - 1) != '.') continue;
                if (data != null) {
                    return null;
                }
                data = d;
            }
            if (data == null) {
                for (LayoutOptionData d : this.layoutOptionMap.values()) {
                    String[] legacyIds = d.getLegacyIds();
                    if (legacyIds == null) continue;
                    String[] stringArray = legacyIds;
                    int n = legacyIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        if (id.endsWith(suffix) && (suffix.length() == id.length() || id.charAt(id.length() - suffix.length() - 1) == '.')) {
                            if (data != null) {
                                return null;
                            }
                            data = d;
                        }
                        ++n2;
                    }
                }
            }
            if (data != null) {
                this.optionSuffixMap.put(suffix, data);
            }
        }
        return data;
    }

    public final List<LayoutOptionData> getOptionData(LayoutAlgorithmData algorithmData, LayoutOptionData.Target targetType) {
        LinkedList<LayoutOptionData> optionDataList = new LinkedList<LayoutOptionData>();
        for (LayoutOptionData optionData : this.layoutOptionMap.values()) {
            if (!algorithmData.knowsOption(optionData) && !CoreOptions.ALGORITHM.equals((Object)optionData) || !optionData.getTargets().contains((Object)targetType)) continue;
            optionDataList.add(optionData);
        }
        return optionDataList;
    }

    public final LayoutCategoryData getCategoryData(String id) {
        return this.layoutCategoryMap.get(id);
    }

    public final Collection<LayoutCategoryData> getCategoryData() {
        return Collections.unmodifiableCollection(this.layoutCategoryMap.values());
    }

    private class Registry
    implements ILayoutMetaDataProvider.Registry {
        private final List<Triple> optionDependencies = new LinkedList<Triple>();
        private final List<Triple> optionSupport = new LinkedList<Triple>();

        private Registry() {
        }

        @Override
        public void register(LayoutAlgorithmData algorithmData) {
            LayoutMetaDataService.this.layoutAlgorithmMap.put(algorithmData.getId(), algorithmData);
        }

        @Override
        public void register(LayoutOptionData optionData) {
            String id = optionData.getId();
            LayoutMetaDataService.this.layoutOptionMap.put(id, optionData);
            if (optionData.getLegacyIds() != null) {
                String[] stringArray = optionData.getLegacyIds();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String legacyId = stringArray[n2];
                    LayoutMetaDataService.this.legacyLayoutOptionMap.put(legacyId, optionData);
                    ++n2;
                }
            }
        }

        @Override
        public void register(LayoutCategoryData categoryData) {
            LayoutMetaDataService.this.layoutCategoryMap.put(categoryData.getId(), categoryData);
        }

        @Override
        public void addDependency(String sourceOption, String targetOption, Object requiredValue) {
            Triple dep = new Triple();
            dep.firstId = sourceOption;
            dep.secondId = targetOption;
            dep.value = requiredValue;
            this.optionDependencies.add(dep);
        }

        @Override
        public void addOptionSupport(String algorithm, String option, Object defaultValue) {
            Triple sup = new Triple();
            sup.firstId = algorithm;
            sup.secondId = option;
            sup.value = defaultValue;
            this.optionSupport.add(sup);
        }

        private void applyDependencies() {
            for (LayoutAlgorithmData algorithm : LayoutMetaDataService.this.layoutAlgorithmMap.values()) {
                LayoutCategoryData category;
                String categoryId = algorithm.getCategoryId();
                if (categoryId == null) {
                    categoryId = "";
                }
                if ((category = LayoutMetaDataService.this.getCategoryData(categoryId)) == null && categoryId.isEmpty()) {
                    category = this.retrieveBackupCategory();
                }
                if (category == null || category.getLayouters().contains(algorithm)) continue;
                category.getLayouters().add(algorithm);
            }
            for (Triple dep : this.optionDependencies) {
                LayoutOptionData source = LayoutMetaDataService.this.getOptionData(dep.firstId);
                LayoutOptionData target = LayoutMetaDataService.this.getOptionData(dep.secondId);
                if (source == null || target == null) continue;
                source.getDependencies().add(Pair.of(target, dep.value));
            }
            this.optionDependencies.clear();
            for (Triple sup : this.optionSupport) {
                LayoutAlgorithmData algorithm = LayoutMetaDataService.this.getAlgorithmData(sup.firstId);
                LayoutOptionData option = LayoutMetaDataService.this.getOptionData(sup.secondId);
                if (algorithm == null || option == null) continue;
                algorithm.addKnownOption(option, sup.value);
            }
            this.optionSupport.clear();
        }

        private LayoutCategoryData retrieveBackupCategory() {
            LayoutCategoryData otherCategory = (LayoutCategoryData)LayoutMetaDataService.this.layoutCategoryMap.get("");
            if (otherCategory == null) {
                otherCategory = new LayoutCategoryData("", "Other", null);
                LayoutMetaDataService.this.layoutCategoryMap.put("", otherCategory);
            }
            return otherCategory;
        }

        private class Triple {
            private String firstId;
            private String secondId;
            private Object value;

            private Triple() {
            }
        }
    }
}

