/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.mdd;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.controllercheck.mdd.MddCifVarInfoBuilder;
import org.eclipse.escet.cif.controllercheck.mdd.MddSpecBuilder;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.output.DebugNormalOutput;
import org.eclipse.escet.common.multivaluetrees.Node;
import org.eclipse.escet.common.multivaluetrees.Tree;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifMddSpec {
    public static final int READ_INDEX = 0;
    public static final int WRITE_INDEX = 1;
    private static final int NUM_INDICES = 2;
    private final Termination termination;
    private final DebugNormalOutput normalOutput;
    private final DebugNormalOutput debugOutput;
    private List<Automaton> automata;
    private Set<Event> controllableEvents = Sets.set();
    private List<Declaration> variables;
    private Map<Event, Node> globalGuardsByEvent = Maps.map();
    private Map<Event, Set<Declaration>> updatedVariablesByEvent = Maps.map();
    private MddSpecBuilder builder;

    public CifMddSpec(Termination termination, DebugNormalOutput normalOutput, DebugNormalOutput debugOutput) {
        this.termination = termination;
        this.normalOutput = normalOutput;
        this.debugOutput = debugOutput;
    }

    public boolean compute(Specification spec) {
        this.automata = (List)CifCollectUtils.collectAutomata((ComplexComponent)spec, (Collection)Lists.list());
        Assert.check((!this.automata.isEmpty() ? 1 : 0) != 0);
        Set allControllableEvents = (Set)CifCollectUtils.collectControllableEvents((ComplexComponent)spec, (Collection)Sets.set());
        if (allControllableEvents.isEmpty()) {
            this.debugOutput.line("No controllable events.");
            return true;
        }
        this.variables = (List)CifCollectUtils.collectDiscAndInputVariables((ComplexComponent)spec, (Collection)Lists.list());
        if (this.termination.isRequested()) {
            return false;
        }
        MddCifVarInfoBuilder cifVarInfoBuilder = new MddCifVarInfoBuilder(2);
        cifVarInfoBuilder.addVariablesGroupOnVariable(this.variables);
        this.builder = new MddSpecBuilder(cifVarInfoBuilder, 0, 1);
        if (this.termination.isRequested()) {
            return false;
        }
        boolean first = true;
        for (Automaton aut : this.automata) {
            if (!first) {
                this.debugOutput.line();
            }
            first = false;
            this.debugOutput.line("Analyzing %s:", new Object[]{CifTextUtils.getComponentText1((ComplexComponent)aut)});
            Set controllableAutEvents = Sets.intersection((Set)CifEventUtils.getAlphabet((Automaton)aut), (Set)allControllableEvents);
            if (this.processAutomaton(aut, controllableAutEvents)) continue;
            return false;
        }
        return true;
    }

    private boolean processAutomaton(Automaton aut, Set<Event> controllableAutEvents) {
        Tree tree = this.builder.tree;
        Map autGuards = Maps.mapc((int)controllableAutEvents.size());
        this.debugOutput.inc();
        boolean debugPrinted = false;
        for (Event evt : controllableAutEvents) {
            this.debugOutput.line("Initializing the automaton data for event \"%s\".", new Object[]{CifTextUtils.getAbsName((PositionObject)evt)});
            debugPrinted = true;
            autGuards.put(evt, Tree.ZERO);
            if (!this.controllableEvents.contains(evt)) {
                this.controllableEvents.add(evt);
                this.globalGuardsByEvent.put(evt, Tree.ONE);
                this.updatedVariablesByEvent.put(evt, Sets.set());
            }
            if (!this.termination.isRequested()) continue;
            this.debugOutput.dec();
            return false;
        }
        if (!controllableAutEvents.isEmpty()) {
            for (Location loc : aut.getLocations()) {
                this.debugOutput.line("Processing edges from %s.", new Object[]{CifTextUtils.getLocationText2((Location)loc)});
                debugPrinted = true;
                for (Edge edge : loc.getEdges()) {
                    Set controllableEdgeEvents = Sets.intersection((Set)CifEventUtils.getEvents((Edge)edge), controllableAutEvents);
                    if (controllableEdgeEvents.isEmpty()) continue;
                    Node guard = this.computeGuard(edge);
                    if (this.termination.isRequested()) {
                        this.debugOutput.dec();
                        return false;
                    }
                    this.markUpdatedVars(edge, controllableEdgeEvents);
                    if (this.termination.isRequested()) {
                        this.debugOutput.dec();
                        return false;
                    }
                    for (Event evt : controllableEdgeEvents) {
                        Node autGuard = (Node)autGuards.get(evt);
                        autGuards.put(evt, tree.disjunct(autGuard, guard));
                        if (!this.termination.isRequested()) continue;
                        this.debugOutput.dec();
                        return false;
                    }
                }
            }
        }
        for (Event autEvent : controllableAutEvents) {
            this.debugOutput.line("Updating global guards for event \"%s\".", new Object[]{CifTextUtils.getAbsName((PositionObject)autEvent)});
            debugPrinted = true;
            Node globGuard = this.globalGuardsByEvent.get(autEvent);
            this.globalGuardsByEvent.put(autEvent, tree.conjunct(globGuard, (Node)autGuards.get(autEvent)));
            if (!this.termination.isRequested()) continue;
            this.debugOutput.dec();
            return false;
        }
        if (!debugPrinted) {
            this.debugOutput.line("Nothing to process.");
        }
        this.debugOutput.dec();
        return true;
    }

    private Node computeGuard(Edge edge) {
        Node guard = Tree.ONE;
        for (Expression grd : edge.getGuards()) {
            Node node = this.builder.getExpressionConvertor().convert(grd).get(1);
            if (this.termination.isRequested()) {
                return guard;
            }
            guard = this.builder.tree.conjunct(guard, node);
            if (!this.termination.isRequested()) continue;
            return guard;
        }
        return guard;
    }

    private void markUpdatedVars(Edge edge, Set<Event> controllableEdgeEvents) {
        Set assignedVariables = Sets.set();
        for (Update upd : edge.getUpdates()) {
            Assert.check((boolean)(upd instanceof Assignment));
            Assignment asg = (Assignment)upd;
            Assert.check((boolean)(asg.getAddressable() instanceof DiscVariableExpression));
            DiscVariable lhs = ((DiscVariableExpression)asg.getAddressable()).getVariable();
            assignedVariables.add(lhs);
        }
        for (Event evt : controllableEdgeEvents) {
            this.updatedVariablesByEvent.get(evt).addAll(assignedVariables);
        }
    }

    public Termination getTermination() {
        return this.termination;
    }

    public DebugNormalOutput getDebugOutput() {
        return this.debugOutput;
    }

    public DebugNormalOutput getNormalOutput() {
        return this.normalOutput;
    }

    public List<Automaton> getAutomata() {
        return Collections.unmodifiableList(this.automata);
    }

    public Set<Event> getControllableEvents() {
        return Collections.unmodifiableSet(this.controllableEvents);
    }

    public Map<Event, Node> getGlobalGuardsByEvent() {
        return Collections.unmodifiableMap(this.globalGuardsByEvent);
    }

    public Map<Event, Set<Declaration>> getUpdatedVariablesByEvent() {
        return Collections.unmodifiableMap(this.updatedVariablesByEvent);
    }

    public MddSpecBuilder getBuilder() {
        return this.builder;
    }
}

