/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class ProcessingIterator<E>
implements Iterator<E> {
    private static final Object DONE = new Object(){};
    private static final Object CONSUMED = new Object(){};
    private static final Object INITIAL = new Object(){};
    private Object next = INITIAL;

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public boolean hasNext() {
        return DONE != this.prepareNext();
    }

    @Override
    public E next() {
        Object n = this.prepareNext();
        if (DONE == n) {
            throw new NoSuchElementException();
        }
        this.next = CONSUMED;
        return (E)n;
    }

    private Object prepareNext() {
        if (CONSUMED == this.next || INITIAL == this.next) {
            this.toNext();
        }
        if (CONSUMED == this.next || INITIAL == this.next) {
            throw new IllegalStateException("Either call setNext() or done() from toNext()");
        }
        return this.next;
    }

    protected boolean isFirst() {
        return this.next == INITIAL;
    }

    protected abstract boolean toNext();

    protected final boolean setNext(E next) {
        if (CONSUMED != this.next && INITIAL != this.next) {
            throw new IllegalStateException("Only call setNext() from toNext(): iterator was not consumed yet.");
        }
        this.next = next;
        return true;
    }

    protected final boolean done() {
        if (CONSUMED != this.next && INITIAL != this.next) {
            throw new IllegalStateException("Only call done() from toNext(): iterator was not consumed yet.");
        }
        this.next = DONE;
        return false;
    }

    protected E peek() {
        Object n = this.prepareNext();
        if (DONE == n) {
            throw new NoSuchElementException();
        }
        return (E)n;
    }

    protected void skip() {
        Object n = this.prepareNext();
        if (DONE == n) {
            throw new NoSuchElementException();
        }
        this.next = CONSUMED;
    }
}

