/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p4nodes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.layered.ILayoutPhase;
import org.eclipse.elk.alg.layered.IntermediateProcessingConfiguration;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.networksimplex.NEdge;
import org.eclipse.elk.alg.layered.networksimplex.NGraph;
import org.eclipse.elk.alg.layered.networksimplex.NNode;
import org.eclipse.elk.alg.layered.networksimplex.NetworkSimplex;
import org.eclipse.elk.alg.layered.properties.GraphProperties;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.alg.layered.properties.Spacings;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class NetworkSimplexPlacer
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration HIERARCHY_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase5(IntermediateProcessorStrategy.HIERARCHICAL_PORT_POSITION_PROCESSOR);
    private static final IProperty<NNode> EDGE_NNODE = new Property("nodePlace.ns.edgeNNode");
    private static final double SMALL_EDGE_WEIGHT = (double)0.1f;
    private LGraph lGraph;
    private int nodeCount;
    private int[] nodeState;
    private static final int VISITED = -1;
    private static final int OTHER = 0;
    private static final int JUNCTION = 2;
    private static final int LEAF = 1;

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        if (((Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            return HIERARCHY_PROCESSING_ADDITIONS;
        }
        return null;
    }

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Network simplex node placement", 1.0f);
        this.lGraph = layeredGraph;
        NGraph nGraph = this.buildAuxiliaryGraph();
        if (((Boolean)layeredGraph.getProperty(LayeredOptions.NODE_PLACEMENT_FAVOR_STRAIGHT_EDGES)).booleanValue()) {
            this.insertStraighteningDummyNodes(nGraph);
        }
        int iterLimit = (Integer)layeredGraph.getProperty(LayeredOptions.THOROUGHNESS) * nGraph.nodes.size();
        NetworkSimplex.forGraph(nGraph).withIterationLimit(iterLimit).withBalancing(false).execute(progressMonitor.subTask(1.0f));
        for (NNode n : nGraph.nodes) {
            if (n.origin == null) continue;
            LNode lNode = (LNode)((Object)n.origin);
            lNode.getPosition().y = (double)n.layer + lNode.getMargin().top;
        }
        progressMonitor.done();
    }

    private NGraph buildAuxiliaryGraph() {
        NEdge nEdge;
        Spacings spacings = (Spacings)this.lGraph.getProperty(InternalProperties.SPACINGS);
        HashMap nodeMap = Maps.newHashMap();
        NGraph graph = new NGraph();
        int nodeCnt = 0;
        for (Layer l : this.lGraph) {
            LNode prevL = null;
            NNode prev = null;
            for (LNode lNode : l) {
                ++nodeCnt;
                NNode nNode = NNode.of().create(graph);
                nNode.origin = lNode;
                nodeMap.put(lNode, nNode);
                lNode.getMargin().top = Math.ceil(lNode.getMargin().top);
                if (prev != null) {
                    nEdge = new NEdge();
                    nEdge.weight = this.isConnectedByInlayerEdge(prevL, lNode) ? (double)0.1f : 0.0;
                    nEdge.delta = (int)Math.floor(prevL.getMargin().top + prevL.getSize().y + prevL.getMargin().bottom + spacings.getVerticalSpacing((LNode)((Object)prev.origin), lNode));
                    nEdge.source = prev;
                    nEdge.target = nNode;
                    prev.getOutgoingEdges().add(nEdge);
                    nNode.getIncomingEdges().add(nEdge);
                }
                prevL = lNode;
                prev = nNode;
            }
        }
        this.nodeCount = nodeCnt;
        for (Layer l : this.lGraph) {
            for (LNode lNode : l) {
                for (LPort p : lNode.getPorts()) {
                    double y = p.getPosition().y + p.getAnchor().y;
                    if (y == Math.floor(y)) continue;
                    double offset = y - (double)Math.round(y);
                    p.getPosition().y -= offset;
                }
            }
        }
        for (Layer l : this.lGraph.getLayers()) {
            for (LNode lNode : l.getNodes()) {
                for (LEdge lEdge : lNode.getOutgoingEdges()) {
                    if (!this.isHandledEdge(lEdge)) continue;
                    double sourceY = lEdge.getSource().getNode().getMargin().top + lEdge.getSource().getPosition().y + lEdge.getSource().getAnchor().y;
                    double targetY = lEdge.getTarget().getNode().getMargin().top + lEdge.getTarget().getPosition().y + lEdge.getTarget().getAnchor().y;
                    double delta = targetY - sourceY;
                    int portOffset = (int)delta;
                    assert (delta == Math.floor(delta));
                    NNode dummy = NNode.of().create(graph);
                    lEdge.setProperty(EDGE_NNODE, dummy);
                    NEdge leftEdge = new NEdge();
                    leftEdge.origin = lEdge;
                    leftEdge.weight = this.getEdgeWeight(lEdge);
                    leftEdge.delta = portOffset > 0 ? portOffset : 0;
                    leftEdge.source = dummy;
                    leftEdge.target = (NNode)nodeMap.get((Object)lEdge.getSource().getNode());
                    leftEdge.source.getOutgoingEdges().add(leftEdge);
                    leftEdge.target.getIncomingEdges().add(leftEdge);
                    NEdge rightEdge = new NEdge();
                    rightEdge.origin = lEdge;
                    rightEdge.weight = this.getEdgeWeight(lEdge);
                    rightEdge.delta = portOffset < 0 ? -portOffset : 0;
                    rightEdge.source = dummy;
                    rightEdge.target = (NNode)nodeMap.get((Object)lEdge.getTarget().getNode());
                    rightEdge.source.getOutgoingEdges().add(rightEdge);
                    rightEdge.target.getIncomingEdges().add(rightEdge);
                }
            }
        }
        for (Layer l : this.lGraph.getLayers()) {
            for (LNode n : l.getNodes()) {
                LNode other;
                for (LPort sp : n.getPortSideView(PortSide.SOUTH)) {
                    other = (LNode)((Object)sp.getProperty(InternalProperties.PORT_DUMMY));
                    if (other == null) continue;
                    nEdge = new NEdge();
                    nEdge.delta = 0;
                    nEdge.weight = 0.1f;
                    nEdge.source = (NNode)nodeMap.get((Object)n);
                    nEdge.target = (NNode)nodeMap.get((Object)other);
                    nEdge.source.getOutgoingEdges().add(nEdge);
                    nEdge.target.getIncomingEdges().add(nEdge);
                }
                for (LPort sp : n.getPortSideView(PortSide.NORTH)) {
                    other = (LNode)((Object)sp.getProperty(InternalProperties.PORT_DUMMY));
                    if (other == null) continue;
                    nEdge = new NEdge();
                    nEdge.delta = 0;
                    nEdge.weight = 0.1f;
                    nEdge.source = (NNode)nodeMap.get((Object)other);
                    nEdge.target = (NNode)nodeMap.get((Object)n);
                    nEdge.source.getOutgoingEdges().add(nEdge);
                    nEdge.target.getIncomingEdges().add(nEdge);
                }
            }
        }
        return graph;
    }

    private int getEdgeWeight(LEdge edge) {
        int priority = Math.max(1, (Integer)edge.getProperty(LayeredOptions.PRIORITY_STRAIGHTNESS));
        int edgeTypeWeight = edge.getSource().getNode().getType() == LNode.NodeType.NORMAL && edge.getTarget().getNode().getType() == LNode.NodeType.NORMAL ? 1 : (edge.getSource().getNode().getType() == LNode.NodeType.NORMAL || edge.getTarget().getNode().getType() == LNode.NodeType.NORMAL ? 2 : 8);
        return priority * edgeTypeWeight;
    }

    private boolean isHandledEdge(LEdge edge) {
        return !edge.isSelfLoop() && edge.getTarget().getNode().getLayer() != edge.getSource().getNode().getLayer();
    }

    private boolean isConnectedByInlayerEdge(LNode n1, LNode n2) {
        if (n1.getType() == LNode.NodeType.NORMAL && n2.getType() == LNode.NodeType.NORMAL) {
            return false;
        }
        for (LEdge e : n1.getConnectedEdges()) {
            if (!e.isInLayerEdge() || e.getOther(n1) != n2) continue;
            return true;
        }
        return false;
    }

    private void insertStraighteningDummyNodes(NGraph nGraph) {
        int index = 0;
        this.nodeState = new int[this.nodeCount];
        for (Layer l : this.lGraph.getLayers()) {
            for (LNode n : l.getNodes()) {
                n.id = index++;
                this.nodeState[n.id] = NetworkSimplexPlacer.getNodeState(n);
            }
        }
        List<List<LEdge>> paths = this.identifyPaths();
        for (List<LEdge> path : paths) {
            Iterator<LEdge> pathIt = path.iterator();
            if (!pathIt.hasNext()) continue;
            LEdge last = pathIt.next();
            while (pathIt.hasNext()) {
                LEdge cur = pathIt.next();
                NNode one = (NNode)cur.getProperty(EDGE_NNODE);
                NNode two = (NNode)last.getProperty(EDGE_NNODE);
                NNode dummy = NNode.of().create(nGraph);
                NEdge leftEdge = new NEdge();
                leftEdge.weight = 1.0;
                leftEdge.delta = 0;
                leftEdge.source = dummy;
                leftEdge.target = one;
                leftEdge.source.getOutgoingEdges().add(leftEdge);
                leftEdge.target.getIncomingEdges().add(leftEdge);
                NEdge rightEdge = new NEdge();
                rightEdge.weight = 1.0;
                rightEdge.delta = 0;
                rightEdge.source = dummy;
                rightEdge.target = two;
                rightEdge.source.getOutgoingEdges().add(rightEdge);
                rightEdge.target.getIncomingEdges().add(rightEdge);
                last = cur;
            }
        }
    }

    private List<List<LEdge>> identifyPaths() {
        ArrayList paths = Lists.newArrayList();
        for (Layer l : this.lGraph.getLayers()) {
            for (LNode n : l.getNodes()) {
                if (this.nodeState[n.id] != 2) continue;
                for (LEdge e : n.getConnectedEdges()) {
                    if (!this.isHandledEdge(e)) continue;
                    LNode other = e.getOther(n);
                    if (this.nodeState[other.id] == -1 || this.nodeState[other.id] == 2) continue;
                    ArrayList seq = Lists.newArrayList((Object[])new LEdge[]{e});
                    boolean valid = this.follow(other, n, seq);
                    if (valid && seq.size() >= 2) {
                        paths.add(seq);
                    }
                    this.nodeState[other.id] = -1;
                }
            }
        }
        return paths;
    }

    private boolean follow(LNode curr, LNode prev, List<LEdge> seq) {
        if (this.nodeState[curr.id] == 2) {
            return true;
        }
        for (LEdge incident : curr.getConnectedEdges()) {
            LNode otherOther;
            if (!this.isHandledEdge(incident) || (otherOther = incident.getOther(curr)) == prev) continue;
            seq.add(incident);
            if (this.nodeState[otherOther.id] != -1) {
                return this.follow(otherOther, curr, seq);
            }
            this.nodeState[otherOther.id] = -1;
        }
        return false;
    }

    private static int getNodeState(LNode node) {
        int inco = 0;
        int ouco = 0;
        for (LPort p : node.getPorts()) {
            if ((inco += p.getIncomingEdges().size()) <= 1 && (ouco += p.getOutgoingEdges().size()) <= 1) continue;
            return 2;
        }
        if (inco + ouco == 1) {
            return 1;
        }
        return 0;
    }
}

