/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.scheduler.ui;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import machine.Machine;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsat.common.emf.common.util.URIHelper;
import org.eclipse.lsat.common.emf.ecore.resource.Persistor;
import org.eclipse.lsat.common.emf.ecore.resource.PersistorFactory;
import org.eclipse.lsat.scheduler.SortMachine;
import org.eclipse.lsat.scheduler.SortSettings;
import org.eclipse.xtext.resource.SaveOptions;
import setting.Settings;

public class SortJob
extends Job {
    private final IFile modelIFile;

    public SortJob(IFile modelIFile) {
        super("Sort specification");
        this.modelIFile = modelIFile;
    }

    private void refresEclipsehWorkspaces() throws CoreException {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            project.refreshLocal(2, null);
            ++n2;
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Sorting...", 100);
            URI modelURI = URIHelper.asURI((IResource)this.modelIFile);
            monitor.subTask("Sorting " + modelURI.lastSegment());
            PersistorFactory factory = new PersistorFactory();
            switch (modelURI.fileExtension()) {
                case "machine": {
                    Persistor machinePersistor = factory.getPersistor(Machine.class);
                    Machine machine = (Machine)new SortMachine().transformModel((Object)((Machine)machinePersistor.loadOne(modelURI)), monitor);
                    machine.eResource().save(SaveOptions.newBuilder().format().getOptions().toOptionsMap());
                    break;
                }
                case "setting": {
                    Persistor settingsPersistor = factory.getPersistor(Settings.class);
                    Settings settings = (Settings)new SortSettings().transformModel((Object)((Settings)settingsPersistor.loadOne(modelURI)), monitor);
                    settings.eResource().save(SaveOptions.newBuilder().format().getOptions().toOptionsMap());
                    break;
                }
                case "etf": {
                    List<String> lines = Files.readAllLines(Paths.get(this.modelIFile.getRawLocation().toOSString(), new String[0]));
                    Collections.sort(lines);
                    String sortedOutputFilenamePath = this.modelIFile.getRawLocation().removeFileExtension().toOSString() + ".sorted";
                    Files.write(Paths.get(sortedOutputFilenamePath, new String[0]), lines, new OpenOption[0]);
                    this.refresEclipsehWorkspaces();
                    break;
                }
                default: {
                    throw new Exception("Unknown file extension to sort: " + modelURI.fileExtension());
                }
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.lsat.scheduler.ui", e.getMessage(), (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }
}

