/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.conformance.internal;

import activity.TracePoint;
import org.eclipse.lsat.trace.TraceLine;

public class UniqueTracePoint {
    private final TracePoint delegate;

    public static UniqueTracePoint create(TracePoint tracePoint) {
        if (tracePoint == null) {
            return null;
        }
        return new UniqueTracePoint(tracePoint);
    }

    public static boolean matchesOneOf(TraceLine traceLine, Iterable<UniqueTracePoint> tracePoints) {
        for (UniqueTracePoint uTracePoint : tracePoints) {
            if (!UniqueTracePoint.matches(traceLine, uTracePoint)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(TraceLine traceLine, UniqueTracePoint tracePoint) {
        return UniqueTracePoint.matches(traceLine, tracePoint == null ? null : tracePoint.delegate);
    }

    public static boolean matches(TraceLine traceLine, TracePoint tracePoint) {
        if (tracePoint == null && traceLine == null) {
            return true;
        }
        if (tracePoint != null && traceLine != null) {
            return tracePoint.isRegex() ? traceLine.getTracePoint().matches(tracePoint.getValue()) : traceLine.getTracePoint().endsWith(tracePoint.getValue());
        }
        return false;
    }

    private UniqueTracePoint(TracePoint delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Null not allowed!");
        }
        this.delegate = delegate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate.isRegex() ? 1231 : 1237);
        result = 31 * result + (this.delegate.getValue() == null ? 0 : this.delegate.getValue().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UniqueTracePoint other = (UniqueTracePoint)obj;
        if (this.delegate.isRegex() != other.delegate.isRegex()) {
            return false;
        }
        return !(this.delegate.getValue() == null ? other.delegate.getValue() != null : !this.delegate.getValue().equals(other.delegate.getValue()));
    }
}

