/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;
import org.eclipse.lsat.common.ludus.backend.games.GameGraph;

public class StrategyVector<V, E> {
    private Map<V, V> strategyVector;

    public StrategyVector() {
        this.strategyVector = new HashMap<V, V>();
    }

    public StrategyVector(StrategyVector<V, E> vector) {
        this.strategyVector = new HashMap<V, V>(vector.strategyVector);
    }

    public void initializeRandomStrategy(GameGraph<V, E> graph) {
        graph.getVertices().stream().forEach(v -> {
            Object e = graph.outgoingEdgesOf(v).iterator().next();
            this.strategyVector.put(v, graph.getEdgeTarget(e));
        });
    }

    public void setSuccessor(V v, V successor) {
        this.strategyVector.put(v, successor);
    }

    public V getSuccessor(V v) {
        return this.strategyVector.get(v);
    }

    public Set<V> getVertices() {
        return this.strategyVector.keySet();
    }

    public Map<V, V> getMap() {
        return this.strategyVector;
    }

    public static <V, E> Tuple<List<V>, V> getPath(StrategyVector<V, E> vector, V initialVertex) {
        ArrayList<V> path = new ArrayList<V>();
        V current = initialVertex;
        while (!path.contains(vector.getSuccessor(current))) {
            V succ = vector.getSuccessor(current);
            path.add(succ);
            current = succ;
        }
        return Tuple.of(path, vector.getSuccessor(current));
    }

    public static <V, E> List<V> getCycle(StrategyVector<V, E> vector, V initialVertex) {
        ArrayList<V> path = new ArrayList<V>();
        V current = initialVertex;
        while (!path.contains(vector.getSuccessor(current))) {
            V succ = vector.getSuccessor(current);
            path.add(succ);
            current = succ;
        }
        V handle = vector.getSuccessor(current);
        List cycleList = path.subList(path.indexOf(handle), path.size() - 1);
        return cycleList;
    }
}

