/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.io.IOException;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.contentmodel.BaseFileTempTest;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSchemaErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lsp4j.Diagnostic;
import org.junit.jupiter.api.Test;

public class XMLValidationPoolCacheTest
extends BaseFileTempTest {
    @Test
    public void twoNoNamespaceSchemaLocation() {
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        String xml = "<money xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/money.xsd\" currency=\"euros\"> </money>";
        Diagnostic d = XMLAssert.d(0, 143, 0, 144, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_1);
        XMLValidationPoolCacheTest.testDiagnosticsFor(xmlLanguageService, xml, d);
        XMLValidationPoolCacheTest.testDiagnosticsFor(xmlLanguageService, xml, d);
        xml = "<Annotation\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"src/test/resources/xsd/pattern.xsd\"\r\n\tTerm=\"X\"></Annotation>";
        Diagnostic patternValid = XMLAssert.d(3, 6, 3, 9, (IXMLErrorCode)XMLSchemaErrorCode.cvc_pattern_valid);
        Diagnostic cvcAttribute3 = XMLAssert.d(3, 6, 3, 9, (IXMLErrorCode)XMLSchemaErrorCode.cvc_attribute_3);
        XMLValidationPoolCacheTest.testDiagnosticsFor(xmlLanguageService, xml, patternValid, cvcAttribute3);
    }

    @Test
    public void includedSchemaLocation() throws IOException {
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        String schemaAPath = tempDirUri.getPath() + "/SchemaA.xsd";
        String schemaA = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<xs:schema id=\"tns\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\r\n\t<xs:include schemaLocation=\"SchemaB.xsd\" />\r\n\r\n\t<xs:complexType name=\"Bar\">\r\n\t\t<xs:sequence>\r\n\t\t\t<xs:element name=\"FooBar\" type=\"xs:string\" />\r\n\t\t\t<xs:element ref=\"AType\" />\r\n\t\t</xs:sequence>\r\n\t</xs:complexType>\r\n\r\n\t<xs:complexType name=\"Root\">\r\n\t\t<xs:sequence>\r\n\t\t\t<xs:element name=\"Bar\" type=\"Bar\" minOccurs=\"1\" maxOccurs=\"unbounded\" />\r\n\t\t</xs:sequence>\r\n\t</xs:complexType>\r\n\r\n\t<xs:element name=\"Root\" type=\"Root\"></xs:element>\r\n</xs:schema>";
        XMLValidationPoolCacheTest.createFile(schemaAPath, schemaA);
        String schemaBPath = tempDirUri.getPath() + "/SchemaB.xsd";
        String schemaB = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\r\n\r\n\t<xs:element name=\"AType\">\r\n\t\t<xs:complexType>\r\n\t\t\t<xs:sequence>\r\n\t\t\t\t<xs:element name=\"XMLElement\" type=\"xs:string\" />\r\n\t\t\t</xs:sequence>\r\n\t\t</xs:complexType>\r\n\t</xs:element>\r\n\r\n</xs:schema>";
        XMLValidationPoolCacheTest.createFile(schemaBPath, schemaB);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<Root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"" + schemaAPath + "\">\r\n\t<Bar>\r\n\t\t\r\n\t</Bar>\r\n</Root>";
        Diagnostic d = XMLAssert.d(2, 2, 5, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_b);
        XMLValidationPoolCacheTest.testDiagnosticsFor(xmlLanguageService, xml, d);
        schemaA = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<xs:schema id=\"tns\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\r\n\t<xs:include schemaLocation=\"SchemaB.xsd\" />\r\n\r\n\t<xs:complexType name=\"Bar\">\r\n\t</xs:complexType>\r\n\r\n\t<xs:complexType name=\"Root\">\r\n\t\t<xs:sequence>\r\n\t\t\t<xs:element name=\"Bar\" type=\"Bar\" minOccurs=\"1\" maxOccurs=\"unbounded\" />\r\n\t\t</xs:sequence>\r\n\t</xs:complexType>\r\n\r\n\t<xs:element name=\"Root\" type=\"Root\"></xs:element>\r\n</xs:schema>";
        XMLValidationPoolCacheTest.updateFile(schemaAPath, schemaA);
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<Root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"" + schemaAPath + "\">\r\n\t<Bar>\r\n\t\t\r\n\t</Bar>\r\n</Root>";
        d = XMLAssert.d(2, 6, 4, 1, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_1);
        XMLValidationPoolCacheTest.testDiagnosticsFor(xmlLanguageService, xml, d);
        schemaA = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<xs:schema id=\"tns\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\">\r\n\t<xs:include schemaLocation=\"SchemaB.xsd\" />\r\n\r\n\t<xs:complexType name=\"Bar\">\r\n\t\t<xs:sequence>\r\n\t\t\t<xs:element name=\"FooBar\" type=\"xs:string\" />\r\n\t\t\t<xs:element ref=\"AType\" />\r\n\t\t</xs:sequence>\r\n\t</xs:complexType>\r\n\r\n\t<xs:complexType name=\"Root\">\r\n\t\t<xs:sequence>\r\n\t\t\t<xs:element name=\"Bar\" type=\"Bar\" minOccurs=\"1\" maxOccurs=\"unbounded\" />\r\n\t\t</xs:sequence>\r\n\t</xs:complexType>\r\n\r\n\t<xs:element name=\"Root\" type=\"Root\"></xs:element>\r\n</xs:schema>";
        XMLValidationPoolCacheTest.updateFile(schemaAPath, schemaA);
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<Root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"" + schemaAPath + "\">\r\n\t<Bar>\r\n\t\t<FooBar></FooBar>\r\n\t\t<AType>\r\n\t\t\t\r\n\t\t</AType>\r\n\t</Bar>\r\n</Root> ";
        d = XMLAssert.d(4, 3, 8, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_b);
        XMLValidationPoolCacheTest.testDiagnosticsFor(xmlLanguageService, xml, d);
        schemaB = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\r\n\r\n\t<xs:element name=\"AType\">\r\n\t\t<xs:complexType>\r\n\t\t</xs:complexType>\r\n\t</xs:element>\r\n\r\n</xs:schema>";
        XMLValidationPoolCacheTest.updateFile(schemaBPath, schemaB);
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<Root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"" + schemaAPath + "\">\r\n\t<Bar>\r\n\t\t<FooBar></FooBar>\r\n\t\t<AType>\r\n\t\t\t\r\n\t\t</AType>\r\n\t</Bar>\r\n</Root> ";
        d = XMLAssert.d(4, 9, 6, 2, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_1);
        XMLValidationPoolCacheTest.testDiagnosticsFor(xmlLanguageService, xml, d);
    }

    @Test
    public void dtdELEMENT() throws IOException {
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        String dtdPath = tempDirUri.getPath() + "/note.dtd";
        String dtd = "<!ELEMENT note (to)>\r\n<!ELEMENT to (#PCDATA)>\r\n";
        XMLValidationPoolCacheTest.createFile(dtdPath, dtd);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE note SYSTEM \"" + dtdPath + "\">\r\n<note>\r\n</note>";
        Diagnostic d = XMLAssert.d(2, 1, 5, (IXMLErrorCode)DTDErrorCode.MSG_CONTENT_INCOMPLETE);
        XMLValidationPoolCacheTest.testDiagnosticsFor(xmlLanguageService, xml, d);
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE note SYSTEM \"" + dtdPath + "\">\r\n<note>\r\n <to>Tove</to> \r\n</note>";
        XMLValidationPoolCacheTest.testDiagnosticsFor(xmlLanguageService, xml, new Diagnostic[0]);
        dtd = "<!ELEMENT note (to,from)>\r\n<!ELEMENT to (#PCDATA)>\r\n";
        XMLValidationPoolCacheTest.updateFile(dtdPath, dtd);
        d = XMLAssert.d(2, 1, 5, (IXMLErrorCode)DTDErrorCode.MSG_CONTENT_INCOMPLETE);
        XMLValidationPoolCacheTest.testDiagnosticsFor(xmlLanguageService, xml, d);
    }

    @Test
    public void dtdENTITY() throws IOException {
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        String dtdPath = tempDirUri.getPath() + "/base.dtd";
        String dtd = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<!ELEMENT root-element (#PCDATA)>\r\n<!ENTITY external \"EXTERNALLY DECLARED ENTITY\">";
        XMLValidationPoolCacheTest.createFile(dtdPath, dtd);
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<!DOCTYPE root-element SYSTEM \"" + dtdPath + "\" [\r\n<!ENTITY local \"LOCALLY DECLARED ENTITY\">\r\n]>\r\n<root-element>\r\n&local;\r\n&external;\r\n&undeclared;\r\n</root-element>";
        Diagnostic d1 = XMLAssert.d(7, 0, 12, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared);
        XMLValidationPoolCacheTest.testDiagnosticsFor(xmlLanguageService, xml, d1);
        XMLValidationPoolCacheTest.testDiagnosticsFor(xmlLanguageService, xml, d1);
        dtd = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<!ELEMENT root-element (#PCDATA)>\r\n<!ENTITY undeclared \"undeclared\" >\r\n<!ENTITY external \"EXTERNALLY DECLARED ENTITY\">";
        XMLValidationPoolCacheTest.updateFile(dtdPath, dtd);
        XMLValidationPoolCacheTest.testDiagnosticsFor(xmlLanguageService, xml, new Diagnostic[0]);
        XMLValidationPoolCacheTest.testDiagnosticsFor(xmlLanguageService, xml, new Diagnostic[0]);
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<!DOCTYPE root-element SYSTEM \"" + dtdPath + "\" [\r\n]>\r\n<root-element>\r\n&local;\r\n&external;\r\n&undeclared;\r\n</root-element>";
        Diagnostic d2 = XMLAssert.d(4, 0, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared);
        XMLValidationPoolCacheTest.testDiagnosticsFor(xmlLanguageService, xml, d2);
    }

    private static void testDiagnosticsFor(XMLLanguageService xmlLanguageService, String xml, Diagnostic ... expected) {
        String catalogPath = "src/test/resources/catalogs/catalog.xml";
        ContentModelSettings settings = new ContentModelSettings();
        XMLAssert.testDiagnosticsFor(xmlLanguageService, xml, catalogPath, null, null, true, settings, expected);
    }
}

