/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.customservice.AutoCloseTagResponse;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.parser.Scanner;
import org.eclipse.lemminx.dom.parser.ScannerState;
import org.eclipse.lemminx.dom.parser.TokenType;
import org.eclipse.lemminx.dom.parser.XMLScanner;
import org.eclipse.lemminx.extensions.prolog.PrologModel;
import org.eclipse.lemminx.services.CompletionRequest;
import org.eclipse.lemminx.services.CompletionResponse;
import org.eclipse.lemminx.services.extensions.ICompletionParticipant;
import org.eclipse.lemminx.services.extensions.ICompletionRequest;
import org.eclipse.lemminx.services.extensions.ICompletionResponse;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class XMLCompletions {
    private static final Logger LOGGER = Logger.getLogger(XMLCompletions.class.getName());
    private static final Pattern regionCompletionRegExpr = Pattern.compile("^(\\s*)(<(!(-(-\\s*(#\\w*)?)?)?)?)?$");
    private final XMLExtensionsRegistry extensionsRegistry;

    public XMLCompletions(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public CompletionList doComplete(DOMDocument xmlDocument, Position position, SharedSettings settings, CancelChecker cancelChecker) {
        CompletionResponse completionResponse = new CompletionResponse();
        CompletionRequest completionRequest = null;
        try {
            completionRequest = new CompletionRequest(xmlDocument, position, settings, this.extensionsRegistry);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Creation of CompletionRequest failed", e);
            return completionResponse;
        }
        int offset = completionRequest.getOffset();
        DOMNode node = completionRequest.getNode();
        String text = xmlDocument.getText();
        if (text.isEmpty()) {
            this.collectInsideContent(completionRequest, completionResponse);
            return completionResponse;
        }
        Scanner scanner = XMLScanner.createScanner(text, node.getStart(), XMLCompletions.isInsideDTDContent(node, xmlDocument));
        String currentTag = "";
        TokenType token = scanner.scan();
        while (token != TokenType.EOS && scanner.getTokenOffset() <= offset) {
            cancelChecker.checkCanceled();
            block4 : switch (token) {
                case StartTagOpen: {
                    if (scanner.getTokenEnd() == offset) {
                        int endPos = XMLCompletions.scanNextForEndPos(offset, scanner, TokenType.StartTag);
                        this.collectTagSuggestions(offset, endPos, completionRequest, completionResponse);
                        this.collectCDATACompletion(completionRequest, completionResponse);
                        this.collectCommentCompletion(completionRequest, completionResponse);
                        return completionResponse;
                    }
                    if (text.charAt(scanner.getTokenOffset() + 1) != '!') break;
                    this.collectCDATACompletion(completionRequest, completionResponse);
                    this.collectCommentCompletion(completionRequest, completionResponse);
                    return completionResponse;
                }
                case StartTag: {
                    if (scanner.getTokenOffset() <= offset && offset <= scanner.getTokenEnd()) {
                        this.collectOpenTagSuggestions(scanner.getTokenOffset(), scanner.getTokenEnd(), completionRequest, completionResponse);
                        return completionResponse;
                    }
                    currentTag = scanner.getTokenText();
                    break;
                }
                case AttributeName: {
                    if (scanner.getTokenOffset() > offset || offset > scanner.getTokenEnd()) break;
                    this.collectAttributeNameSuggestions(scanner.getTokenOffset(), scanner.getTokenEnd(), completionRequest, completionResponse);
                    return completionResponse;
                }
                case DelimiterAssign: {
                    if (scanner.getTokenEnd() != offset) break;
                    this.collectAttributeValueSuggestions(offset, offset, completionRequest, completionResponse);
                    return completionResponse;
                }
                case AttributeValue: {
                    if (scanner.getTokenOffset() > offset || offset > scanner.getTokenEnd()) break;
                    this.collectAttributeValueSuggestions(scanner.getTokenOffset(), scanner.getTokenEnd(), completionRequest, completionResponse);
                    return completionResponse;
                }
                case Whitespace: {
                    if (offset > scanner.getTokenEnd()) break;
                    switch (scanner.getScannerState()) {
                        case AfterOpeningStartTag: {
                            int startPos = scanner.getTokenOffset();
                            int endTagPos = XMLCompletions.scanNextForEndPos(offset, scanner, TokenType.StartTag);
                            this.collectTagSuggestions(startPos, endTagPos, completionRequest, completionResponse);
                            return completionResponse;
                        }
                        case WithinTag: 
                        case AfterAttributeName: {
                            this.collectAttributeNameSuggestions(scanner.getTokenEnd(), completionRequest, completionResponse);
                            return completionResponse;
                        }
                        case BeforeAttributeValue: {
                            this.collectAttributeValueSuggestions(scanner.getTokenEnd(), offset, completionRequest, completionResponse);
                            return completionResponse;
                        }
                        case AfterOpeningEndTag: {
                            this.collectCloseTagSuggestions(scanner.getTokenOffset() - 1, false, offset, completionRequest, completionResponse);
                            return completionResponse;
                        }
                        case WithinContent: {
                            this.collectInsideContent(completionRequest, completionResponse);
                            return completionResponse;
                        }
                    }
                    break;
                }
                case EndTagOpen: {
                    if (offset > scanner.getTokenEnd()) break;
                    int afterOpenBracket = scanner.getTokenOffset() + 1;
                    int endOffset = XMLCompletions.scanNextForEndPos(offset, scanner, TokenType.EndTag);
                    this.collectCloseTagSuggestions(afterOpenBracket, false, endOffset, completionRequest, completionResponse);
                    return completionResponse;
                }
                case EndTag: {
                    if (offset > scanner.getTokenEnd()) break;
                    for (int start = scanner.getTokenOffset() - 1; start >= 0; --start) {
                        char ch = text.charAt(start);
                        if (ch == '/') {
                            this.collectCloseTagSuggestions(start, false, scanner.getTokenEnd(), completionRequest, completionResponse);
                            return completionResponse;
                        }
                        if (!Character.isWhitespace(ch)) break block4;
                    }
                    break;
                }
                case StartTagClose: {
                    if (offset > scanner.getTokenEnd() || currentTag == null || currentTag.length() <= 0) break;
                    this.collectInsideContent(completionRequest, completionResponse);
                    return completionResponse;
                }
                case StartTagSelfClose: {
                    if (offset > scanner.getTokenEnd() || currentTag == null || currentTag.length() <= 0 || xmlDocument.getText().charAt(offset - 1) != '>') break;
                    this.collectInsideContent(completionRequest, completionResponse);
                    return completionResponse;
                }
                case EndTagClose: {
                    if (offset > scanner.getTokenEnd() || currentTag == null || currentTag.length() <= 0) break;
                    this.collectInsideContent(completionRequest, completionResponse);
                    return completionResponse;
                }
                case Content: {
                    if (completionRequest.getXMLDocument().isDTD() || completionRequest.getXMLDocument().isWithinInternalDTD(offset)) {
                        if (scanner.getTokenOffset() > offset) break;
                        this.collectInsideDTDContent(completionRequest, completionResponse, true);
                        return completionResponse;
                    }
                    if (offset > scanner.getTokenEnd()) break;
                    this.collectInsideContent(completionRequest, completionResponse);
                    return completionResponse;
                }
                case StartPrologOrPI: {
                    try {
                        boolean isFirstNode;
                        boolean bl = isFirstNode = xmlDocument.positionAt(scanner.getTokenOffset()).getLine() == 0;
                        if (isFirstNode && offset <= scanner.getTokenEnd()) {
                            this.collectPrologSuggestion(scanner.getTokenEnd(), "", completionRequest, completionResponse, settings);
                            return completionResponse;
                        }
                    }
                    catch (BadLocationException e) {
                        LOGGER.log(Level.SEVERE, "In XMLCompletions, StartPrologOrPI position error", e);
                    }
                    break;
                }
                case PIName: {
                    try {
                        boolean isFirstNode;
                        boolean bl = isFirstNode = xmlDocument.positionAt(scanner.getTokenOffset()).getLine() == 0;
                        if (isFirstNode && offset <= scanner.getTokenEnd()) {
                            String substringXML = "xml".substring(0, scanner.getTokenText().length());
                            if (scanner.getTokenText().equals(substringXML)) {
                                PrologModel.computePrologCompletionResponses(scanner.getTokenEnd(), scanner.getTokenText(), completionRequest, completionResponse, true, settings);
                                return completionResponse;
                            }
                        }
                    }
                    catch (BadLocationException e) {
                        LOGGER.log(Level.SEVERE, "In XMLCompletions, StartPrologOrPI position error", e);
                    }
                    break;
                }
                case PrologName: {
                    try {
                        boolean isFirstNode;
                        boolean bl = isFirstNode = xmlDocument.positionAt(scanner.getTokenOffset()).getLine() == 0;
                        if (isFirstNode && offset <= scanner.getTokenEnd()) {
                            this.collectPrologSuggestion(scanner.getTokenEnd(), scanner.getTokenText(), completionRequest, completionResponse, settings);
                            return completionResponse;
                        }
                    }
                    catch (BadLocationException e) {
                        LOGGER.log(Level.SEVERE, "In XMLCompletions, PrologName position error", e);
                    }
                    break;
                }
                case DTDAttlistAttributeName: 
                case DTDAttlistAttributeType: 
                case DTDAttlistAttributeValue: 
                case DTDStartAttlist: 
                case DTDStartElement: 
                case DTDStartEntity: 
                case DTDEndTag: 
                case DTDStartInternalSubset: 
                case DTDEndInternalSubset: {
                    if (scanner.getTokenOffset() > offset) break;
                    this.collectInsideDTDContent(completionRequest, completionResponse);
                    return completionResponse;
                }
                default: {
                    if (offset > scanner.getTokenEnd()) break;
                    return completionResponse;
                }
            }
            token = scanner.scan();
        }
        return completionResponse;
    }

    private static boolean isInsideDTDContent(DOMNode node, DOMDocument xmlDocument) {
        if (xmlDocument.isDTD()) {
            return true;
        }
        return node.getParentNode() != null && node.getParentNode().isDoctype();
    }

    public boolean isBalanced(DOMNode node) {
        if (!node.isClosed()) {
            return false;
        }
        String name = node.getNodeName();
        for (DOMElement parent = node.getParentElement(); parent != null && name.equals(parent.getNodeName()); parent = parent.getParentElement()) {
            if (((DOMNode)parent).isClosed()) continue;
            return false;
        }
        return true;
    }

    public AutoCloseTagResponse doTagComplete(DOMDocument xmlDocument, Position position, CancelChecker cancelChecker) {
        int offset;
        try {
            offset = xmlDocument.offsetAt(position);
            if (offset - 2 < 0) {
                return null;
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "doTagComplete failed", e);
            return null;
        }
        if (offset <= 0) {
            return null;
        }
        char c = xmlDocument.getText().charAt(offset - 1);
        char cBefore = xmlDocument.getText().charAt(offset - 2);
        String snippet = null;
        if (c == '>') {
            DOMNode node = xmlDocument.findNodeBefore(offset);
            if (!(node instanceof DOMElement)) {
                return null;
            }
            DOMElement element = (DOMElement)node;
            if (node != null && node.isElement() && !element.isSelfClosed() && element.getTagName() != null && !this.isEmptyElement(((DOMElement)node).getTagName()) && node.getStart() < offset && (!element.hasEndTag() || element.getTagName().equals(node.getParentNode().getNodeName()) && !this.isBalanced(node))) {
                snippet = "$0</" + ((DOMElement)node).getTagName() + ">";
            }
        } else if (cBefore == '<' && c == '/') {
            DOMNode node;
            for (node = xmlDocument.findNodeBefore(offset); node != null && node.isClosed(); node = node.getParentNode()) {
            }
            if (node != null && node.isElement() && ((DOMElement)node).getTagName() != null) {
                snippet = ((DOMElement)node).getTagName() + ">$0";
            }
        } else {
            DOMNode node = xmlDocument.findNodeBefore(offset);
            if (node.isElement() && node.getNodeName() != null) {
                DOMElement element1 = (DOMElement)node;
                Integer slashOffset = element1.endsWith('/', offset);
                Position end = null;
                if (!element1.isInEndTag(offset) && slashOffset != null) {
                    boolean closeBracketAfterSlash;
                    String text;
                    List<DOMAttr> attrList = element1.getAttributeNodes();
                    if (attrList != null) {
                        DOMAttr lastAttr = attrList.get(attrList.size() - 1);
                        if (slashOffset < lastAttr.getEnd()) {
                            return null;
                        }
                    }
                    boolean bl = offset < (text = xmlDocument.getText()).length() ? text.charAt(offset) == '>' : (closeBracketAfterSlash = false);
                    if (!closeBracketAfterSlash) {
                        if (element1.isStartTagClosed()) {
                            return null;
                        }
                        snippet = ">$0";
                        if (element1.hasEndTag()) {
                            try {
                                end = xmlDocument.positionAt(element1.getEnd());
                            }
                            catch (BadLocationException e) {
                                return null;
                            }
                        }
                    } else {
                        DOMNode nodeAfterParent;
                        DOMElement parentElement;
                        DOMNode nextSibling = node.getNextSibling();
                        if (nextSibling != null && nextSibling.isElement()) {
                            DOMElement element2 = (DOMElement)nextSibling;
                            if (!element2.hasStartTag() && node.getNodeName().equals(element2.getNodeName())) {
                                try {
                                    snippet = ">$0";
                                    end = xmlDocument.positionAt(element2.getEnd());
                                }
                                catch (BadLocationException e) {
                                    return null;
                                }
                            }
                        } else if (nextSibling == null && (parentElement = node.getParentElement()) != null && node.getNodeName().equals(parentElement.getTagName()) && (nodeAfterParent = parentElement.getNextSibling()) != null && nodeAfterParent.isElement()) {
                            DOMElement elementAfterParent = (DOMElement)nodeAfterParent;
                            if (parentElement.getTagName().equals(elementAfterParent.getTagName()) && !elementAfterParent.hasStartTag()) {
                                try {
                                    snippet = ">$0";
                                    end = xmlDocument.positionAt(parentElement.getEnd());
                                }
                                catch (BadLocationException e) {
                                    return null;
                                }
                            }
                        }
                    }
                    if (snippet != null && end != null) {
                        return new AutoCloseTagResponse(snippet, new Range(position, end));
                    }
                }
            }
        }
        if (snippet == null) {
            return null;
        }
        return new AutoCloseTagResponse(snippet);
    }

    private void collectTagSuggestions(int tagStart, int tagEnd, CompletionRequest completionRequest, CompletionResponse completionResponse) {
        this.collectOpenTagSuggestions(tagStart, tagEnd, completionRequest, completionResponse);
        this.collectCloseTagSuggestions(tagStart, true, tagEnd, completionRequest, completionResponse);
    }

    private void collectOpenTagSuggestions(int afterOpenBracket, int tagNameEnd, CompletionRequest completionRequest, CompletionResponse completionResponse) {
        try {
            Range replaceRange = XMLCompletions.getReplaceRange(afterOpenBracket - 1, tagNameEnd, completionRequest);
            this.collectOpenTagSuggestions(true, replaceRange, completionRequest, completionResponse);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "While performing Completions the provided offset was a BadLocation", e);
            return;
        }
    }

    private void collectOpenTagSuggestions(boolean hasOpenBracket, Range replaceRange, CompletionRequest completionRequest, CompletionResponse completionResponse) {
        try {
            DOMDocument document = completionRequest.getXMLDocument();
            String text = document.getText();
            int tagNameEnd = document.offsetAt(replaceRange.getEnd());
            int newOffset = XMLCompletions.getOffsetFollowedBy(text, tagNameEnd, ScannerState.WithinEndTag, TokenType.EndTagClose);
            if (newOffset != -1) {
                replaceRange.setEnd(document.positionAt(++newOffset));
            }
        }
        catch (BadLocationException document) {
            // empty catch block
        }
        completionRequest.setHasOpenBracket(hasOpenBracket);
        completionRequest.setReplaceRange(replaceRange);
        for (ICompletionParticipant participant : this.getCompletionParticipants()) {
            try {
                participant.onTagOpen(completionRequest, completionResponse);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "While performing ICompletionParticipant#onTagOpen", e);
            }
        }
        DOMElement parentNode = completionRequest.getParentElement();
        if (parentNode != null && !parentNode.getOwnerDocument().hasGrammar()) {
            HashSet seenElements = new HashSet();
            if (parentNode != null && parentNode.isElement() && parentNode.hasChildNodes()) {
                parentNode.getChildren().forEach(node -> {
                    DOMElement element;
                    DOMElement dOMElement = element = node.isElement() ? (DOMElement)node : null;
                    if (element == null || element.getTagName() == null || seenElements.contains(element.getTagName())) {
                        return;
                    }
                    String tag = element.getTagName();
                    seenElements.add(tag);
                    CompletionItem item = new CompletionItem();
                    item.setLabel(tag);
                    item.setKind(CompletionItemKind.Property);
                    item.setFilterText(completionRequest.getFilterForStartTagName(tag));
                    StringBuilder xml = new StringBuilder();
                    xml.append("<");
                    xml.append(tag);
                    if (element.isSelfClosed()) {
                        xml.append(" />");
                    } else {
                        xml.append(">");
                        if (completionRequest.isCompletionSnippetsSupported()) {
                            xml.append("$0");
                        }
                        if (completionRequest.isAutoCloseTags()) {
                            xml.append("</").append(tag).append(">");
                        }
                    }
                    item.setTextEdit(new TextEdit(replaceRange, xml.toString()));
                    item.setInsertTextFormat(InsertTextFormat.Snippet);
                    completionResponse.addCompletionItem(item);
                });
            }
        }
    }

    private void collectPrologSuggestion(int startOffset, String tag, CompletionRequest request, CompletionResponse response, SharedSettings settings) {
        PrologModel.computePrologCompletionResponses(startOffset, tag, request, response, false, settings);
    }

    private void collectCloseTagSuggestions(int afterOpenBracket, boolean inOpenTag, int tagNameEnd, CompletionRequest completionRequest, CompletionResponse completionResponse) {
        try {
            Range range = XMLCompletions.getReplaceRange(afterOpenBracket, tagNameEnd, completionRequest);
            String text = completionRequest.getXMLDocument().getText();
            boolean hasCloseTag = XMLCompletions.isFollowedBy(text, tagNameEnd, ScannerState.WithinEndTag, TokenType.EndTagClose);
            this.collectCloseTagSuggestions(range, false, !hasCloseTag, inOpenTag, completionRequest, completionResponse);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "While performing Completions the provided offset was a BadLocation", e);
        }
    }

    private void collectCloseTagSuggestions(Range range, boolean openEndTag, boolean closeEndTag, boolean inOpenTag, CompletionRequest completionRequest, CompletionResponse completionResponse) {
        try {
            String text = completionRequest.getXMLDocument().getText();
            DOMNode curr = completionRequest.getNode();
            if (inOpenTag) {
                curr = curr.getParentNode();
            }
            String closeTag = closeEndTag ? ">" : "";
            int afterOpenBracket = completionRequest.getXMLDocument().offsetAt(range.getStart());
            if (!openEndTag) {
                --afterOpenBracket;
            }
            int offset = completionRequest.getOffset();
            while (curr != null) {
                DOMElement element;
                String tag;
                if (curr.isElement() && (tag = (element = (DOMElement)curr).getTagName()) != null && !element.isClosed()) {
                    CompletionItem item = new CompletionItem();
                    item.setLabel("End with '</" + tag + ">'");
                    item.setKind(CompletionItemKind.Property);
                    item.setInsertTextFormat(InsertTextFormat.PlainText);
                    String startIndent = XMLCompletions.getLineIndent(element.getStart(), text);
                    String endIndent = XMLCompletions.getLineIndent(afterOpenBracket, text);
                    if (startIndent != null && endIndent != null && !startIndent.equals(endIndent)) {
                        String insertText = startIndent + "</" + tag + closeTag;
                        item.setTextEdit(new TextEdit(XMLCompletions.getReplaceRange(afterOpenBracket - endIndent.length(), offset, completionRequest), insertText));
                        item.setFilterText(endIndent + "</" + tag + closeTag);
                    } else {
                        String openTag = openEndTag ? "<" : "";
                        String insertText = openTag + "/" + tag + closeTag;
                        item.setFilterText(insertText);
                        item.setTextEdit(new TextEdit(range, insertText));
                    }
                    completionResponse.addCompletionItem(item);
                }
                curr = curr.getParentNode();
            }
            if (inOpenTag) {
                return;
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "While performing Completions the provided offset was a BadLocation", e);
        }
    }

    private void collectInsideContent(CompletionRequest request, CompletionResponse response) {
        Range tagNameRange = request.getXMLDocument().getElementNameRangeAt(request.getOffset());
        if (tagNameRange != null) {
            this.collectOpenTagSuggestions(false, tagNameRange, request, response);
            this.collectCloseTagSuggestions(tagNameRange, true, true, false, request, response);
        }
        for (ICompletionParticipant participant : this.getCompletionParticipants()) {
            try {
                participant.onXMLContent(request, response);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "While performing ICompletionParticipant#onXMLContent", e);
            }
        }
        this.collectionRegionProposals(request, response);
        this.collectCDATACompletion(request, response);
        this.collectCommentCompletion(request, response);
        this.collectCharacterEntityProposals(request, response);
    }

    private void collectionRegionProposals(ICompletionRequest request, ICompletionResponse response) {
        try {
            int offset = request.getOffset();
            TextDocument document = request.getXMLDocument().getTextDocument();
            Position pos = document.positionAt(offset);
            String lineText = document.lineText(pos.getLine());
            String lineUntilPos = lineText.substring(0, pos.getCharacter());
            Matcher match = regionCompletionRegExpr.matcher(lineUntilPos);
            if (match.find()) {
                InsertTextFormat insertFormat = request.getInsertTextFormat();
                Range range = new Range(new Position(pos.getLine(), pos.getCharacter() + match.regionStart()), pos);
                String text = request.isCompletionSnippetsSupported() ? "<!-- #region $1-->" : "<!-- #region -->";
                CompletionItem beginProposal = new CompletionItem("#region");
                beginProposal.setTextEdit(new TextEdit(range, text));
                beginProposal.setDocumentation("Insert Folding Region Start");
                beginProposal.setFilterText(match.group());
                beginProposal.setSortText("za");
                beginProposal.setKind(CompletionItemKind.Snippet);
                beginProposal.setInsertTextFormat(insertFormat);
                response.addCompletionAttribute(beginProposal);
                CompletionItem endProposal = new CompletionItem("#endregion");
                endProposal.setTextEdit(new TextEdit(range, "<!-- #endregion-->"));
                endProposal.setDocumentation("Insert Folding Region End");
                endProposal.setFilterText(match.group());
                endProposal.setSortText("zb");
                endProposal.setKind(CompletionItemKind.Snippet);
                endProposal.setInsertTextFormat(InsertTextFormat.PlainText);
                response.addCompletionAttribute(endProposal);
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "While performing collectRegionCompletion", e);
        }
    }

    private void collectCDATACompletion(ICompletionRequest request, ICompletionResponse response) {
        try {
            boolean isSnippetsSupported = request.isCompletionSnippetsSupported();
            InsertTextFormat insertFormat = request.getInsertTextFormat();
            DOMDocument document = request.getXMLDocument();
            String filter = "<!CDATA";
            int startOffset = StringUtils.findExprBeforeAt(document.getText(), filter, request.getOffset());
            if (startOffset == -1 && (startOffset = StringUtils.findExprBeforeAt(document.getText(), "CDATA", request.getOffset())) != 1) {
                filter = "CDATA";
            }
            if (startOffset == -1) {
                startOffset = request.getOffset();
            }
            int endOffset = request.getOffset();
            Range editRange = XMLCompletions.getReplaceRange(startOffset + 1, endOffset, request);
            CompletionItem cdataProposal = new CompletionItem("cdata");
            cdataProposal.setKind(CompletionItemKind.Snippet);
            cdataProposal.setFilterText(filter);
            cdataProposal.setSortText("zc");
            cdataProposal.setInsertTextFormat(insertFormat);
            String textEdit = isSnippetsSupported ? "<![CDATA[ $1]]>" : "<![CDATA[ ]]>";
            cdataProposal.setTextEdit(new TextEdit(editRange, textEdit));
            cdataProposal.setDocumentation("Insert <![CDATA[ ]]>");
            response.addCompletionItem(cdataProposal);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "While performing collectCDATACompletion", e);
        }
    }

    private void collectCommentCompletion(ICompletionRequest request, ICompletionResponse response) {
        try {
            boolean isSnippetsSupported = request.isCompletionSnippetsSupported();
            InsertTextFormat insertFormat = request.getInsertTextFormat();
            DOMDocument document = request.getXMLDocument();
            String filter = "<!--";
            int startOffset = StringUtils.findExprBeforeAt(document.getText(), filter, request.getOffset());
            if (startOffset == -1 && (startOffset = StringUtils.findExprBeforeAt(document.getText(), "comment", request.getOffset())) != 1) {
                filter = "comment";
            }
            if (startOffset == -1) {
                startOffset = request.getOffset();
            }
            int endOffset = request.getOffset();
            Range editRange = XMLCompletions.getReplaceRange(startOffset + 1, endOffset, request);
            CompletionItem commentProposal = new CompletionItem("comment");
            commentProposal.setKind(CompletionItemKind.Snippet);
            commentProposal.setFilterText(filter);
            commentProposal.setSortText("zd");
            commentProposal.setInsertTextFormat(insertFormat);
            String textEdit = isSnippetsSupported ? "<!-- $1-->" : "<!-- -->";
            commentProposal.setTextEdit(new TextEdit(editRange, textEdit));
            commentProposal.setDocumentation("Insert <!-- -->");
            response.addCompletionItem(commentProposal);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "While performing collectCommentCompletion", e);
        }
    }

    private void collectCharacterEntityProposals(ICompletionRequest request, ICompletionResponse response) {
    }

    private void collectAttributeNameSuggestions(int nameStart, CompletionRequest completionRequest, CompletionResponse completionResponse) {
        this.collectAttributeNameSuggestions(nameStart, completionRequest.getOffset(), completionRequest, completionResponse);
    }

    private void collectAttributeNameSuggestions(int nameStart, int nameEnd, CompletionRequest completionRequest, CompletionResponse completionResponse) {
        int replaceEnd;
        String text = completionRequest.getXMLDocument().getText();
        for (replaceEnd = completionRequest.getOffset(); replaceEnd < nameEnd && text.charAt(replaceEnd) != '<' && text.charAt(replaceEnd) != '?'; ++replaceEnd) {
        }
        try {
            Range replaceRange = XMLCompletions.getReplaceRange(nameStart, replaceEnd, completionRequest);
            completionRequest.setReplaceRange(replaceRange);
            boolean generateValue = !XMLCompletions.isFollowedBy(text, nameEnd, ScannerState.AfterAttributeName, TokenType.DelimiterAssign);
            for (ICompletionParticipant participant : this.getCompletionParticipants()) {
                participant.onAttributeName(generateValue, completionRequest, completionResponse);
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "While performing Completions, getReplaceRange() was given a bad Offset location", e);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "While performing ICompletionParticipant#onAttributeName", e);
        }
    }

    private void collectAttributeValueSuggestions(int valueStart, int valueEnd, CompletionRequest completionRequest, CompletionResponse completionResponse) {
        String valuePrefix;
        boolean addQuotes = false;
        int offset = completionRequest.getOffset();
        String text = completionRequest.getXMLDocument().getText();
        if (offset > valueStart && offset <= valueEnd && StringUtils.isQuote(text.charAt(valueStart))) {
            int valueContentStart = valueStart + 1;
            int valueContentEnd = valueEnd;
            if (valueEnd > valueStart && text.charAt(valueEnd - 1) == text.charAt(valueStart)) {
                --valueContentEnd;
            }
            valuePrefix = offset >= valueContentStart && offset <= valueContentEnd ? text.substring(valueContentStart, offset) : "";
            valueStart = valueContentStart;
            valueEnd = valueContentEnd;
            addQuotes = false;
        } else {
            valuePrefix = text.substring(valueStart, offset);
            addQuotes = true;
        }
        Collection<ICompletionParticipant> completionParticipants = this.getCompletionParticipants();
        if (completionParticipants.size() > 0) {
            try {
                Range replaceRange = XMLCompletions.getReplaceRange(valueStart, valueEnd, completionRequest);
                completionRequest.setReplaceRange(replaceRange);
                completionRequest.setAddQuotes(addQuotes);
                for (ICompletionParticipant participant : completionParticipants) {
                    participant.onAttributeValue(valuePrefix, completionRequest, completionResponse);
                }
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, "While performing Completions, getReplaceRange() was given a bad Offset location", e);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "While performing ICompletionParticipant#onAttributeValue", e);
            }
        }
    }

    private void collectInsideDTDContent(CompletionRequest request, CompletionResponse response) {
        this.collectInsideDTDContent(request, response, false);
    }

    private void collectInsideDTDContent(CompletionRequest request, CompletionResponse response, boolean isContent) {
        boolean isSnippetsSupported = request.isCompletionSnippetsSupported();
        InsertTextFormat insertFormat = request.getInsertTextFormat();
        CompletionItem elementDecl = new CompletionItem();
        elementDecl.setLabel("Insert DTD Element declaration");
        elementDecl.setKind(CompletionItemKind.EnumMember);
        elementDecl.setFilterText("<!ELEMENT ");
        elementDecl.setInsertTextFormat(insertFormat);
        int startOffset = request.getOffset();
        Range editRange = null;
        DOMDocument document = request.getXMLDocument();
        DOMNode node = document.findNodeAt(startOffset);
        try {
            if (node.isDoctype()) {
                editRange = XMLCompletions.getReplaceRange(startOffset, startOffset, request);
            } else {
                if (isContent) {
                    editRange = document.getTrimmedRange(node.getStart(), node.getEnd());
                }
                if (editRange == null) {
                    editRange = XMLCompletions.getReplaceRange(node.getStart(), node.getEnd(), request);
                }
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "While performing getReplaceRange for DTD completion.", e);
        }
        String textEdit = isSnippetsSupported ? "<!ELEMENT ${1:element-name} (${2:#PCDATA})>" : "<!ELEMENT element-name (#PCDATA)>";
        elementDecl.setTextEdit(new TextEdit(editRange, textEdit));
        elementDecl.setDocumentation("<!ELEMENT element-name (#PCDATA)>");
        response.addCompletionItem(elementDecl);
        CompletionItem attrListDecl = new CompletionItem();
        attrListDecl.setLabel("Insert DTD Attributes list declaration");
        attrListDecl.setKind(CompletionItemKind.EnumMember);
        attrListDecl.setFilterText("<!ATTLIST ");
        attrListDecl.setInsertTextFormat(insertFormat);
        startOffset = request.getOffset();
        textEdit = isSnippetsSupported ? "<!ATTLIST ${1:element-name} ${2:attribute-name} ${3:ID} ${4:#REQUIRED}>" : "<!ATTLIST element-name attribute-name ID #REQUIRED>";
        attrListDecl.setTextEdit(new TextEdit(editRange, textEdit));
        attrListDecl.setDocumentation("<!ATTLIST element-name attribute-name ID #REQUIRED>");
        response.addCompletionItem(attrListDecl);
        CompletionItem internalEntity = new CompletionItem();
        internalEntity.setLabel("Insert Internal DTD Entity declaration");
        internalEntity.setKind(CompletionItemKind.EnumMember);
        internalEntity.setFilterText("<!ENTITY ");
        internalEntity.setInsertTextFormat(insertFormat);
        startOffset = request.getOffset();
        textEdit = isSnippetsSupported ? "<!ENTITY ${1:entity-name} \"${2:entity-value}\">" : "<!ENTITY entity-name \"entity-value\">";
        internalEntity.setTextEdit(new TextEdit(editRange, textEdit));
        internalEntity.setDocumentation("<!ENTITY entity-name \"entity-value\">");
        response.addCompletionItem(internalEntity);
        CompletionItem externalEntity = new CompletionItem();
        externalEntity.setLabel("Insert External DTD Entity declaration");
        externalEntity.setKind(CompletionItemKind.EnumMember);
        externalEntity.setFilterText("<!ENTITY ");
        externalEntity.setInsertTextFormat(insertFormat);
        startOffset = request.getOffset();
        textEdit = isSnippetsSupported ? "<!ENTITY ${1:entity-name} SYSTEM \"${2:entity-value}\">" : "<!ENTITY entity-name SYSTEM \"entity-value\">";
        externalEntity.setTextEdit(new TextEdit(editRange, textEdit));
        externalEntity.setDocumentation("<!ENTITY entity-name SYSTEM \"entity-value\">");
        response.addCompletionItem(externalEntity);
    }

    private static int scanNextForEndPos(int offset, Scanner scanner, TokenType nextToken) {
        TokenType token;
        if (offset == scanner.getTokenEnd() && (token = scanner.scan()) == nextToken && scanner.getTokenOffset() == offset) {
            return scanner.getTokenEnd();
        }
        return offset;
    }

    private Collection<ICompletionParticipant> getCompletionParticipants() {
        return this.extensionsRegistry.getCompletionParticipants();
    }

    private static boolean isFollowedBy(String s, int offset, ScannerState intialState, TokenType expectedToken) {
        return XMLCompletions.getOffsetFollowedBy(s, offset, intialState, expectedToken) != -1;
    }

    public static int getOffsetFollowedBy(String s, int offset, ScannerState intialState, TokenType expectedToken) {
        Scanner scanner = XMLScanner.createScanner(s, offset, intialState);
        TokenType token = scanner.scan();
        while (token == TokenType.Whitespace) {
            token = scanner.scan();
        }
        return token == expectedToken ? scanner.getTokenOffset() : -1;
    }

    public static Range getReplaceRange(int replaceStart, int replaceEnd, ICompletionRequest context) throws BadLocationException {
        int offset = context.getOffset();
        if (replaceStart > offset) {
            replaceStart = offset;
        }
        DOMDocument document = context.getXMLDocument();
        return new Range(document.positionAt(replaceStart), document.positionAt(replaceEnd));
    }

    private static String getLineIndent(int offset, String text) {
        for (int start = offset; start > 0; --start) {
            char ch = text.charAt(start - 1);
            if ("\n\r".indexOf(ch) >= 0) {
                return text.substring(start, offset);
            }
            if (Character.isWhitespace(ch)) continue;
            return null;
        }
        return text.substring(0, offset);
    }

    private boolean isEmptyElement(String tag) {
        return false;
    }
}

