/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;

public class XMLCodeActions {
    private final XMLExtensionsRegistry extensionsRegistry;

    public XMLCodeActions(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public List<CodeAction> doCodeActions(CodeActionContext context, Range range, DOMDocument document, XMLFormattingOptions formattingSettings) {
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        if (context.getDiagnostics() != null) {
            for (Diagnostic diagnostic : context.getDiagnostics()) {
                for (ICodeActionParticipant codeActionParticipant : this.extensionsRegistry.getCodeActionsParticipants()) {
                    codeActionParticipant.doCodeAction(diagnostic, range, document, codeActions, formattingSettings, this.extensionsRegistry);
                }
            }
        }
        return codeActions;
    }
}

