/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMProcessingInstruction;
import org.eclipse.lemminx.dom.DOMRange;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class DOMNode
implements Node,
DOMRange {
    public static final int NULL_VALUE = -1;
    public static final short DTD_ELEMENT_DECL_NODE = 101;
    public static final short DTD_ATT_LIST_NODE = 102;
    public static final short DTD_ENTITY_DECL_NODE = 103;
    public static final short DTD_NOTATION_DECL = 104;
    public static final short DTD_DECL_NODE = 105;
    boolean closed = false;
    private XMLNamedNodeMap<DOMAttr> attributeNodes;
    private XMLNodeList<DOMNode> children;
    final int start;
    int end;
    DOMNode parent;
    private static final NodeList EMPTY_CHILDREN = new NodeList(){

        @Override
        public Node item(int index) {
            return null;
        }

        @Override
        public int getLength() {
            return 0;
        }
    };

    public DOMNode(int start, int end) {
        this.start = start;
        this.end = end;
        this.closed = false;
    }

    @Override
    public DOMDocument getOwnerDocument() {
        for (Node node = this.parent; node != null; node = node.getParentNode()) {
            if (node.getNodeType() != 9) continue;
            return (DOMDocument)node;
        }
        return null;
    }

    public String toString() {
        return this.toString(0);
    }

    private String toString(int indent) {
        int i;
        StringBuilder result = new StringBuilder("");
        for (i = 0; i < indent; ++i) {
            result.append("\t");
        }
        result.append("{start: ");
        result.append(this.start);
        result.append(", end: ");
        result.append(this.end);
        result.append(", name: ");
        result.append(this.getNodeName());
        result.append(", closed: ");
        result.append(this.closed);
        if (this.children != null && this.children.size() > 0) {
            result.append(", \n");
            for (i = 0; i < indent + 1; ++i) {
                result.append("\t");
            }
            result.append("children:[");
            for (i = 0; i < this.children.size(); ++i) {
                DOMNode node = (DOMNode)this.children.get(i);
                result.append("\n");
                result.append(node.toString(indent + 2));
                if (i >= this.children.size() - 1) continue;
                result.append(",");
            }
            result.append("\n");
            for (i = 0; i < indent + 1; ++i) {
                result.append("\t");
            }
            result.append("]");
            result.append("\n");
            for (i = 0; i < indent; ++i) {
                result.append("\t");
            }
            result.append("}");
        } else {
            result.append("}");
        }
        return result.toString();
    }

    public DOMNode findNodeBefore(int offset) {
        List<DOMNode> children = this.getChildren();
        int idx = DOMNode.findFirst(children, c -> offset <= c.start) - 1;
        if (idx >= 0) {
            DOMNode child = children.get(idx);
            if (offset > child.start) {
                if (offset < child.end) {
                    return child.findNodeBefore(offset);
                }
                DOMNode lastChild = child.getLastChild();
                if (lastChild != null && lastChild.end == child.end) {
                    return child.findNodeBefore(offset);
                }
                return child;
            }
        }
        return this;
    }

    public DOMNode findNodeAt(int offset) {
        DOMNode child;
        List<DOMNode> children = this.getChildren();
        int idx = DOMNode.findFirst(children, c -> offset <= c.start) - 1;
        if (idx >= 0 && DOMNode.isIncluded(child = children.get(idx), offset)) {
            return child.findNodeAt(offset);
        }
        return this;
    }

    public static boolean isIncluded(DOMRange node, int offset) {
        if (node == null) {
            return false;
        }
        return DOMNode.isIncluded(node.getStart(), node.getEnd(), offset);
    }

    public static boolean isIncluded(int start, int end, int offset) {
        return offset >= start && offset <= end;
    }

    public DOMAttr findAttrAt(int offset) {
        DOMNode node = this.findNodeAt(offset);
        return DOMNode.findAttrAt(node, offset);
    }

    public static DOMAttr findAttrAt(DOMNode node, int offset) {
        if (node != null && node.hasAttributes()) {
            for (DOMAttr attr : node.getAttributeNodes()) {
                if (!attr.isIncluded(offset)) continue;
                return attr;
            }
        }
        return null;
    }

    public static DOMNode findNodeOrAttrAt(DOMDocument document, int offset) {
        DOMAttr attr;
        DOMNode node = document.findNodeAt(offset);
        if (node != null && (attr = DOMNode.findAttrAt(node, offset)) != null) {
            return attr;
        }
        return node;
    }

    private static <T> int findFirst(List<T> array, Function<T, Boolean> p) {
        int low = 0;
        int high = array.size();
        if (high == 0) {
            return 0;
        }
        while (low < high) {
            int mid = (int)Math.floor((low + high) / 2);
            if (p.apply(array.get(mid)).booleanValue()) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return low;
    }

    public DOMAttr getAttributeNode(String name) {
        return this.getAttributeNode(null, name);
    }

    public DOMAttr getAttributeNode(String prefix, String suffix) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
            sb.append(":");
        }
        sb.append(suffix);
        String name = sb.toString();
        if (!this.hasAttributes()) {
            return null;
        }
        for (DOMAttr attr : this.attributeNodes) {
            if (!name.equals(attr.getName())) continue;
            return attr;
        }
        return null;
    }

    public String getAttribute(String name) {
        String value;
        DOMAttr attr = this.getAttributeNode(name);
        String string = value = attr != null ? attr.getValue() : null;
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return value;
        }
        char c = value.charAt(0);
        if (c == '\"' || c == '\'') {
            if (value.charAt(value.length() - 1) == c) {
                return value.substring(1, value.length() - 1);
            }
            return value.substring(1, value.length());
        }
        return value;
    }

    public DOMAttr getAttributeAtIndex(int index) {
        if (!this.hasAttributes()) {
            return null;
        }
        if (index > this.attributeNodes.getLength() - 1) {
            return null;
        }
        return (DOMAttr)this.attributeNodes.get(index);
    }

    public boolean hasAttribute(String name) {
        return this.hasAttributes() && this.getAttributeNode(name) != null;
    }

    @Override
    public boolean hasAttributes() {
        return this.attributeNodes != null && this.attributeNodes.size() != 0;
    }

    public void setAttribute(String name, String value) {
        DOMAttr attr = this.getAttributeNode(name);
        if (attr == null) {
            attr = new DOMAttr(name, this);
            this.setAttributeNode(attr);
        }
        attr.setValue(value, -1, -1);
    }

    public void setAttributeNode(DOMAttr attr) {
        if (this.attributeNodes == null) {
            this.attributeNodes = new XMLNamedNodeMap();
        }
        this.attributeNodes.add(attr);
    }

    public List<DOMAttr> getAttributeNodes() {
        return this.attributeNodes;
    }

    public List<DOMNode> getChildrenWithAttributeValue(String name, String value) {
        ArrayList<DOMNode> result = new ArrayList<DOMNode>();
        for (DOMNode child : this.getChildren()) {
            String attrValue;
            if (!child.hasAttribute(name) || !Objects.equals(attrValue = child.getAttribute(name), value)) continue;
            result.add(child);
        }
        return result;
    }

    public List<DOMNode> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    public void addChild(DOMNode child) {
        child.parent = this;
        if (this.children == null) {
            this.children = new XMLNodeList();
        }
        this.getChildren().add(child);
    }

    public DOMNode getChild(int index) {
        return this.getChildren().get(index);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public DOMElement getParentElement() {
        DOMDocument ownerDocument = this.getOwnerDocument();
        for (DOMNode parent = this.getParentNode(); parent != null && parent != ownerDocument; parent = parent.getParentNode()) {
            if (!parent.isElement()) continue;
            return (DOMElement)parent;
        }
        return null;
    }

    public boolean isComment() {
        return this.getNodeType() == 8;
    }

    public boolean isProcessingInstruction() {
        return this.getNodeType() == 7 && ((DOMProcessingInstruction)this).isProcessingInstruction();
    }

    public boolean isProlog() {
        return this.getNodeType() == 7 && ((DOMProcessingInstruction)this).isProlog();
    }

    public boolean isCDATA() {
        return this.getNodeType() == 4;
    }

    public boolean isDoctype() {
        return this.getNodeType() == 10;
    }

    public boolean isGenericDTDDecl() {
        return this.getNodeType() == 105;
    }

    public boolean isElement() {
        return this.getNodeType() == 1;
    }

    public boolean isAttribute() {
        return this.getNodeType() == 2;
    }

    public boolean isText() {
        return this.getNodeType() == 3;
    }

    public boolean isCharacterData() {
        return this.isCDATA() || this.isText() || this.isProcessingInstruction() || this.isComment();
    }

    public boolean isDTDElementDecl() {
        return this.getNodeType() == 101;
    }

    public boolean isDTDAttListDecl() {
        return this.getNodeType() == 102;
    }

    public boolean isDTDEntityDecl() {
        return this.getNodeType() == 6;
    }

    public boolean isDTDNotationDecl() {
        return this.getNodeType() == 104;
    }

    public boolean isOwnerDocument() {
        return this.getNodeType() == 9;
    }

    public boolean isChildOfOwnerDocument() {
        if (this.parent == null) {
            return false;
        }
        return this.parent.getNodeType() == 9;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public DOMNode getParentNode() {
        return this.parent;
    }

    @Override
    public DOMNode getFirstChild() {
        return this.children != null && this.children.size() > 0 ? (DOMNode)this.children.get(0) : null;
    }

    @Override
    public DOMNode getLastChild() {
        return this.children != null && this.children.size() > 0 ? (DOMNode)this.children.get(this.children.size() - 1) : null;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.attributeNodes;
    }

    @Override
    public NodeList getChildNodes() {
        return this.children != null ? this.children : EMPTY_CHILDREN;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node cloneNode(boolean deep) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getBaseURI() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getFeature(String arg0, String arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public DOMNode getNextSibling() {
        DOMNode parentNode = this.getParentNode();
        if (parentNode == null) {
            return null;
        }
        List<DOMNode> children = parentNode.getChildren();
        int nextIndex = children.indexOf(this) + 1;
        return nextIndex < children.size() ? children.get(nextIndex) : null;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public DOMNode getPreviousSibling() {
        DOMNode parentNode = this.getParentNode();
        if (parentNode == null) {
            return null;
        }
        List<DOMNode> children = parentNode.getChildren();
        int previousIndex = children.indexOf(this) - 1;
        return previousIndex >= 0 ? children.get(previousIndex) : null;
    }

    public DOMNode getPreviousNonTextSibling() {
        DOMNode prev;
        for (prev = this.getPreviousSibling(); prev != null && prev.isText(); prev = prev.getPreviousSibling()) {
        }
        return prev;
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.getNodeValue();
    }

    @Override
    public Object getUserData(String arg0) {
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        return this.children != null && !this.children.isEmpty();
    }

    @Override
    public Node insertBefore(Node arg0, Node arg1) throws DOMException {
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String arg0) {
        return false;
    }

    @Override
    public boolean isEqualNode(Node arg0) {
        return false;
    }

    @Override
    public boolean isSameNode(Node arg0) {
        return false;
    }

    @Override
    public boolean isSupported(String arg0, String arg1) {
        return false;
    }

    @Override
    public String lookupNamespaceURI(String arg0) {
        return null;
    }

    @Override
    public String lookupPrefix(String arg0) {
        return null;
    }

    @Override
    public void normalize() {
    }

    @Override
    public Node removeChild(Node arg0) throws DOMException {
        return null;
    }

    @Override
    public Node replaceChild(Node arg0, Node arg1) throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String arg0) throws DOMException {
    }

    @Override
    public void setPrefix(String arg0) throws DOMException {
    }

    @Override
    public void setTextContent(String arg0) throws DOMException {
    }

    @Override
    public Object setUserData(String arg0, Object arg1, UserDataHandler arg2) {
        return null;
    }

    static class XMLNamedNodeMap<T extends DOMNode>
    extends ArrayList<T>
    implements NamedNodeMap {
        private static final long serialVersionUID = 1L;

        XMLNamedNodeMap() {
        }

        @Override
        public int getLength() {
            return super.size();
        }

        public T getNamedItem(String name) {
            for (DOMNode node : this) {
                if (!name.equals(node.getNodeName())) continue;
                return (T)node;
            }
            return null;
        }

        public T getNamedItemNS(String name, String arg1) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public T item(int index) {
            return (T)((DOMNode)super.get(index));
        }

        public T removeNamedItem(String arg0) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public T removeNamedItemNS(String arg0, String arg1) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public T setNamedItem(Node arg0) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public T setNamedItemNS(Node arg0) throws DOMException {
            throw new UnsupportedOperationException();
        }
    }

    static class XMLNodeList<T extends DOMNode>
    extends ArrayList<T>
    implements NodeList {
        private static final long serialVersionUID = 1L;

        XMLNodeList() {
        }

        @Override
        public int getLength() {
            return super.size();
        }

        @Override
        public DOMNode item(int index) {
            return (DOMNode)super.get(index);
        }
    }
}

