/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.cloud;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultProducer;
import org.eclipse.kura.camel.cloud.KuraCloudEndpoint;
import org.eclipse.kura.cloud.CloudClient;
import org.eclipse.kura.message.KuraPayload;

public class KuraCloudProducer
extends DefaultProducer {
    CloudClient cloudClient;

    public KuraCloudProducer(KuraCloudEndpoint endpoint, CloudClient cloudClient) {
        super((Endpoint)endpoint);
        this.cloudClient = cloudClient;
    }

    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String topic = KuraCloudProducer.firstNotNull((String)in.getHeader("CamelKuraCloudService.topic", String.class), this.getEndpoint().getTopic());
        int qos = KuraCloudProducer.firstNotNull((Integer)in.getHeader("CamelKuraCloudService.qos", Integer.class), this.getEndpoint().getQos());
        int priority = KuraCloudProducer.firstNotNull((Integer)in.getHeader("CamelKuraCloudService.priority", Integer.class), this.getEndpoint().getPriority());
        boolean retain = KuraCloudProducer.firstNotNull((Boolean)in.getHeader("CamelKuraCloudService.retain", Boolean.class), this.getEndpoint().isRetain());
        boolean control = KuraCloudProducer.firstNotNull((Boolean)in.getHeader("CamelKuraCloudService.control", Boolean.class), this.getEndpoint().isControl());
        String deviceId = KuraCloudProducer.firstNotNull((String)in.getHeader("CamelKuraCloudService.deviceId", String.class), this.getEndpoint().getDeviceId());
        Object body = in.getBody();
        if (body == null) {
            throw new RuntimeException("Cannot produce null payload.");
        }
        if (!(body instanceof KuraPayload)) {
            KuraPayload payload = new KuraPayload();
            if (body instanceof byte[]) {
                payload.setBody((byte[])body);
            } else {
                byte[] payloadBytes = (byte[])in.getBody(byte[].class);
                if (payloadBytes != null) {
                    payload.setBody((byte[])in.getBody(byte[].class));
                } else {
                    payload.setBody(((String)in.getBody(String.class)).getBytes());
                }
            }
            body = payload;
        }
        if (control) {
            if (deviceId != null) {
                this.cloudClient.controlPublish(deviceId, topic, (KuraPayload)body, qos, retain, priority);
            } else {
                this.cloudClient.controlPublish(topic, (KuraPayload)body, qos, retain, priority);
            }
        } else {
            this.cloudClient.publish(topic, (KuraPayload)body, qos, retain, priority);
        }
    }

    public KuraCloudEndpoint getEndpoint() {
        return (KuraCloudEndpoint)super.getEndpoint();
    }

    private static <T> T firstNotNull(T first, T second) {
        return first != null ? first : second;
    }
}

