/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.provider;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.eclipse.kura.audit.AuditConstants;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.rest.auth.AuthenticationProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=200)
public class PasswordAuthenticationProvider
implements AuthenticationProvider {
    private static final String PASSWORD_AUTH_FAILED_MSG = "{} Rest - Failure - Authentication failed as username or password not matching";
    private static final Logger logger = LoggerFactory.getLogger(PasswordAuthenticationProvider.class);
    private static final String KURA_USER_PREFIX = "kura.user.";
    private static final String KURA_NEED_PASSWORD_CHANGE = "kura.need.password.change";
    private static final String KURA_PASSWORD_CREDENTIAL = "kura.password";
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"AuditLogger");
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private final UserAdmin userAdmin;
    private final CryptoService cryptoService;
    private final BundleContext bundleContext;
    private Optional<ServiceRegistration<ContainerResponseFilter>> registration = Optional.empty();

    public PasswordAuthenticationProvider(BundleContext bundleContext, UserAdmin userAdmin, CryptoService cryptoService) {
        this.userAdmin = userAdmin;
        this.cryptoService = cryptoService;
        this.bundleContext = bundleContext;
    }

    @Override
    public Optional<Principal> authenticate(HttpServletRequest request, ContainerRequestContext requestContext) {
        RequestCredentials credentials;
        AuditContext auditContext = AuditContext.currentOrInternal();
        String authHeader = requestContext.getHeaderString("Authorization");
        if (Objects.isNull(authHeader)) {
            return Optional.empty();
        }
        StringTokenizer tokens = new StringTokenizer(authHeader);
        String authScheme = tokens.nextToken();
        if (!"Basic".equals(authScheme)) {
            return Optional.empty();
        }
        try {
            credentials = RequestCredentials.fromBasicAuthorizationHeader(tokens.nextToken());
        }
        catch (Exception e) {
            logger.debug("failed to parse basic credentials", (Throwable)e);
            auditLogger.warn(PASSWORD_AUTH_FAILED_MSG, (Object)auditContext);
            return Optional.empty();
        }
        auditContext.getProperties().put(AuditConstants.KEY_IDENTITY.getValue(), credentials.username);
        Role userRole = this.userAdmin.getRole(KURA_USER_PREFIX + credentials.username);
        if (!(userRole instanceof User)) {
            auditLogger.warn(PASSWORD_AUTH_FAILED_MSG, (Object)auditContext);
            return Optional.empty();
        }
        User user = (User)userRole;
        if ("true".equals(user.getProperties().get(KURA_NEED_PASSWORD_CHANGE))) {
            return Optional.empty();
        }
        String storedPasswordHash = (String)user.getCredentials().get(KURA_PASSWORD_CREDENTIAL);
        if (Objects.isNull(storedPasswordHash)) {
            auditLogger.warn(PASSWORD_AUTH_FAILED_MSG, (Object)auditContext);
            return Optional.empty();
        }
        try {
            if (this.cryptoService.sha256Hash(credentials.password).equals(storedPasswordHash)) {
                auditLogger.info("{} Rest - Success - Authentication succeeded via password provider", (Object)auditContext);
                return Optional.of(() -> requestCredentials.username);
            }
            auditLogger.warn(PASSWORD_AUTH_FAILED_MSG, (Object)auditContext);
            return Optional.empty();
        }
        catch (Exception e) {
            auditLogger.warn(PASSWORD_AUTH_FAILED_MSG, (Object)auditContext);
            logger.warn("Failed to compute password hash", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public void onEnabled() {
        if (this.registration.isPresent()) {
            return;
        }
        this.registration = Optional.of(this.bundleContext.registerService(ContainerResponseFilter.class, (Object)new AuthenticateResponseFilter(), null));
    }

    @Override
    public void onDisabled() {
        this.registration.ifPresent(ServiceRegistration::unregister);
        this.registration = Optional.empty();
    }

    @Provider
    private static class AuthenticateResponseFilter
    implements ContainerResponseFilter {
        private AuthenticateResponseFilter() {
        }

        public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
            int status = response.getStatus();
            if (status == 401 || status == 403) {
                response.getHeaders().add((Object)"WWW-Authenticate", (Object)"Basic realm=\"kura-rest-api\"");
            }
        }
    }

    private static class RequestCredentials {
        final String username;
        final String password;

        RequestCredentials(String username, String password) {
            this.username = username;
            this.password = password;
        }

        static RequestCredentials fromBasicAuthorizationHeader(String authHeaderToken) {
            String credentials = new String(BASE64_DECODER.decode(authHeaderToken), StandardCharsets.UTF_8);
            int colonIndex = credentials.indexOf(58);
            String username = credentials.substring(0, colonIndex);
            String password = credentials.substring(colonIndex + 1);
            return new RequestCredentials(username, password);
        }
    }
}

