/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.negativeinteger.totaldigits.totaldigits_3;

import jakarta.xml.bind.*;
import java.math.BigInteger;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class totalDigits3_GetSetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        totalDigits3_GetSetCTTests test = new totalDigits3_GetSetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status GetSet001( ) {
        String[] xmlDocNames = {
            "totalDigits-3-1.xml", "totalDigits-3-2.xml", "totalDigits-3-3.xml",
            "totalDigits-3-4.xml", "totalDigits-3-5.xml"
        };
        BigInteger[] expectedValues = {new BigInteger("-4"), new BigInteger("-492"), new BigInteger("-67735"), 
                                       new BigInteger("-1115869"), new BigInteger("-325024874")};
        BigInteger[] anExpectedValues = {new BigInteger("-1"), new BigInteger("-65536"), new BigInteger("-100000000"), 
                                         new BigInteger("-999999999"), new BigInteger("-325024874")};
        
        for (int i = 0; i < xmlDocNames.length; ++i){
            JAXBElement<BigInteger> elemObj = (JAXBElement<BigInteger>)unmarshal(xmlDocNames[i]);
            if (!elemObj.getValue().equals(expectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.getValue() != " + expectedValues[i]);
            }
            elemObj.setValue(anExpectedValues[i]);
            if (!elemObj.getValue().equals(anExpectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.setValue(" + anExpectedValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anExpectedValues[i]);
            }
        }
        return Status.passed("OKAY");
    }

    public Status GetSet002( ) {
        BigInteger[] setValues = {new BigInteger("-4"), new BigInteger("-492"), new BigInteger("-67735"), 
                                  new BigInteger("-999999999"), new BigInteger("-325024874")};
        BigInteger[] anSetValues = {new BigInteger("-1"), new BigInteger("-65536"), new BigInteger("-100000000"), 
                                    new BigInteger("-999999999"), new BigInteger("-325024875")};

        JAXBElement<BigInteger> elemObj = null;
        for (int i = 0; i < setValues.length; ++i){
            
                elemObj = (JAXBElement<BigInteger>)(new ObjectFactory()).createNISTSchemaNegativeIntegerTotalDigits3(setValues[i]);
            
            if (!elemObj.getValue().equals(setValues[i])){
                return Status.failed("dynamically created JAXBElement<BigInteger>, elemObj.getValue() != " + setValues[i]);
            }
            elemObj.setValue(anSetValues[i]);
            if (!elemObj.getValue().equals(anSetValues[i])){
                return Status.failed("dynamically created JAXBElement<BigInteger>, elemObj.setValue(" + anSetValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anSetValues[i]);
            }
        }
        return Status.passed("OKAY");
    }


}

