/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.packaging.war.datasource.stateful;

import com.sun.ts.tests.ejb30.lite.packaging.war.datasource.common.ComponentBase;
import com.sun.ts.tests.ejb30.lite.packaging.war.datasource.common.DataSourceTest;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.annotation.sql.DataSourceDefinition;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.InvocationContext;
import javax.sql.DataSource;

@DataSourceDefinition(name="java:module/env/moduleds", description="override with <data-source> in ejb-jar.xml", className="jdbc.ClientDataSource", portNumber=8080, serverName="x", databaseName="x", user="x", password="x", initialPoolSize=1, isolationLevel=8, loginTimeout=300, maxIdleTime=1000, maxPoolSize=2, minPoolSize=1, transactional=true, url="jdbc:derby://${derby.server}:${derby.port}/${derby.dbName};create=true")
public class Interceptor1
extends ComponentBase {
    @Resource(lookup="java:app/env/appds")
    private DataSource appds;
    @Resource(lookup="java:app/env/appds2")
    private DataSource appds2;
    @Resource(lookup="java:module/env/moduleds")
    private DataSource moduleds;

    @PostConstruct
    private void postConstruct(InvocationContext inv) {
        boolean c = true;
        this.getPostConstructRecords().append(String.format("In postConstruct of %s%n", this));
        DataSourceTest.verifyDataSource(this.getPostConstructRecords(), c, "java:app/env/appds", "java:app/env/appds2", "java:module/env/moduleds");
        DataSourceTest.verifyDataSource(this.getPostConstructRecords(), c, this.appds, this.appds2, this.moduleds);
        DataSourceTest.verifyDataSource(this.getPostConstructRecords(), c, this.moduleds);
        try {
            inv.proceed();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @AroundInvoke
    private Object intercept(InvocationContext inv) throws Exception {
        String methodName = inv.getMethod().getName();
        if (methodName.equals("getPostConstructRecordsFromInterceptor")) {
            return this.getPostConstructRecords();
        }
        return inv.proceed();
    }
}

