/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.report.ConfigSection;
import com.sun.javatest.report.HTMLSection;
import com.sun.javatest.report.KflSection;
import com.sun.javatest.report.KflSorter;
import com.sun.javatest.report.ReportFormat;
import com.sun.javatest.report.ReportSettings;
import com.sun.javatest.report.ReportWriter;
import com.sun.javatest.report.ResultSection;
import com.sun.javatest.report.StatisticsSection;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

public class HTMLReport
implements ReportFormat {
    private static final String ID = "html";
    protected Charset reportCharset;
    protected String DEFAULT_CHARSET = "UTF-8";
    File reportDir;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(HTMLReport.class);
    private TreeSet[] results;
    private KflSorter kflSorter;
    static final String REPORT_NAME = "report.html";
    static final String NEW_REPORT_NAME = "index.html";
    static final String[] anchors = new String[]{"selection", "execution", "kfl", "locations", "keywordSummary"};
    static final int SELECT_ANCHOR = 0;
    static final int EXEC_ANCHOR = 1;
    static final int KFL_ANCHOR = 2;
    static final int LOC_ANCHOR = 3;
    static final int KEYWORD_ANCHOR = 4;
    static final String SECOND_FAILED_REPORT = "failed_gr.html";
    static final String SECOND_PASSED_REPORT = "passed_gr.html";
    static final String SECOND_ERROR_REPORT = "error_gr.html";
    static final String[] files = new String[]{"report.html", "index.html", "config.html", "env.html", "excluded.html", "passed.html", "failed.html", "error.html", "notRun.html", "kfl_fail2pass.html", "kfl_fail2error.html", "kfl_fail2missing.html", "kfl_newfailures.html", "passed_gr.html", "failed_gr.html", "error_gr.html"};
    static final int REPORT_HTML = 0;
    static final int INDEX_HTML = 1;
    static final int CONFIG_HTML = 2;
    static final int ENV_HTML = 3;
    static final int EXCLUDED_HTML = 4;
    static final int PASSED_HTML = 5;
    static final int FAILED_HTML = 6;
    static final int ERROR_HTML = 7;
    static final int NOTRUN_HTML = 8;
    static final int KFL_F2P = 9;
    static final int KFL_F2E = 10;
    static final int KFL_F2M = 11;
    static final int KFL_NEW = 12;
    static final int PASSED_HTML_2 = 13;
    static final int FAILED_HTML_2 = 14;
    static final int ERROR_HTML_2 = 15;

    @Override
    public ReportFormat.ReportLink write(ReportSettings s, File dir) throws IOException {
        this.reportDir = dir;
        this.initCharset();
        this.setKflData(s.getKflSorter());
        this.setResults(s.getSortedResults());
        ArrayList<HTMLSection> mainSecs = new ArrayList<HTMLSection>(3);
        ArrayList<HTMLSection> auxSecs = new ArrayList<HTMLSection>(3);
        ConfigSection cs = new ConfigSection(this, s, dir, i18n);
        if (s.isConfigSectionEnabled()) {
            mainSecs.add(cs);
            auxSecs.add(cs);
        }
        ResultSection rs = null;
        if (s.isResultsEnabled() || s.isKflEnabled()) {
            rs = new ResultSection(this, s, dir, i18n, this.getResults());
        }
        if (s.isResultsEnabled()) {
            mainSecs.add(rs);
        }
        if (s.isStateFileEnabled(0) || s.isStateFileEnabled(2) || s.isStateFileEnabled(3) || s.isStateFileEnabled(1)) {
            if (rs == null) {
                rs = new ResultSection(this, s, dir, i18n, this.getResults());
            }
            auxSecs.add(rs);
        }
        if (s.isKflEnabled()) {
            KflSection kfl = new KflSection(this, s, dir, i18n, this.kflSorter);
            mainSecs.add(kfl);
            auxSecs.add(kfl);
        }
        if (s.isKeywordSummaryEnabled()) {
            mainSecs.add(new StatisticsSection(this, s, dir, i18n));
            auxSecs.add(new StatisticsSection(this, s, dir, i18n));
        }
        HTMLSection[] mainSections = new HTMLSection[mainSecs.size()];
        mainSecs.toArray(mainSections);
        HTMLSection[] auxSections = new HTMLSection[auxSecs.size()];
        auxSecs.toArray(auxSections);
        Writer writer = null;
        if (s.reportHtml && s.indexHtml) {
            writer = new DuplexWriter(this.openWriter(this.reportDir, 0), this.openWriter(this.reportDir, 1));
        } else if (s.reportHtml) {
            writer = this.openWriter(this.reportDir, 0);
        } else if (s.indexHtml) {
            writer = this.openWriter(this.reportDir, 1);
        }
        ReportWriter.initializeDirectory(this.reportDir);
        if (writer != null) {
            int i;
            ReportWriter out = new ReportWriter(writer, i18n.getString("report.title"), i18n, this.reportCharset);
            String testSuiteName = s.getInterview().getTestSuite().getName();
            if (testSuiteName != null) {
                out.startTag("h2");
                out.writeI18N("report.testSuite", testSuiteName);
                out.endTag("h2");
            }
            if (s.getTestFilter() != null && s.getTestFilter().getName() != null) {
                out.startTag("h3");
                out.writeI18N("report.filter", s.getTestFilter().getName());
                out.endTag("h3");
            }
            out.startTag("ul");
            for (i = 0; i < mainSections.length; ++i) {
                out.startTag("li");
                mainSections[i].writeContents(out);
                out.endTag("li");
            }
            out.endTag("ul");
            for (i = 0; i < mainSections.length; ++i) {
                out.startTag("p");
                out.startTag("hr");
                mainSections[i].writeSummary(out);
                out.newLine();
            }
            out.close();
        }
        for (int i = 0; i < auxSections.length; ++i) {
            auxSections[i].writeExtraFiles();
        }
        File f = s.indexHtml ? new File(ID + File.separator + NEW_REPORT_NAME) : (s.reportHtml ? new File(ID + File.separator + REPORT_NAME) : new File(ID + File.separator));
        return new ReportFormat.ReportLink(i18n.getString("index.htmltype.txt"), this.getBaseDirName(), i18n.getString("index.desc.html"), f);
    }

    @Override
    public String getReportID() {
        return ID;
    }

    @Override
    public String getBaseDirName() {
        return ID;
    }

    @Override
    public String getTypeName() {
        return ID;
    }

    @Override
    public boolean acceptSettings(ReportSettings s) {
        return s.isHtmlEnabled();
    }

    @Override
    public List<ReportFormat> getSubReports() {
        return Collections.emptyList();
    }

    public static String[] getReportFilenames() {
        return new String[]{REPORT_NAME, NEW_REPORT_NAME};
    }

    public static String getFile(int code) {
        return files[code];
    }

    File getReportDirectory() {
        return this.reportDir;
    }

    Writer openWriter(File reportDir, int code) throws IOException {
        File fout = new File(reportDir, files[code]);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(fout), this.reportCharset);
        return new BufferedWriter(osw);
    }

    public void setResults(TreeSet[] results) {
        this.results = results;
    }

    TreeSet[] getResults() {
        return this.results;
    }

    public void setKflData(KflSorter s) {
        this.kflSorter = s;
    }

    private void initCharset() {
        String userCS = System.getProperty("javatest.report.html.charset");
        if (userCS != null && Charset.isSupported(userCS)) {
            try {
                this.reportCharset = Charset.forName(userCS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.reportCharset == null && Charset.isSupported(this.DEFAULT_CHARSET)) {
            try {
                this.reportCharset = Charset.forName(this.DEFAULT_CHARSET);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.reportCharset == null) {
            this.reportCharset = Charset.defaultCharset();
        }
    }

    static class DuplexWriter
    extends Writer {
        private Writer[] targets;

        public DuplexWriter(Writer[] writers) {
            if (writers == null) {
                return;
            }
            this.targets = new Writer[writers.length];
            System.arraycopy(writers, 0, this.targets, 0, writers.length);
        }

        public DuplexWriter(Writer w1, Writer w2) {
            this.targets = new Writer[2];
            this.targets[0] = w1;
            this.targets[1] = w2;
        }

        @Override
        public void close() throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].close();
            }
        }

        @Override
        public void flush() throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].flush();
            }
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].write(cbuf);
            }
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].write(cbuf, off, len);
            }
        }

        @Override
        public void write(int c) throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].write(c);
            }
        }

        @Override
        public void write(String str) throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].write(str);
            }
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i].write(str, off, len);
            }
        }
    }
}

