/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.inheritance.nonentity;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.inheritance.nonentity.Employee;
import ee.jakarta.tck.persistence.core.inheritance.nonentity.FTEmployee;
import ee.jakarta.tck.persistence.core.inheritance.nonentity.FullTimeEmployee;
import ee.jakarta.tck.persistence.core.inheritance.nonentity.PartTimeEmployee;
import java.sql.Date;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final FullTimeEmployee[] ftRef = new FullTimeEmployee[5];
    private static final PartTimeEmployee[] ptRef = new PartTimeEmployee[5];
    private final Date d1 = this.getSQLDate(2000, 2, 14);
    private final Date d2 = this.getSQLDate(2001, 6, 27);
    private final Date d3 = this.getSQLDate(2002, 7, 7);
    private final Date d4 = this.getSQLDate(2003, 3, 3);
    private final Date d5 = this.getSQLDate(2004, 4, 10);
    private final Date d6 = this.getSQLDate(2005, 2, 18);
    private final Date d7 = this.getSQLDate(2000, 9, 17);
    private final Date d8 = this.getSQLDate(2001, 11, 14);
    private final Date d9 = this.getSQLDate(2002, 10, 4);
    private final Date d10 = this.getSQLDate(2003, 1, 25);

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
            this.logTrace("Done creating test data");
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void nonEntityTest1() throws Exception {
        this.logTrace("Begin nonEntityTest1");
        boolean pass = false;
        String reason = null;
        try {
            FullTimeEmployee ftEmp1 = (FullTimeEmployee)this.getEntityManager().find(FullTimeEmployee.class, (Object)1);
            if (ftEmp1.getFullTimeRep().equals("Mabel Murray")) {
                if (ftEmp1.getHireDate() == null) {
                    pass = true;
                } else {
                    reason = "hireDate is declared in non-entity superclass and it should not be persisted. Expected null but got " + ftEmp1.getHireDate();
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("nonEntityTest1 failed, reason: " + reason);
        }
    }

    public void nonEntityTest2() throws Exception {
        this.logTrace("Begin nonEntityTest2");
        boolean pass = false;
        String reason = null;
        try {
            PartTimeEmployee ptEmp1 = (PartTimeEmployee)this.getEntityManager().find(PartTimeEmployee.class, (Object)6);
            if (ptEmp1.getPartTimeRep().equals("John Cleveland")) {
                if (ptEmp1.getHireDate() == null) {
                    pass = true;
                } else {
                    reason = "hireDate is declared in non-entity superclass and it should not be persisted. Expected null but got " + ptEmp1.getHireDate();
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("nonEntityTest2 failed, reason: " + reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nonEntityTest3() throws Exception {
        this.logTrace("Begin nonEntityTest3");
        boolean pass = false;
        String reason = null;
        FTEmployee ftEmp = new FTEmployee(99, "Joe", "Jones", this.d6, 20000.0f);
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)ftEmp);
            this.getEntityTransaction().commit();
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("IllegalArgumentException caught as expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            reason = "Did not get the Expected Exception";
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("nonEntityTest3 failed, reason: " + reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestData() {
        this.logTrace("createTestData");
        try {
            this.getEntityTransaction().begin();
            Client.ftRef[0] = new FullTimeEmployee(1, "Jonathan", "Smith", this.d10, 40000.0f);
            Client.ftRef[1] = new FullTimeEmployee(2, "Mary", "Macy", this.d9, 40000.0f);
            Client.ftRef[2] = new FullTimeEmployee(3, "Sid", "Nee", this.d8, 40000.0f);
            Client.ftRef[3] = new FullTimeEmployee(4, "Julie", "OClaire", this.d7, 60000.0f);
            Client.ftRef[4] = new FullTimeEmployee(5, "Steven", "Rich", this.d6, 60000.0f);
            this.logTrace("Persist full time employees ");
            for (FullTimeEmployee fullTimeEmployee : ftRef) {
                if (fullTimeEmployee == null) continue;
                this.getEntityManager().persist((Object)fullTimeEmployee);
                this.getEntityManager().flush();
                this.logTrace("persisted employee " + fullTimeEmployee);
            }
            Client.ptRef[0] = new PartTimeEmployee(6, "Kellie", "Lee", this.d5, 60000.0f);
            Client.ptRef[1] = new PartTimeEmployee(7, "Nicole", "Martin", this.d4, 60000.0f);
            Client.ptRef[2] = new PartTimeEmployee(8, "Mark", "Francis", this.d3, 60000.0f);
            Client.ptRef[3] = new PartTimeEmployee(9, "Will", "Forrest", this.d2, 60000.0f);
            Client.ptRef[4] = new PartTimeEmployee(10, "Katy", "Hughes", this.d1, 60000.0f);
            this.logTrace("Persist part time employees ");
            for (Employee employee : ptRef) {
                if (employee == null) continue;
                this.getEntityManager().persist((Object)employee);
                this.getEntityManager().flush();
                this.logTrace("persisted employee " + (PartTimeEmployee)employee);
            }
            this.getEntityTransaction().commit();
            this.clearCache();
        }
        catch (Exception re) {
            this.logErr("Unexpected Exception creating test data:", re);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

