/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.derivedid.ex1b;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.derivedid.ex1b.DID1bDependent;
import com.sun.ts.tests.jpa.core.derivedid.ex1b.DID1bDependentId;
import com.sun.ts.tests.jpa.core.derivedid.ex1b.DID1bEmployee;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void DIDTest() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            DID1bEmployee employee1 = new DID1bEmployee(1L, "Duke");
            DID1bEmployee employee2 = new DID1bEmployee(2L, "foo");
            DID1bDependentId depId1 = new DID1bDependentId("Obama", 1L);
            DID1bDependentId depId2 = new DID1bDependentId("Michelle", 1L);
            DID1bDependentId depId3 = new DID1bDependentId("John", 2L);
            DID1bDependent dep1 = new DID1bDependent(depId1, employee1);
            DID1bDependent dep2 = new DID1bDependent(depId2, employee1);
            DID1bDependent dep3 = new DID1bDependent(depId3, employee2);
            this.getEntityManager().persist((Object)dep1);
            this.getEntityManager().persist((Object)dep2);
            this.getEntityManager().persist((Object)dep3);
            this.getEntityManager().persist((Object)employee1);
            this.getEntityManager().persist((Object)employee2);
            TestUtil.logTrace((String)"persisted Employees and Dependents");
            this.getEntityManager().flush();
            DID1bDependent newDependent = (DID1bDependent)this.getEntityManager().find(DID1bDependent.class, (Object)depId1);
            if (newDependent != null) {
                this.getEntityManager().refresh((Object)newDependent);
            }
            List depList = this.getEntityManager().createQuery("Select d from DID1bDependent d where d.id.name='Obama' and d.emp.name='Duke'").getResultList();
            newDependent = null;
            if (depList.size() > 0) {
                newDependent = (DID1bDependent)depList.get(0);
                if (newDependent == dep1) {
                    pass = true;
                    TestUtil.logTrace((String)"Received Expected Dependent");
                } else {
                    TestUtil.logErr((String)"Searched Dependent not found");
                }
            } else {
                TestUtil.logErr((String)"getEntityManager().createQuery returned null entry");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            this.getEntityTransaction().rollback();
        }
        if (!pass) {
            throw new EETest.Fault("DIDTest failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID1BDEPENDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID1BEMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

