/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.vehicle.ejbliteshare;

import com.sun.javatest.Status;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.ejbliteshare.ReasonableStatus;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.logging.Logger;

public class EJBLiteWebVehicleRunner
implements VehicleRunnable {
    private static final Logger logger = Logger.getLogger(EJBLiteWebVehicleRunner.class.getName());

    protected String getServletPath(String vehicle) {
        return "/" + vehicle + "_vehicle.jsp";
    }

    protected String getQueryString(Properties p) {
        return "?testName=" + p.getProperty("testName");
    }

    @Override
    public Status run(String[] argv, Properties p) {
        String vehicle = p.getProperty("vehicle");
        String contextRoot = p.getProperty("vehicle_archive_name");
        String requestUrl = "/" + contextRoot + this.getServletPath(vehicle) + this.getQueryString(p);
        TSURL ctsURL = new TSURL();
        URL url = null;
        HttpURLConnection connection = null;
        int statusCode = 3;
        Object response = null;
        try {
            url = ctsURL.getURL("http", p.getProperty("webServerHost"), Integer.parseInt(p.getProperty("webServerPort")), requestUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            logger.info("Connecting " + url.toExternalForm());
            connection.connect();
            response = TestUtil.getResponse((URLConnection)connection).trim();
            statusCode = ((String)response).indexOf("[TEST PASSED] ") >= 0 ? 0 : 1;
        }
        catch (IOException e) {
            statusCode = 1;
            response = "Failed to connect to the test webapp." + TestUtil.printStackTraceToString((Throwable)e);
        }
        return new ReasonableStatus(statusCode, (String)response);
    }
}

