/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.util.Vector;

public class StringArray {
    private static final String[] empty = new String[0];

    public static String[] split(String s) {
        if (s == null) {
            return empty;
        }
        Vector<String> strings = new Vector<String>();
        int start = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (StringArray.white(s.charAt(i))) {
                if (start != -1) {
                    strings.add(s.substring(start, i));
                }
                start = -1;
                continue;
            }
            if (start != -1) continue;
            start = i;
        }
        if (start != -1) {
            strings.add(s.substring(start));
        }
        if (strings.isEmpty()) {
            return empty;
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static String join(String ... ss) {
        return StringArray.join(ss, " ");
    }

    public static String join(String[] ss, String sep) {
        if (ss == null || ss.length == 0) {
            return "";
        }
        int l = (ss.length - 1) * sep.length();
        for (String s : ss) {
            l += s == null ? 0 : s.length();
        }
        StringBuilder sb = new StringBuilder(l);
        sb.append(ss[0]);
        for (int i = 1; i < ss.length; ++i) {
            sb.append(sep);
            sb.append(ss[i]);
        }
        return sb.toString();
    }

    public static String[] splitList(String list, String delim) {
        int nextD;
        if (list == null || list.isEmpty()) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int pos = 0;
        while ((nextD = list.indexOf(delim, pos)) != -1) {
            v.add(list.substring(pos, nextD));
            pos = nextD + delim.length();
            pos = StringArray.skipWhite(list, pos);
        }
        if (pos < list.length()) {
            v.add(list.substring(pos));
        }
        if (v.isEmpty()) {
            return new String[0];
        }
        return v.toArray(new String[v.size()]);
    }

    public static boolean contains(String[] list, String target) {
        if (list == null || list.length == 0) {
            return false;
        }
        for (String aList : list) {
            if (!aList.equals(target)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String list, String target) {
        return StringArray.contains(StringArray.split(list), target);
    }

    private static int skipWhite(String s, int start) {
        for (int i = start; i < s.length(); ++i) {
            if (StringArray.white(s.charAt(i))) continue;
            return i;
        }
        return s.length();
    }

    private static boolean white(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }
}

