/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.TestSuite;
import com.sun.javatest.report.HTMLWriterEx;
import com.sun.javatest.tool.ColorPrefsPane;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.DeskView;
import com.sun.javatest.tool.DesktopPrefsPane;
import com.sun.javatest.tool.FileOpener;
import com.sun.javatest.tool.MDIDeskView;
import com.sun.javatest.tool.ManagerLoader;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.PreferencesPane;
import com.sun.javatest.tool.SDIDeskView;
import com.sun.javatest.tool.TabDeskView;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolManager;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.jthelp.ContextHelpManager;
import com.sun.javatest.tool.jthelp.HelpBroker;
import com.sun.javatest.tool.jthelp.HelpSet;
import com.sun.javatest.tool.jthelp.JTHelpBroker;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.LogFile;
import com.sun.javatest.util.PropertyUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class Desktop {
    public static final int TAB_STYLE = 0;
    public static final int MDI_STYLE = 1;
    public static final int SDI_STYLE = 2;
    static final int NUM_STYLES = 3;
    static final String[] styleNames = new String[]{"tab", "mdi", "sdi"};
    static final String STYLE_PREF = "tool.appearance.style";
    static final String TTIP_PREF = "tool.appearance.ttipToggle";
    static final String TTIP_DELAY = "tool.appearance.ttipDelay";
    static final String TTIP_DURATION = "tool.appearance.ttipDuration";
    static final int TTIP_DURATION_FOREVER = -1;
    static final int TTIP_DELAY_NONE = 0;
    static final int TTIP_DELAY_DEFAULT = 0;
    static final int TTIP_DURATION_DEFAULT = 5000;
    static final String SAVE_ON_EXIT_PREF = "tool.appearance.saveOnExit";
    static final String RESTORE_ON_START_PREF = "tool.appearance.restoreOnStart";
    private static final int CLOSE = 0;
    private static final int EXIT = 1;
    private static final String[] jt31StyleClassNames = new String[]{"com.sun.javatest.tool.TabDesktop", "com.sun.javatest.tool.MDIDesktop", "com.sun.javatest.tool.SDIDesktop"};
    private static final int FILE_HISTORY_MAX_SIZE = 10;
    private static final String TOOLMGRLIST = "META-INF/services/com.sun.javatest.tool.ToolManager.lst";
    public static final String TOOL_MANAGERS_TO_LOAD = "services.com.sun.javatest.tool.ToolManager";
    private static final String defaultToolManager = System.getProperty("javatest.desktop.defaultToolManager", "com.sun.javatest.exec.ExecToolManager");
    private static Preferences preferences = Preferences.access();
    private final UIFactory uif;
    private JDialog confirmDialog;
    private CommandContext commandContext;
    private DeskView currView;
    private int style;
    private PreferencesPane prefsPane;
    private PreferencesPane colorPane;
    private ToolManager[] toolManagers;
    private HelpBroker helpBroker;
    private LogFile logFile;
    private boolean firstTime;
    private boolean saveOnExit;
    private PrintRequestAttributeSet printAttrs;
    private boolean restoreOnStart;
    private LinkedList<FileHistoryEntry> fileHistory = new LinkedList();

    public Desktop() {
        this(Desktop.getPreferredStyle());
    }

    public Desktop(CommandContext ctx) {
        this(Desktop.getPreferredStyle(), ctx);
    }

    public Desktop(int style, CommandContext ctx) {
        this.commandContext = ctx;
        String val = preferences.getPreference(TTIP_PREF);
        boolean t = val == null || val.equalsIgnoreCase("true");
        this.setTooltipsEnabled(t);
        int delay = Desktop.getTooltipDelay(preferences);
        this.setTooltipDelay(delay);
        int duration = Desktop.getTooltipDuration(preferences);
        this.setTooltipDuration(duration);
        String soe = preferences.getPreference(SAVE_ON_EXIT_PREF);
        this.setSaveOnExit(soe == null || "true".equalsIgnoreCase(soe));
        String rtos = preferences.getPreference(RESTORE_ON_START_PREF);
        this.setRestoreOnStart(rtos == null || "true".equalsIgnoreCase(rtos));
        File f = Desktop.getDesktopFile();
        this.firstTime = f == null || !f.exists();
        this.initHelpBroker();
        this.initLAF(ctx);
        this.uif = new UIFactory(this.getClass(), this.helpBroker);
        this.initToolManagers();
        this.style = style;
    }

    public Desktop(int style) {
        this(style, null);
    }

    public static int getPreferredStyle() {
        return 0;
    }

    static Map<String, String> getPreviousDesktop(File file) {
        if (file == null) {
            file = Desktop.getDesktopFile();
        }
        Map<String, String> stringPropsMap = new HashMap<String, String>();
        if (file != null && file.exists()) {
            try (FileInputStream fis = new FileInputStream(file);
                 BufferedInputStream in = new BufferedInputStream(fis);){
                stringPropsMap = PropertyUtils.load(in);
            }
            catch (IOException e) {
                System.err.println("Error reading desktop file: " + e);
            }
        }
        return stringPropsMap;
    }

    static int getTooltipDelay(Preferences p) {
        String val = p.getPreference(TTIP_DELAY);
        int result = 0;
        try {
            result = Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            result = 0;
        }
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    static int getTooltipDuration(Preferences p) {
        String val = p.getPreference(TTIP_DURATION);
        int result = 5000;
        try {
            result = Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            result = 5000;
        }
        if (result < 0) {
            result = result == -1 ? Integer.MAX_VALUE : 5000;
        }
        return result;
    }

    private static void appendStrings(StringBuffer sb, String ... msgs) {
        if (msgs != null) {
            for (String msg : msgs) {
                sb.append(msg);
                if (msg.endsWith("\n")) continue;
                sb.append('\n');
            }
        }
    }

    private static File getDesktopFile() {
        String s = System.getProperty("javatest.desktop.file");
        if (s == null) {
            File jtDir = Preferences.getPrefsDir();
            return new File(jtDir, "desktop");
        }
        if (!s.equals("NONE")) {
            return new File(s);
        }
        return null;
    }

    static void addHelpDebugListener(Component c) {
        JRootPane root;
        if (c instanceof JFrame) {
            root = ((JFrame)c).getRootPane();
        } else if (c instanceof JDialog) {
            root = ((JDialog)c).getRootPane();
        } else {
            throw new IllegalArgumentException();
        }
        ActionListener showFocusListener = e -> {
            Component src = (Component)e.getSource();
            Component comp = SwingUtilities.findFocusOwner(src);
            System.err.println("ALT-F2: source=" + src);
            System.err.println("ALT-F2:  focus=" + comp);
            String helpId = comp == null ? "(none)" : ContextHelpManager.getHelpIDString(comp);
            helpId = helpId == null ? ContextHelpManager.getHelpIDString(src) : helpId;
            System.err.println("ALT-F2: helpId=" + helpId);
        };
        root.registerKeyboardAction(showFocusListener, KeyStroke.getKeyStroke("alt F2"), 2);
    }

    static void addPreferredSizeDebugListener(Component c) {
        JRootPane root;
        if (c instanceof JFrame) {
            root = ((JFrame)c).getRootPane();
        } else if (c instanceof JDialog) {
            root = ((JDialog)c).getRootPane();
        } else {
            throw new IllegalArgumentException();
        }
        ActionListener showPrefSizeListener = e -> {
            Component src = (Component)e.getSource();
            for (Component c1 = SwingUtilities.findFocusOwner(src); c1 != null; c1 = c1.getParent()) {
                Dimension d = c1.getPreferredSize();
                System.err.println("ALT-1: comp=" + c1.getName() + "(" + c1.getClass().getName() + ") [w:" + d.width + ",h:" + d.height + "]");
            }
        };
        root.registerKeyboardAction(showPrefSizeListener, KeyStroke.getKeyStroke("alt 1"), 2);
    }

    private static void invokeOnEventThread(Runnable r) {
        try {
            EventQueue.invokeAndWait(r);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw (Error)t;
        }
    }

    private static int indexOf(String s, String ... a) {
        for (int i = 0; i < a.length; ++i) {
            if (!(s == null ? a[i] == null : s.equals(a[i]))) continue;
            return i;
        }
        return -1;
    }

    private static Throwable unwrap(Throwable t) {
        if (t == null) {
            return t;
        }
        Throwable t1;
        while ((t1 = t.getCause()) != null) {
            t = t1;
        }
        return t;
    }

    private void initLAF(CommandContext ctx) {
        int preferredLAF = ctx != null ? ctx.getPreferredLookAndFeel() : 1;
        switch (preferredLAF) {
            case 0: {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {}
                break;
            }
            case 2: {
                try {
                    Class<LookAndFeel> nimbusClass = Class.forName("javax.swing.plaf.metal.MetalLookAndFeel").asSubclass(LookAndFeel.class);
                    UIManager.setLookAndFeel(nimbusClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Throwable nimbusClass) {}
                break;
            }
            case 1: {
                try {
                    Class<LookAndFeel> nimbusClass = Class.forName("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel").asSubclass(LookAndFeel.class);
                    UIManager.setLookAndFeel(nimbusClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    break;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public int getStyle() {
        return this.currView == null ? this.style : this.currView.getStyle();
    }

    public void setStyle(int style) {
        if (style == this.getStyle()) {
            return;
        }
        if (this.currView == null) {
            this.style = style;
            return;
        }
        DeskView oldView = this.currView;
        switch (style) {
            case 1: {
                this.currView = new MDIDeskView(oldView);
                break;
            }
            case 2: {
                this.currView = new SDIDeskView(oldView);
                break;
            }
            case 0: {
                this.currView = new TabDeskView(oldView);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        oldView.dispose();
    }

    public HelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public boolean isFirstTime() {
        return this.firstTime;
    }

    public void setFirstTime(boolean b) {
        this.firstTime = b;
    }

    public boolean isEmpty() {
        return this.currView == null ? true : this.currView.isEmpty();
    }

    public Tool[] getTools() {
        return this.currView == null ? new Tool[]{} : this.currView.getTools();
    }

    public void addTool(Tool t) {
        this.ensureViewInitialized();
        this.currView.addTool(t);
    }

    public void removeTool(Tool t) {
        if (this.currView != null) {
            this.currView.removeTool(t);
        }
    }

    public Tool getSelectedTool() {
        return this.currView == null ? null : this.currView.getSelectedTool();
    }

    public void setSelectedTool(Tool t) {
        this.ensureViewInitialized();
        this.currView.setSelectedTool(t);
    }

    public void addDefaultTool() {
        if (!EventQueue.isDispatchThread()) {
            Desktop.invokeOnEventThread(this::addDefaultTool);
            return;
        }
        for (ToolManager m : this.toolManagers) {
            if (!m.getClass().getName().equals(defaultToolManager)) continue;
            m.startTool();
            return;
        }
    }

    public Tool addDefaultTool(InterviewParameters ip) {
        for (ToolManager mgr : this.toolManagers) {
            if (!mgr.getClass().getName().equals(defaultToolManager)) continue;
            try {
                Method m = mgr.getClass().getMethod("startTool", InterviewParameters.class);
                return (Tool)m.invoke((Object)mgr, ip);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Desktop.unwrap(e).printStackTrace();
            }
        }
        return null;
    }

    public boolean containsTool(Tool t) {
        Tool[] tools;
        for (Tool tool : tools = this.getTools()) {
            if (t != tool) continue;
            return true;
        }
        return false;
    }

    public ToolManager[] getToolManagers() {
        return this.toolManagers;
    }

    public ToolManager getToolManager(Class<? extends ToolManager> c) {
        for (ToolManager m : this.toolManagers) {
            if (!c.isInstance(m)) continue;
            return m;
        }
        return null;
    }

    public ToolManager getToolManager(String className) {
        for (ToolManager m : this.toolManagers) {
            if (!m.getClass().getName().equals(className)) continue;
            return m;
        }
        return null;
    }

    public JFrame[] getFrames() {
        this.ensureViewInitialized();
        return this.currView.getFrames();
    }

    public Component getDialogParent() {
        this.ensureViewInitialized();
        return this.currView.getDialogParent();
    }

    public void addToFileHistory(File f, FileOpener fo) {
        Iterator i = this.fileHistory.iterator();
        while (i.hasNext()) {
            FileHistoryEntry h = (FileHistoryEntry)i.next();
            if (h.fileOpener != fo || !h.file.equals(f)) continue;
            i.remove();
            break;
        }
        this.fileHistory.addFirst(new FileHistoryEntry(fo, f));
        while (this.fileHistory.size() > 10) {
            this.fileHistory.removeLast();
        }
    }

    List<FileHistoryEntry> getFileHistory() {
        return this.fileHistory;
    }

    public boolean isVisible() {
        return this.currView == null ? false : this.currView.isVisible();
    }

    public void setVisible(boolean b) {
        if (!EventQueue.isDispatchThread()) {
            Desktop.invokeOnEventThread(() -> this.setVisible(b));
            return;
        }
        this.ensureViewInitialized();
        this.currView.setVisible(b);
    }

    public Container createDialog(Tool tool, String uiKey, String title, JMenuBar menuBar, Container body, Rectangle bounds, int type) {
        this.ensureViewInitialized();
        return this.currView.createDialog(tool, uiKey, title, menuBar, body, bounds, type);
    }

    public boolean isToolOwnerForDialog(Tool tool, Container dialog) {
        this.ensureViewInitialized();
        return this.currView.isToolOwnerForDialog(tool, dialog);
    }

    public void checkToolsAndExitIfOK(JFrame parent) {
        if (this.isOKToExit(parent)) {
            if (this.getSaveOnExit()) {
                this.save();
            }
            this.dispose();
        }
    }

    public boolean isOKToClose(Tool t, JFrame parent) {
        if (this.confirmDialog != null) {
            Toolkit.getDefaultToolkit().beep();
            this.confirmDialog.toFront();
            return false;
        }
        String[] alerts = t.getCloseAlerts();
        if (alerts == null || alerts.length == 0) {
            return true;
        }
        return this.isOKToExitOrClose(parent, alerts, 0);
    }

    public boolean isOKToExit(JFrame parent) {
        Tool[] tools;
        if (this.confirmDialog != null) {
            Toolkit.getDefaultToolkit().beep();
            this.confirmDialog.toFront();
            return false;
        }
        Vector<String> v = new Vector<String>();
        for (Tool tool : tools = this.getTools()) {
            String[] alerts = tool.getCloseAlerts();
            if (alerts == null) continue;
            v.addAll(Arrays.asList(alerts));
        }
        if (v.isEmpty()) {
            return true;
        }
        return this.isOKToExitOrClose(parent, v.toArray(new String[v.size()]), 1);
    }

    private boolean isOKToExitOrClose(JFrame parent, String[] alerts, int mode) {
        if (this.confirmDialog != null) {
            Toolkit.getDefaultToolkit().beep();
            this.confirmDialog.toFront();
            return false;
        }
        Integer m = mode;
        if (alerts.length > 0) {
            StringWriter sw = new StringWriter();
            try {
                HTMLWriterEx out = new HTMLWriterEx((Writer)sw, this.uif.getI18NResourceBundle());
                out.startTag("html");
                out.startTag("head");
                out.writeContentMeta();
                out.endTag("head");
                out.startTag("body");
                out.writeStyleAttr("font-family: SansSerif");
                out.startTag("p");
                out.writeStyleAttr("margin-top:0");
                out.startTag("b");
                out.writeI18N("dt.confirm.head", (Object)m);
                out.endTag("b");
                out.endTag("p");
                out.startTag("p");
                out.startTag("i");
                out.writeI18N("dt.confirm.warn", (Object)m);
                out.endTag("i");
                out.endTag("p");
                out.startTag("ul");
                out.writeStyleAttr("margin-top:0; margin-bottom:0; margin-left:30");
                for (String alert : alerts) {
                    out.startTag("li");
                    out.write(alert);
                }
                out.endTag("ul");
                out.startTag("p");
                out.writeStyleAttr("margin-top:5");
                out.writeI18N("dt.confirm.warn2", (Object)m);
                out.startTag("br");
                out.writeI18N("dt.confirm.warn3", (Object)m);
                out.endTag("p");
                out.startTag("p");
                out.writeStyleAttr("margin-bottom:0");
                out.writeI18N("dt.confirm.tail", (Object)m);
                out.endTag("p");
                out.endTag("body");
                out.endTag("html");
                out.close();
            }
            catch (IOException e2) {
                JavaTestError.unexpectedException(e2);
            }
            JEditorPane body = new JEditorPane();
            body.setOpaque(false);
            body.setContentType("text/html");
            body.setText(sw.toString());
            body.setEditable(false);
            body.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            String title = this.uif.getI18NString("dt.confirm.title", (Object)m);
            JOptionPane pane = new JOptionPane(body, 2);
            ActionListener l = e -> {
                pane.setValue(e.getSource());
                pane.setVisible(false);
            };
            JButton yesBtn = this.uif.createButton("dt.confirm.yes", l);
            JButton noBtn = this.uif.createButton("dt.confirm.no", l);
            pane.setOptions(new JComponent[]{yesBtn, noBtn});
            pane.setInitialValue(noBtn);
            this.confirmDialog = pane.createDialog(parent, title);
            this.confirmDialog.setVisible(true);
            this.confirmDialog.dispose();
            this.confirmDialog = null;
            return pane.getValue() == yesBtn;
        }
        return true;
    }

    public boolean isOKToAutoExit() {
        int delay = 30;
        final JTextArea body = new JTextArea();
        body.setOpaque(false);
        body.setText(this.uif.getI18NString("dt.autoExit.txt", (Object)30));
        body.setEditable(false);
        body.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        body.setSize(new Dimension(4 * this.uif.getDotsPerInch(), Integer.MAX_VALUE));
        final JOptionPane pane = new JOptionPane(body, 2, 2);
        String title = this.uif.getI18NString("dt.confirm.title", (Object)1);
        final JDialog dialog = pane.createDialog(null, title);
        Timer timer = new Timer(1000, new ActionListener(){
            private int timeRemaining = 30;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (--this.timeRemaining == 0) {
                    pane.setValue(0);
                    dialog.setVisible(false);
                } else {
                    body.setText(Desktop.this.uif.getI18NString("dt.autoExit.txt", (Object)this.timeRemaining));
                }
            }
        });
        timer.start();
        dialog.setVisible(true);
        timer.stop();
        Object value = pane.getValue();
        return value != null && value.equals(0);
    }

    public void save() {
        this.save(Desktop.getDesktopFile());
    }

    public void save(File f) {
        if (f == null) {
            return;
        }
        TreeMap<String, String> p = new TreeMap<String, String>();
        int s = this.getStyle();
        if (s < 3) {
            p.put("dt.style", styleNames[s]);
            p.put("dt.class", jt31StyleClassNames[s]);
        }
        this.ensureViewInitialized();
        this.currView.saveDesktop(p);
        Preferences.access().save();
        p.put("file.count", String.valueOf(this.fileHistory.size()));
        int n = 0;
        for (FileHistoryEntry h : this.fileHistory) {
            p.put("fileHistory." + n + ".type", h.fileOpener.getFileType());
            p.put("fileHistory." + n + ".path", h.file.getPath());
            ++n;
        }
        try {
            File dir = f.getParentFile();
            if (dir != null && !dir.exists()) {
                dir.mkdirs();
            }
            try (FileOutputStream fos = new FileOutputStream(f);
                 BufferedOutputStream out = new BufferedOutputStream(fos);){
                PropertyUtils.store(p, out, "JT Harness Desktop");
            }
        }
        catch (IOException e) {
            System.err.println(this.uif.getI18NString("dt.cantWriteDt.txt", (Object)e.getMessage()));
        }
    }

    public void restore() {
        this.restore(Desktop.getDesktopFile());
    }

    public void restore(File file) {
        Map<String, String> p = Desktop.getPreviousDesktop(file);
        this.restore0(p);
    }

    public void restoreHistory() {
        this.restoreHistory(Desktop.getPreviousDesktop(Desktop.getDesktopFile()));
    }

    private void restore0(Map<String, String> p) {
        Tool[] tools;
        Tool t;
        if (!EventQueue.isDispatchThread()) {
            Desktop.invokeOnEventThread(() -> this.restore0(p));
            return;
        }
        this.restoreHistory(p);
        this.ensureViewInitialized();
        this.currView.restoreDesktop(p);
        if (this.getTools().length == 0) {
            this.addDefaultTool();
        }
        if ((t = this.getSelectedTool()) == null && (tools = this.getTools()).length > 0) {
            t = tools[0];
        }
        if (t != null) {
            this.setSelectedTool(t);
        }
        this.setVisible(true);
    }

    private void restoreHistory(Map<String, String> p) {
        HashMap<String, FileOpener> allOpeners = new HashMap<String, FileOpener>();
        for (ToolManager m : this.toolManagers) {
            FileOpener[] mgrOpeners = m.getFileOpeners();
            if (mgrOpeners == null) continue;
            for (FileOpener fo : mgrOpeners) {
                allOpeners.put(fo.getFileType(), fo);
            }
        }
        try {
            this.fileHistory.clear();
            String c = p.get("file.count");
            if (c != null) {
                int count = Integer.parseInt(c);
                for (int i = 0; i < count; ++i) {
                    try {
                        String path;
                        String ft = p.get("fileHistory." + i + ".type");
                        FileOpener fo = (FileOpener)allOpeners.get(ft);
                        if (fo == null || (path = p.get("fileHistory." + i + ".path")) == null || path.isEmpty()) continue;
                        this.fileHistory.add(new FileHistoryEntry(fo, new File(path)));
                        continue;
                    }
                    catch (Throwable e) {
                        System.err.println(this.uif.getI18NString("dt.cantLoadHist.txt"));
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void showPreferences(JFrame parent) {
        if (this.prefsPane == null) {
            this.prefsPane = new DesktopPrefsPane(this, this.uif);
        }
        if (this.colorPane == null) {
            this.colorPane = new ColorPrefsPane(this.uif);
        }
        Vector<PreferencesPane> v = new Vector<PreferencesPane>();
        v.add(this.prefsPane);
        v.add(this.colorPane);
        for (ToolManager m : this.toolManagers) {
            PreferencesPane p = m.getPrefsPane();
            if (p == null) continue;
            v.add(p);
        }
        PreferencesPane[] custom = this.getCustomPreferences();
        if (custom != null) {
            for (PreferencesPane aCustom : custom) {
                v.add(aCustom);
            }
        }
        PreferencesPane.showDialog(parent, preferences, v.toArray(new PreferencesPane[v.size()]), this.helpBroker);
    }

    private PreferencesPane[] getCustomPreferences() {
        Tool[] tools;
        ArrayList<PreferencesPane> al = new ArrayList<PreferencesPane>();
        HashSet<String> customPrefsClasses = new HashSet<String>();
        for (Tool tool : tools = this.getTools()) {
            TestSuite[] tss = tool.getLoadedTestSuites();
            if (tss == null || tss.length <= 0) continue;
            for (TestSuite ts : tss) {
                if (customPrefsClasses.contains(ts.getID())) continue;
                customPrefsClasses.add(ts.getID());
                String cls = ts.getTestSuiteInfo("prefsPane");
                try {
                    if (cls == null) continue;
                    PreferencesPane pane = Class.forName(cls, true, ts.getClassLoader()).asSubclass(PreferencesPane.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    al.add(pane);
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!al.isEmpty()) {
            PreferencesPane[] panes = new PreferencesPane[al.size()];
            al.toArray(panes);
            return panes;
        }
        return null;
    }

    public Icon getLogo() {
        return this.uif.createIcon("dt.logo");
    }

    public void dispose() {
        if (this.currView != null) {
            this.currView.dispose();
        }
    }

    public void log(I18NResourceBundle i18n, String key) {
        this.ensureLogFileInitialized();
        this.logFile.log(i18n, key);
    }

    public void log(I18NResourceBundle i18n, String key, Object arg) {
        this.ensureLogFileInitialized();
        this.logFile.log(i18n, key, arg);
    }

    public void log(I18NResourceBundle i18n, String key, Object ... args) {
        this.ensureLogFileInitialized();
        this.logFile.log(i18n, key, args);
    }

    private void ensureLogFileInitialized() {
        if (this.logFile == null) {
            File f;
            String s = System.getProperty("javatest.desktop.log");
            if (s == null) {
                File jtDir = Preferences.getPrefsDir();
                f = new File(jtDir, "log.txt");
            } else {
                f = s.equals("NONE") ? null : new File(s);
            }
            try {
                BackupPolicy p = BackupPolicy.simpleBackups(5);
                p.backup(f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.logFile = f == null ? new LogFile() : new LogFile(f);
        }
    }

    public boolean getSaveOnExit() {
        return this.saveOnExit;
    }

    public void setSaveOnExit(boolean b) {
        this.saveOnExit = b;
    }

    public boolean getRestoreOnStart() {
        return this.restoreOnStart;
    }

    public void setRestoreOnStart(boolean restoreOnStart) {
        this.restoreOnStart = restoreOnStart;
    }

    void setTooltipsEnabled(boolean state) {
        ToolTipManager.sharedInstance().setEnabled(state);
    }

    void setTooltipDelay(int delay) {
        ToolTipManager.sharedInstance().setInitialDelay(delay);
    }

    void setTooltipDuration(int duration) {
        if (duration == -1) {
            ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        } else {
            ToolTipManager.sharedInstance().setDismissDelay(duration);
        }
    }

    public void printSetup() {
        this.ensurePrintAttrsInitialized();
        PrinterJob job = PrinterJob.getPrinterJob();
        job.pageDialog(this.printAttrs);
    }

    public void print(Printable printable) {
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        PrintService[] services = PrintServiceLookup.lookupPrintServices(flavor, null);
        if (services.length > 0) {
            this.ensurePrintAttrsInitialized();
            Component parent = this.getDialogParent();
            int x = (int)parent.getLocationOnScreen().getX() + parent.getWidth() / 2 - 250;
            int y = (int)parent.getLocationOnScreen().getY() + parent.getHeight() / 2 - 250;
            PrintService service = ServiceUI.printDialog(null, x, y, services, services[0], flavor, this.printAttrs);
            if (service != null) {
                DocPrintJob job = service.createPrintJob();
                try {
                    SimpleDoc doc = new SimpleDoc(printable, flavor, null);
                    job.print(doc, this.printAttrs);
                }
                catch (PrintException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void ensurePrintAttrsInitialized() {
        if (this.printAttrs == null) {
            this.printAttrs = new HashPrintRequestAttributeSet();
        }
    }

    private void initHelpBroker() {
        URL u = null;
        ClassLoader theLoader = null;
        if (this.commandContext != null) {
            Command cmd;
            Command[] cmds;
            Command[] commandArray = cmds = this.commandContext.getCommands();
            int n = commandArray.length;
            for (int i = 0; i < n && (u = HelpSet.findHelpSet(theLoader = (cmd = commandArray[i]).getCustomHelpLoader(), "jthelp.hs")) == null; ++i) {
            }
        }
        if (u == null) {
            theLoader = this.getClass().getClassLoader();
            u = HelpSet.findHelpSet(theLoader, "com/sun/javatest/help/jthelp.hs");
        }
        if (u != null) {
            this.helpBroker = new JTHelpBroker();
        }
    }

    private void initToolManagers() {
        try {
            Set<Object> s;
            String listOfManagersToLoad = System.getProperty(TOOL_MANAGERS_TO_LOAD);
            if (listOfManagersToLoad == null) {
                ManagerLoader ml = new ManagerLoader(ToolManager.class, System.err);
                ml.setManagerConstructorArgs(new Class[]{Desktop.class}, this);
                s = ml.loadManagers(TOOLMGRLIST);
            } else {
                s = new HashSet();
                for (String name : listOfManagersToLoad.split(",")) {
                    s.add(Class.forName(name).getDeclaredConstructor(Desktop.class).newInstance(this));
                }
            }
            this.toolManagers = s.toArray(new ToolManager[s.size()]);
        }
        catch (IOException e) {
            throw new JavaTestError(this.uif.getI18NResourceBundle(), "dt.cantAccessResource", new Object[]{TOOLMGRLIST, e});
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private void ensureViewInitialized() {
        if (this.currView != null) {
            return;
        }
        switch (this.style) {
            case 1: {
                this.currView = new MDIDeskView(this);
                break;
            }
            case 2: {
                this.currView = new SDIDeskView(this);
                break;
            }
            default: {
                this.currView = new TabDeskView(this);
            }
        }
    }

    static class FileHistoryEntry {
        FileOpener fileOpener;
        File file;

        FileHistoryEntry(FileOpener fo, File f) {
            this.fileOpener = fo;
            this.file = f;
        }
    }
}

