/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.report.HTMLReport;
import com.sun.javatest.report.HTMLSection;
import com.sun.javatest.report.ReportSettings;
import com.sun.javatest.report.ReportWriter;
import com.sun.javatest.report.TestResultsByStatusAndTitleComparator;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

class ResultSection
extends HTMLSection {
    private final int[] fileCodes = new int[]{5, 6, 7, 8};
    private final int[] groupedFileCodes = new int[]{13, 14, 15, 16};
    private final I18NResourceBundle i18n;
    private final String[] headings;
    List<TreeSet<TestResult>> testResults;
    private TestResultTable resultTable;
    private File[] initFiles;
    private int totalFound;

    ResultSection(HTMLReport parent, ReportSettings settings, File dir, I18NResourceBundle i18n, List<TreeSet<TestResult>> sortedResults) {
        super(i18n.getString("result.title"), settings, dir, parent);
        this.i18n = i18n;
        this.headings = new String[]{i18n.getString("result.heading.passed"), i18n.getString("result.heading.failed"), i18n.getString("result.heading.errors"), i18n.getString("result.heading.notRun")};
        this.resultTable = settings.getInterview().getWorkDirectory().getTestResultTable();
        this.initFiles = settings.getInitialFiles();
        this.testResults = sortedResults;
        for (TreeSet<TestResult> s : sortedResults) {
            this.totalFound += s.size();
        }
    }

    @Override
    void writeSummary(ReportWriter repWriter) throws IOException {
        super.writeSummary(repWriter);
        repWriter.startTag("table");
        repWriter.writeAttr("border", 1);
        boolean thirdColumn = false;
        boolean secondColumn = false;
        for (int i = 0; i < this.testResults.size(); ++i) {
            thirdColumn |= this.settings.isStateFileEnabled(i) && this.hasGroupedReport(i);
            secondColumn |= this.settings.isStateFileEnabled(i);
        }
        String grouped = this.i18n.getString("result.grouped");
        String plain = this.i18n.getString("result.plain");
        for (int statusType = 0; statusType < this.testResults.size(); ++statusType) {
            String reportFile = HTMLReport.files[this.fileCodes[statusType]];
            int numberOfTests = this.testResults.get(statusType).size();
            if (numberOfTests <= 0) continue;
            repWriter.startTag("tr");
            repWriter.writeTH(this.headings[statusType], "row");
            repWriter.startTag("td");
            repWriter.writeAttr("style", "text-align:right;");
            repWriter.write(Integer.toString(numberOfTests));
            repWriter.endTag("td");
            if (secondColumn) {
                repWriter.startTag("td");
                if (this.settings.isStateFileEnabled(statusType)) {
                    repWriter.writeLink(reportFile, plain);
                } else {
                    repWriter.writeLine(" ");
                }
                repWriter.endTag("td");
            }
            if (thirdColumn) {
                repWriter.startTag("td");
                if (this.hasGroupedReport(statusType) && this.settings.isStateFileEnabled(statusType)) {
                    repWriter.writeLink(HTMLReport.files[this.groupedFileCodes[statusType]], grouped);
                } else {
                    repWriter.writeLine(" ");
                }
                repWriter.endTag("td");
            }
            repWriter.endTag("tr");
        }
        repWriter.startTag("tr");
        repWriter.writeTH(this.i18n.getString("result.total"), "row");
        repWriter.writeTD(Integer.toString(this.totalFound));
        if (secondColumn) {
            repWriter.writeTD("");
        }
        if (thirdColumn) {
            repWriter.writeTD("");
        }
        repWriter.endTag("tr");
        repWriter.endTag("table");
    }

    private boolean hasGroupedReport(int st) {
        return st == 1 || st == 0 || st == 2 || st == 3;
    }

    @Override
    void writeExtraFiles() throws IOException {
        this.writeStatusFiles();
    }

    private void writeStatusFiles() throws IOException {
        for (int resultStatusType = 0; resultStatusType < this.testResults.size(); ++resultStatusType) {
            if (!this.settings.isStateFileEnabled(resultStatusType)) continue;
            this.writeUnGroupedReport(resultStatusType);
            if (!this.hasGroupedReport(resultStatusType)) continue;
            TreeSet<TestResult> newS = new TreeSet<TestResult>(new TestResultsByStatusAndTitleComparator());
            newS.addAll((Collection<TestResult>)this.testResults.get(resultStatusType));
            this.testResults.set(resultStatusType, newS);
            this.writeGroupedReport(resultStatusType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUnGroupedReport(int resultStatusType) throws IOException {
        try (ReportWriter reportWriter = this.openAuxFile(this.fileCodes[resultStatusType], this.headings[resultStatusType], this.i18n);){
            for (TestResult testResult : this.testResults.get(resultStatusType)) {
                String workDirRelativePath = testResult.getWorkRelativePath();
                File file = new File(this.workDirRoot, workDirRelativePath.replace('/', File.separatorChar));
                if (testResult.getStatus().getType() == 3) {
                    reportWriter.write(testResult.getTestName());
                } else {
                    reportWriter.writeLink(file, testResult.getTestName());
                }
                try {
                    reportWriter.write(": " + testResult.getDescription().getTitle());
                }
                catch (TestResult.Fault fault) {
                    // empty catch block
                }
                reportWriter.startTag("br");
                reportWriter.newLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGroupedReport(int i) throws IOException {
        block13: {
            out.write(this.i18n.getString("result.groupByStatus"));
            try (ReportWriter out = this.openAuxFile(this.groupedFileCodes[i], this.headings[i], this.i18n);){
                TreeSet<TestResult> list = this.testResults.get(i);
                if (list.isEmpty()) break block13;
                boolean inList = false;
                String currentHead = null;
                for (TestResult e : list) {
                    String title;
                    try {
                        TestDescription e_td = e.getDescription();
                        title = e_td.getTitle();
                    }
                    catch (TestResult.Fault ex) {
                        title = null;
                    }
                    Status e_s = e.getStatus();
                    if (!e_s.getReason().equals(currentHead)) {
                        currentHead = e_s.getReason();
                        if (inList) {
                            inList = false;
                            out.endTag("ul");
                            out.newLine();
                        }
                        out.startTag("h4");
                        out.write(currentHead.isEmpty() ? this.i18n.getString("result.noReason") : currentHead);
                        out.endTag("h4");
                        out.newLine();
                    }
                    if (!inList) {
                        inList = true;
                        out.startTag("ul");
                    }
                    out.startTag("li");
                    String eWRPath = e.getWorkRelativePath();
                    File eFile = new File(this.workDirRoot, eWRPath.replace('/', File.separatorChar));
                    String eName = e.getTestName();
                    if (eFile == null || e_s.getType() == 3) {
                        out.write(eName);
                    } else {
                        out.writeLink(eFile, eName);
                    }
                    if (title != null) {
                        out.write(": " + title);
                    }
                    out.newLine();
                }
                if (inList) {
                    inList = false;
                    out.endTag("ul");
                }
            }
        }
    }
}

