/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.interview;

import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.interview.YesNoQuestion;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Keywords;
import com.sun.javatest.KeywordsFilter;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestSuite;
import com.sun.javatest.util.StringArray;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

public class KeywordsInterview
extends Interview
implements Parameters.MutableKeywordsParameters {
    private Keywords cachedKeywords;
    private String cachedKeywords_expr;
    private String cachedKeywordsError;
    private TestFilter cachedKeywordsFilter;
    private Question qEnd = new FinalQuestion(this);
    private InterviewParameters parent;
    private KeywordsQuestion qKeywords = new KeywordsQuestion(this, "keywords"){

        @Override
        protected Question getNext() {
            if (this.value == null || this.value.isEmpty()) {
                return null;
            }
            return KeywordsInterview.this.qEnd;
        }

        @Override
        public boolean isValueValid() {
            KeywordsInterview.this.updateCachedKeywordsData();
            return KeywordsInterview.this.cachedKeywordsError == null;
        }
    };
    private YesNoQuestion qNeedKeywords = new YesNoQuestion(this, "needKeywords", "No"){

        @Override
        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (Objects.equals(this.value, "Yes")) {
                return KeywordsInterview.this.qKeywords;
            }
            return KeywordsInterview.this.qEnd;
        }
    };

    public KeywordsInterview(InterviewParameters parent) throws Interview.Fault {
        super(parent, "keywords");
        this.parent = parent;
        this.setResourceBundle("i18n");
        this.setHelpSet("/com/sun/javatest/moreInfo/moreInfo.hs");
        this.setFirstQuestion(this.qNeedKeywords);
    }

    private static boolean equal(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public void dispose() {
        this.cachedKeywords = null;
        this.cachedKeywords_expr = null;
        this.cachedKeywordsError = null;
        this.cachedKeywordsFilter = null;
    }

    @Override
    public Keywords getKeywords() {
        if (Objects.equals(this.qNeedKeywords.getValue(), "Yes")) {
            this.updateCachedKeywordsData();
            return this.cachedKeywords;
        }
        return null;
    }

    @Override
    public void setKeywords(int mode, String value) {
        if (value == null) {
            this.setKeywordsMode(1);
        } else {
            this.setKeywordsMode(2);
            this.setMatchKeywords(mode, value);
        }
    }

    @Override
    public int getKeywordsMode() {
        return Objects.equals(this.qNeedKeywords.getValue(), "Yes") ? 2 : 1;
    }

    @Override
    public void setKeywordsMode(int mode) {
        this.qNeedKeywords.setValue(mode == 2 ? "Yes" : "No");
    }

    @Override
    public int getMatchKeywordsMode() {
        return this.qKeywords.getMode();
    }

    @Override
    public String getMatchKeywordsValue() {
        return this.qKeywords.getModeValue();
    }

    @Override
    public void setMatchKeywords(int mode, String value) {
        this.qKeywords.setValue(mode, value);
    }

    public TestFilter getKeywordFilter() {
        if (Objects.equals(this.qNeedKeywords.getValue(), "Yes")) {
            this.updateCachedKeywordsData();
            return this.cachedKeywordsFilter;
        }
        return null;
    }

    private void updateCachedKeywordsData() {
        String expr = this.qKeywords.getValue();
        if (!KeywordsInterview.equal(this.cachedKeywords_expr, expr)) {
            try {
                Keywords k;
                TestSuite ts = this.parent.getTestSuite();
                if (ts == null) {
                    throw new IllegalStateException("Null TestSuite, cannot get keyword info");
                }
                String[] validKeywords = ts.getKeywords();
                HashSet<String> validKeywordsSet = validKeywords == null ? null : new HashSet<String>(Arrays.asList(validKeywords));
                int mode = this.qKeywords.getMode();
                String modeName = mode == 1 ? "any of" : (mode == 2 ? "all of" : "expr");
                this.cachedKeywords = k = Keywords.create(modeName, this.qKeywords.getModeValue(), validKeywordsSet);
                this.cachedKeywordsFilter = new KeywordsFilter(k);
                this.cachedKeywordsError = null;
            }
            catch (Keywords.Fault e) {
                this.cachedKeywords = null;
                this.cachedKeywordsFilter = null;
                this.cachedKeywordsError = e.getMessage();
            }
            this.cachedKeywords_expr = expr;
        }
    }

    private static abstract class KeywordsQuestion
    extends StringQuestion {
        private int mode;
        private String modeValue;

        KeywordsQuestion(Interview i, String t) {
            super(i, t);
        }

        public int getMode() {
            return this.mode;
        }

        public String getModeValue() {
            return this.modeValue;
        }

        public void setValue(int m, String v) {
            switch (m) {
                case 1: {
                    this.mode = 1;
                    this.modeValue = v;
                    super.setValue(this.termsToExpr(v, " | "));
                    break;
                }
                case 2: {
                    this.mode = 2;
                    this.modeValue = v;
                    super.setValue(this.termsToExpr(v, " & "));
                    break;
                }
                default: {
                    this.mode = 3;
                    this.modeValue = v;
                    super.setValue(v == null || v.isEmpty() ? null : v);
                }
            }
        }

        @Override
        public void setValue(String v) {
            if (v != null && v.equals(this.getValue())) {
                return;
            }
            this.mode = 3;
            this.modeValue = v;
            super.setValue(this.modeValue);
        }

        @Override
        public void load(Map<String, String> data) {
            String m = data.get(this.tag + ".mode");
            String v = data.get(this.tag + ".value");
            if (m == null) {
                super.load(data);
            } else if (m instanceof String && (v == null || v instanceof String)) {
                String ms = m;
                String vs = v;
                if (ms.equals("allOf")) {
                    this.setValue(2, vs);
                } else if (ms.equals("anyOf")) {
                    this.setValue(1, vs);
                } else {
                    this.setValue(3, vs);
                }
            }
        }

        @Override
        public void save(Map<String, String> data) {
            super.save(data);
            String modeText = this.mode == 1 ? "anyOf" : (this.mode == 2 ? "allOf" : "expr");
            data.put(this.tag + ".mode", modeText);
            if (this.modeValue != null) {
                data.put(this.tag + ".value", this.modeValue);
            }
        }

        private String termsToExpr(String list, String op) {
            if (list == null || list.isEmpty()) {
                return null;
            }
            String[] keys = StringArray.split(list);
            StringBuilder sb = new StringBuilder(list.length());
            for (int i = 0; i < keys.length; ++i) {
                if (i > 0) {
                    sb.append(op);
                }
                sb.append(keys[i]);
            }
            return sb.toString();
        }
    }
}

