/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.batch;

import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResult;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.VerboseCommand;
import com.sun.javatest.util.FormattingUtils;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;

class RunTestsCommand
extends Command {
    private static final String DATE_OPTION = "date";
    private static final String NON_PASS_OPTION = "non-pass";
    private static final String START_OPTION = "start";
    private static final String FINISH_OPTION = "stop";
    private static final String PROGRESS_OPTION = "progress";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(RunTestsCommand.class);
    private Harness harness;
    private CommandContext ctx;

    RunTestsCommand() {
        super(RunTestsCommand.getName());
    }

    RunTestsCommand(ListIterator<String> argIter) {
        super(RunTestsCommand.getName());
    }

    static String getName() {
        return "runTests";
    }

    static void initVerboseOptions() {
        VerboseCommand.addOption(DATE_OPTION, new HelpTree.Node(i18n, "runTests.verbose.date"));
        VerboseCommand.addOption(NON_PASS_OPTION, new HelpTree.Node(i18n, "runTests.verbose.nonPass"));
        VerboseCommand.addOption(START_OPTION, new HelpTree.Node(i18n, "runTests.verbose.start"));
        VerboseCommand.addOption(FINISH_OPTION, new HelpTree.Node(i18n, "runTests.verbose.stop"));
        VerboseCommand.addOption(PROGRESS_OPTION, new HelpTree.Node(i18n, "runTests.verbose.progress"));
    }

    @Override
    public boolean isActionCommand() {
        return true;
    }

    @Override
    public void run(CommandContext ctx) throws Command.Fault {
        this.ctx = ctx;
        try {
            int testsFound;
            Harness.Observer[] observers;
            Harness h;
            InterviewParameters p = this.getConfig(ctx);
            this.harness = h = new Harness();
            for (Harness.Observer observer : observers = ctx.getHarnessObservers()) {
                h.addObserver(observer);
            }
            VerboseObserver vo = new VerboseObserver(ctx);
            h.addObserver(vo);
            BatchObserver bo = new BatchObserver();
            h.addObserver(bo);
            p.getTestSuite().getTestFinder().setErrorHandler(bo);
            boolean ok = h.batch(p);
            if (bo.getFinderErrorCount() > 0) {
                ctx.printErrorMessage(i18n, "runTests.warnError");
            }
            int[] boStats = bo.getStats();
            int remainingFromFound = this.harness.getTestsFoundCount() - boStats[0] - boStats[1] - boStats[2];
            boStats[3] = remainingFromFound >= 0 ? remainingFromFound : 0;
            int skipped = this.harness.getTestIterator().getRejectCount();
            HashMap<TestFilter, ArrayList<TestDescription>> stats = this.harness.getTestIterator().getFilterStats();
            h.notifyOfTheFinalStats(stats != null ? Collections.unmodifiableMap(stats) : Collections.emptyMap(), boStats);
            if (!ctx.isVerboseQuiet()) {
                this.printTime("runTests.totalTime", h.getElapsedTime() / 1000L);
                this.printTime("runTests.setupTime", h.getTotalSetupTime() / 1000L);
                this.printTime("runTests.cleanupTime", h.getTotalCleanupTime() / 1000L);
                this.showResultStats(skipped, boStats);
            }
            if ((testsFound = h.getTestsFoundCount()) > 0 && !ctx.isVerboseQuiet()) {
                ctx.printMessage(i18n, "runTests.resultsDone", (Object)p.getWorkDirectory().getPath());
            }
            if (!ok && testsFound > 0 && testsFound != boStats[0]) {
                ctx.printErrorMessage(i18n, "runTests.testsFailed");
            }
            ctx.addTestStats(boStats);
        }
        catch (Harness.Fault e) {
            throw new Command.Fault((Command)this, i18n, "runTests.harnessError", (Object)e.getMessage());
        }
    }

    private void printTime(String messageKey, long timeSeconds) {
        if (timeSeconds <= 60L) {
            this.ctx.printMessage(i18n, messageKey, (Object)FormattingUtils.formattedDuration(timeSeconds));
        } else {
            this.ctx.printMessage(i18n, messageKey + ".withSecondsTotal", FormattingUtils.formattedDuration(timeSeconds), timeSeconds);
        }
    }

    private void showResultStats(int skipped, int ... stats) {
        int passed = stats[0];
        int failed = stats[1];
        int errors = stats[2];
        int notRun = stats[3];
        this.harness.getResultTable().getTestFinder().totalNumberOfTestsInTheSuite().ifPresent(totalNumber -> this.ctx.printMessage(i18n, "runTests.testsInTheSuite", totalNumber));
        if (passed + failed + errors + notRun + skipped == 0) {
            this.ctx.printMessage(i18n, "runTests.noTests");
        } else {
            this.ctx.printMessage(i18n, "runTests.tests", RunTestsCommand.getTestSummaryStatsArgs(passed, failed, errors, notRun, skipped));
        }
        this.ctx.getLogWriter().println();
        for (Map.Entry<TestFilter, ArrayList<TestDescription>> entry : this.harness.getTestIterator().getFilterStats().entrySet()) {
            TestFilter filter = entry.getKey();
            int number = entry.getValue().size();
            this.ctx.getLogWriter().println(number + " " + (number == 1 ? "test" : "tests") + " skipped by filter \"" + filter.getName() + "\"");
        }
    }

    public static Object[] getTestSummaryStatsArgs(int passed, int failed, int errors, int notRun, int skipped) {
        return new Integer[]{passed, passed > 0 && failed + errors + notRun + skipped > 0 ? 1 : 0, failed, failed > 0 && errors + notRun + skipped > 0 ? 1 : 0, errors, errors > 0 && notRun + skipped > 0 ? 1 : 0, notRun, notRun > 0 && skipped > 0 ? 1 : 0, skipped};
    }

    private class VerboseObserver
    implements Harness.Observer {
        public static final int NO_DATE = 0;
        public static final int NON_PASS = 1;
        public static final int START = 2;
        public static final int FINISH = 3;
        public static final int PROGRESS = 4;
        public static final int DEFAULT = 4;
        private static final int OPTION_COUNT = 5;
        private boolean[] options;
        private boolean quiet_flag = false;
        private boolean max_flag = false;
        private DateFormat df;
        private CommandContext ctx;
        private PrintWriter out;
        private int[] stats;
        private boolean progressOnline = false;

        VerboseObserver(CommandContext ctx) {
            this.ctx = ctx;
            this.out = ctx.getLogWriter();
            this.quiet_flag = ctx.isVerboseQuiet();
            this.df = DateFormat.getDateTimeInstance(2, 2);
            ctx.addHarnessObserver(this);
            boolean defaultFlag = ctx.getVerboseOptionValue("default", false);
            this.options = new boolean[5];
            this.options[0] = !ctx.isVerboseTimestampEnabled();
            this.options[1] = ctx.getVerboseOptionValue(RunTestsCommand.NON_PASS_OPTION, false);
            this.options[2] = ctx.getVerboseOptionValue(RunTestsCommand.START_OPTION, false);
            this.options[3] = ctx.getVerboseOptionValue(RunTestsCommand.FINISH_OPTION, false);
            this.options[4] = ctx.getVerboseOptionValue(RunTestsCommand.PROGRESS_OPTION, defaultFlag);
        }

        public boolean isVerbose(int kind) {
            if (this.quiet_flag) {
                return false;
            }
            if (this.max_flag) {
                return true;
            }
            if (kind < 5) {
                return this.options[kind];
            }
            return false;
        }

        private void printTimestamp() {
            if (this.quiet_flag || this.options[0]) {
                return;
            }
            this.out.print(this.df.format(new Date()));
            this.out.print(" ");
        }

        @Override
        public void startingTestRun(Parameters params) {
            this.stats = new int[4];
            if (!this.quiet_flag) {
                if (this.progressOnline) {
                    this.out.println();
                }
                this.printTimestamp();
                this.ctx.printMessage(i18n, "cmgr.verb.strt", (Object)params.getEnv().getName());
                this.out.flush();
                this.progressOnline = false;
            }
        }

        @Override
        public void startingTest(TestResult tr) {
            if (!this.isVerbose(2)) {
                return;
            }
            if (this.progressOnline) {
                this.out.println();
            }
            this.printTimestamp();
            this.ctx.printMessage(i18n, "cmgr.verb.tsts", (Object)tr.getTestName());
            this.out.flush();
            this.progressOnline = false;
        }

        @Override
        public void finishedTest(TestResult tr) {
            Status s = tr.getStatus();
            int n = s.getType();
            this.stats[n] = this.stats[n] + 1;
            switch (s.getType()) {
                case 1: 
                case 2: {
                    if (!this.isVerbose(1) && !this.isVerbose(3)) break;
                    this.printFinish(s, tr);
                    this.progressOnline = false;
                    break;
                }
                default: {
                    if (!this.isVerbose(3)) break;
                    this.printFinish(s, tr);
                    this.progressOnline = false;
                }
            }
            this.printStats();
            this.out.flush();
        }

        @Override
        public void stoppingTestRun() {
            if (this.progressOnline) {
                this.out.println();
            }
            this.printTimestamp();
            this.ctx.printMessage(i18n, "cmgr.verb.stpng");
            this.out.flush();
            this.progressOnline = false;
        }

        @Override
        public void finishedTesting() {
            if (!this.quiet_flag) {
                if (this.progressOnline) {
                    this.out.println();
                }
                this.printTimestamp();
                this.ctx.printMessage(i18n, "cmgr.verb.donerun");
                this.out.flush();
                this.progressOnline = false;
            }
        }

        @Override
        public void finishedTestRun(boolean allOK) {
            if (!this.quiet_flag) {
                if (this.progressOnline) {
                    this.out.println();
                }
                this.printTimestamp();
                this.ctx.printMessage(i18n, "cmgr.verb.finish");
                this.out.flush();
                this.progressOnline = false;
            }
        }

        @Override
        public void error(String msg) {
            if (this.progressOnline) {
                this.out.println();
            }
            this.printTimestamp();
            this.ctx.printErrorMessage(i18n, "cmgr.verb.err", (Object)msg);
            this.out.flush();
            this.progressOnline = false;
        }

        private void printStats() {
            if (!this.isVerbose(4)) {
                return;
            }
            if (this.progressOnline) {
                this.out.print("\r");
            }
            int p = this.stats[0];
            int f = this.stats[1];
            int e = this.stats[2];
            int nr = this.stats[3] = RunTestsCommand.this.harness.getTestsFoundCount() - p - f - e;
            this.out.print(i18n.getString("cmgr.verb.prog", p, f, e, nr));
            this.out.print("    ");
            this.progressOnline = true;
        }

        private void printFinish(Status s, TestResult tr) {
            if (!this.quiet_flag) {
                if (this.progressOnline) {
                    this.out.println();
                }
                this.printTimestamp();
                String[] args = new String[]{tr.getTestName(), s.toString()};
                this.ctx.printMessage(i18n, "cmgr.verb.tstd", args);
                this.out.flush();
                this.progressOnline = false;
            }
        }

        private boolean isScolling() {
            return this.isVerbose(2) || this.isVerbose(3);
        }
    }

    private class BatchObserver
    implements Harness.Observer,
    TestFinder.ErrorHandler {
        private int[] stats;
        private int finderErrors;

        private BatchObserver() {
        }

        int[] getStats() {
            return this.stats;
        }

        int getFinderErrorCount() {
            return this.finderErrors;
        }

        @Override
        public void startingTestRun(Parameters params) {
            this.stats = new int[4];
        }

        @Override
        public void finishedTest(TestResult tr) {
            int n = tr.getStatus().getType();
            this.stats[n] = this.stats[n] + 1;
        }

        @Override
        public void error(String msg) {
            RunTestsCommand.this.ctx.printMessage(i18n, "runTests.error", (Object)msg);
            ++this.finderErrors;
        }
    }
}

