/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Checklist;
import com.sun.interview.Interview;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class Question {
    protected final String key;
    protected Interview interview;
    protected String tag;
    private String baseTag;
    private String text;
    private String summary;
    private Object helpID;
    private URL image;

    protected Question(Interview interview, String baseTag) {
        if (baseTag == null || baseTag.isEmpty()) {
            throw new IllegalArgumentException("No tag specified");
        }
        this.interview = interview;
        this.baseTag = baseTag;
        this.updateTag();
        interview.add(this);
        String c = interview.getClass().getName();
        int dot = c.lastIndexOf(46);
        if (dot != -1) {
            c = c.substring(dot + 1);
        }
        c = c.replace('$', '.');
        this.key = c + "." + baseTag;
    }

    protected Question(Interview interview) {
        this.interview = interview;
        this.baseTag = null;
        this.tag = null;
        this.key = null;
    }

    public Interview getInterview() {
        return this.interview;
    }

    public String getKey() {
        return this.key;
    }

    public String getTag() {
        return this.tag;
    }

    String getBaseTag() {
        return this.baseTag;
    }

    void updateTag() {
        this.tag = this.interview.getTag() == null ? this.baseTag : this.interview.getTag() + "." + this.baseTag;
    }

    public String getText() {
        if (this.text == null) {
            this.text = this.getResourceString(this.interview, this.key + ".text", true);
            if (this.text == null) {
                this.text = this.key + ".text";
            }
        }
        return MessageFormat.format(this.text, this.getTextArgs());
    }

    protected void setText(String text) {
        this.text = text.trim();
    }

    protected Object[] getTextArgs() {
        return null;
    }

    public String getSummary() {
        if (this.summary == null) {
            this.summary = this.getResourceString(this.interview, this.key + ".smry", true);
            if (this.summary == null) {
                this.summary = this.key + ".smry";
            }
        }
        return this.summary;
    }

    protected void setSummary(String summary) {
        this.summary = summary.trim();
    }

    public URL getImage() {
        if (this.image == null) {
            this.image = this.getClass().getResource(this.tag + ".gif");
        }
        if (this.image == null) {
            this.image = this.interview.getDefaultImage();
        }
        return this.image;
    }

    public void setImage(String resource) {
        this.image = Question.class.getResource(resource);
    }

    protected void setImage(URL u) {
        this.image = u;
    }

    public Object getHelpID() {
        return this.helpID;
    }

    public void setHelpID(Object object) {
        this.helpID = object;
    }

    public Checklist.Item[] getChecklistItems() {
        return null;
    }

    public void addMarker(String name) {
        this.interview.addMarker(this, name);
    }

    public void removeMarker(String name) {
        this.interview.removeMarker(this, name);
    }

    public boolean hasMarker(String name) {
        return this.interview.hasMarker(this, name);
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isEnabled() {
        return !this.isHidden();
    }

    protected abstract Question getNext();

    public abstract void clear();

    public abstract String getStringValue();

    public abstract void setValue(String var1) throws Interview.Fault;

    public abstract boolean isValueValid();

    public abstract boolean isValueAlwaysValid();

    protected void load(Map<String, String> data) {
        String value = data.get(this.tag);
        if (value != null) {
            try {
                this.setValue(value);
            }
            catch (Interview.Fault e) {
                throw new RuntimeException("Interview.Fault thrown when tried to set value '" + value + "' for question with tag '" + this.tag + "'", e);
            }
        }
    }

    protected abstract void save(Map<String, String> var1);

    protected void export(Map<String, String> data) {
    }

    public void reload() {
        HashMap<String, String> map = new HashMap<String, String>();
        this.save(map);
        this.clear();
        this.load(map);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Question)) {
            return false;
        }
        Question oq = (Question)other;
        return Objects.equals(this.tag, oq.tag) && Objects.equals(this.getStringValue(), oq.getStringValue());
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this.tag ? 0 : this.tag.hashCode());
        String str_val = this.getStringValue();
        hash = 31 * hash + (null == str_val ? 0 : str_val.hashCode());
        return hash;
    }

    protected String getResourceString(String key) {
        return this.interview.getResourceString(key);
    }

    protected String getResourceString(String key, boolean checkAncestorsFirst) {
        return this.interview.getResourceString(key, checkAncestorsFirst);
    }

    private String getResourceString(Interview interview, String key, boolean checkAncestorsFirst) {
        return interview.getResourceString(key, checkAncestorsFirst);
    }
}

