/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.FileFilter;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.io.File;
import java.util.Map;

public abstract class FileQuestion
extends Question {
    protected File value;
    protected File[] suggestions;
    private File defaultValue;
    private File baseDir;
    private boolean baseRelativeOnly;
    private FileFilter[] filters;

    protected FileQuestion(Interview interview, String tag) {
        super(interview, tag);
        if (interview.getInterviewSemantics() > 0) {
            this.clear();
        }
        this.setDefaultValue(this.value);
    }

    protected static boolean equal(File f1, File f2) {
        return f1 == null ? f2 == null : f1.equals(f2);
    }

    public File[] getSuggestions() {
        return this.suggestions;
    }

    public void setSuggestions(File ... newSuggestions) {
        if (newSuggestions != null) {
            for (File newSuggestion : newSuggestions) {
                if (newSuggestion != null) continue;
                throw new IllegalArgumentException();
            }
        }
        this.suggestions = newSuggestions;
    }

    public File getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(File v) {
        this.defaultValue = v;
    }

    public File getValue() {
        return this.value;
    }

    @Override
    public void setValue(String path) {
        this.setValue(path == null ? null : new File(path));
    }

    public void setValue(File newValue) {
        File oldValue = this.value;
        this.value = newValue;
        if (!FileQuestion.equal(this.value, oldValue)) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public File getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    @Override
    public String getStringValue() {
        return this.value == null ? null : this.value.getPath();
    }

    @Override
    public boolean isValueValid() {
        if (this.value == null) {
            return true;
        }
        if (this.baseRelativeOnly && this.baseDir != null && !this.value.getPath().startsWith(this.baseDir.getPath())) {
            return false;
        }
        if (this.filters != null) {
            for (FileFilter f : this.filters) {
                if (f.accept(this.value)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValueAlwaysValid() {
        return false;
    }

    public FileFilter[] getFilters() {
        return this.filters;
    }

    public void setFilters(FileFilter ... filters) {
        this.filters = filters;
    }

    public void setFilter(FileFilter filter) {
        this.filters = new FileFilter[]{filter};
    }

    public File getBaseDirectory() {
        return this.baseDir;
    }

    public void setBaseDirectory(File dir) {
        this.baseDir = dir;
    }

    public boolean isBaseRelativeOnly() {
        return this.baseRelativeOnly;
    }

    public void setBaseRelativeOnly(boolean b) {
        this.baseRelativeOnly = b;
    }

    @Override
    public void clear() {
        this.setValue(this.defaultValue);
    }

    @Override
    protected void load(Map<String, String> data) {
        String s = data.get(this.tag);
        if (s != null) {
            this.setValue(new File(s));
        }
    }

    @Override
    protected void save(Map<String, String> data) {
        if (this.value != null) {
            data.put(this.tag, this.value.toString());
        }
    }
}

