/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.exceptiontests;

import ee.jakarta.tck.jsonp.common.JSONP_Util;
import ee.jakarta.tck.jsonp.common.MyJsonLocation;
import jakarta.json.JsonException;
import jakarta.json.stream.JsonGenerationException;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParsingException;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientTests {
    private static final Logger LOGGER = Logger.getLogger(ClientTests.class.getName());

    @Test
    public void jsonExceptionConstructorTest1() {
        try {
            String message = "This JSON is incorrect.";
            LOGGER.info("Test JsonException(String)");
            JsonException exception = new JsonException(message);
            try {
                throw exception;
            }
            catch (JsonException e) {
                Assertions.assertEquals((Object)message, (Object)e.getMessage(), (String)"jsonExceptionConstructorTest1 failed");
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonExceptionConstructorTest1 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonExceptionConstructorTest2() {
        try {
            String message = "This JSON is incorrect due to foo.";
            Exception foo = new Exception("This is a foo exception");
            LOGGER.info("Test JsonException(String, Throwable)");
            JsonException exception = new JsonException(message, (Throwable)foo);
            try {
                throw exception;
            }
            catch (JsonException e) {
                Assertions.assertTrue((boolean)this.isPass(foo, (Exception)((Object)e), message), (String)"jsonExceptionConstructorTest2 failed");
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonExceptionConstructorTest2 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonParsingExceptionConstructorTest1() {
        boolean pass = true;
        try {
            String message = "This JSON is incorrect.";
            MyJsonLocation expLoc = new MyJsonLocation(10L, 20L, 30L);
            LOGGER.info("MyJsonLocation");
            JSONP_Util.dumpLocation((JsonLocation)expLoc);
            LOGGER.info("Test JsonParsingException(String, JsonLocation)");
            JsonParsingException exception = new JsonParsingException(message, (JsonLocation)expLoc);
            try {
                throw exception;
            }
            catch (JsonParsingException e) {
                if (!e.getMessage().equals(message)) {
                    LOGGER.warning("Incorrect message: expected " + message + ", received " + e.getMessage());
                    pass = false;
                }
                JsonLocation actLoc = exception.getLocation();
                LOGGER.info("JsonParsingException.getLocation()");
                JSONP_Util.dumpLocation((JsonLocation)actLoc);
                if (!JSONP_Util.assertEquals((JsonLocation)expLoc, (JsonLocation)actLoc)) {
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParsingExceptionConstructorTest1 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonParsingExceptionConstructorTest1 failed");
    }

    @Test
    public void jsonParsingExceptionConstructorTest2() {
        boolean pass = true;
        try {
            String message = "This JSON is incorrect due to foo.";
            Exception foo = new Exception("This is a foo exception");
            MyJsonLocation expLoc = new MyJsonLocation(10L, 20L, 30L);
            LOGGER.info("MyJsonLocation");
            JSONP_Util.dumpLocation((JsonLocation)expLoc);
            LOGGER.info("Test JsonParsingException(String, Throwable)");
            JsonParsingException exception = new JsonParsingException(message, (Throwable)foo, (JsonLocation)expLoc);
            try {
                throw exception;
            }
            catch (JsonParsingException e) {
                pass = this.isPass(foo, (Exception)((Object)e), message);
                JsonLocation actLoc = exception.getLocation();
                LOGGER.info("JsonParsingException.getLocation()");
                JSONP_Util.dumpLocation((JsonLocation)actLoc);
                if (!JSONP_Util.assertEquals((JsonLocation)expLoc, (JsonLocation)actLoc)) {
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonParsingExceptionConstructorTest2 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonParsingExceptionConstructorTest2 failed");
    }

    @Test
    public void jsonGenerationExceptionConstructorTest1() {
        try {
            String message = "This JSON is incorrect.";
            LOGGER.info("Test JsonGenerationException(String)");
            JsonGenerationException exception = new JsonGenerationException(message);
            try {
                throw exception;
            }
            catch (JsonGenerationException e) {
                Assertions.assertEquals((Object)message, (Object)e.getMessage(), (String)"jsonGenerationExceptionConstructorTest1 failed: Incorrect message");
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonGenerationExceptionConstructorTest1 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonGenerationExceptionConstructorTest2() {
        try {
            String message = "This JSON is incorrect due to foo.";
            Exception foo = new Exception("This is a foo exception");
            LOGGER.info("Test JsonGenerationException(String, Throwable)");
            JsonGenerationException exception = new JsonGenerationException(message, (Throwable)foo);
            try {
                throw exception;
            }
            catch (JsonGenerationException e) {
                Assertions.assertTrue((boolean)this.isPass(foo, (Exception)((Object)e), message), (String)"jsonGenerationExceptionConstructorTest2 failed");
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonGenerationExceptionConstructorTest2 Failed: ", (Throwable)e);
        }
    }

    private boolean isPass(Exception toCompare, Exception actual, String errorMessage) {
        boolean pass = true;
        if (!actual.getCause().equals(toCompare)) {
            LOGGER.warning("Incorrect cause: expected " + toCompare + ", received " + actual.getCause());
            pass = false;
        }
        if (!actual.getMessage().equals(errorMessage)) {
            LOGGER.warning("Incorrect message: expected " + errorMessage + ", received " + actual.getMessage());
            pass = false;
        }
        return pass;
    }
}

