/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.core.jsonb;

import ee.jakarta.tck.core.common.Utils;
import ee.jakarta.tck.core.jsonb.CustomJsonbBuilder;
import ee.jakarta.tck.core.jsonb.CustomJsonbProvider;
import ee.jakarta.tck.core.jsonb.JsonbProviderProducer;
import jakarta.inject.Inject;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.spi.JsonbProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestReporter;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JsonbApplicationIT {
    private static final String EXPECTED_JSONB_PROVIDER = CustomJsonbProvider.class.getName();
    @Inject
    JsonbProvider customProvider;

    @Deployment(testable=true)
    public static WebArchive createTestArchive() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)(JsonbApplicationIT.class.getSimpleName() + ".war"));
        ((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)archive.addClass(JsonbApplicationIT.class)).addClass(CustomJsonbProvider.class)).addClass(CustomJsonbBuilder.class)).addClass(JsonbProviderProducer.class)).addClass(Utils.class)).addAsServiceProvider(JsonbProvider.class, new Class[]{CustomJsonbProvider.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        System.out.printf("test archive: %s\n", archive.toString(true));
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(new File("/tmp/" + archive.getName()), true);
        return archive;
    }

    @Test
    public void testApplicationContextSharedBetweenJaxRsRequests(TestReporter reporter) throws Exception {
    }

    @Test
    public void testCustomProvider(TestReporter reporter) {
        JsonbProvider provider = JsonbProvider.provider((String)EXPECTED_JSONB_PROVIDER);
        String providerClass = provider.getClass().getName();
        System.out.printf("provider class=%s\n", providerClass);
        reporter.publishEntry("provider class=" + providerClass);
        if (providerClass.equals(EXPECTED_JSONB_PROVIDER)) {
            reporter.publishEntry("Current provider does matches " + EXPECTED_JSONB_PROVIDER);
        } else {
            reporter.publishEntry("Current provider does NOT matches " + EXPECTED_JSONB_PROVIDER);
            ServiceLoader<JsonbProvider> loader = ServiceLoader.load(JsonbProvider.class);
            Iterator<JsonbProvider> it = loader.iterator();
            ArrayList<JsonbProvider> providers = new ArrayList<JsonbProvider>();
            while (it.hasNext()) {
                providers.add(it.next());
            }
            reporter.publishEntry("Providers: " + providers);
            System.out.printf("Providers: %s\n", providers);
            Assertions.fail((String)("Failed to find JsonbProvider: " + EXPECTED_JSONB_PROVIDER));
        }
    }

    @Test
    public void testInjectCustomProvider(TestReporter reporter) {
        reporter.publishEntry("customProvider: " + this.customProvider);
        Assertions.assertNotNull((Object)this.customProvider, (String)"Injected JsonbProvider");
        Assertions.assertTrue((boolean)(this.customProvider instanceof CustomJsonbProvider), (String)"Injected instance is a CustomJsonbProvider");
    }

    @Test
    public void testUseCustomProvider(TestReporter reporter) {
        System.out.printf("testUseCustomProvider\n", new Object[0]);
        JsonbBuilder builder = this.customProvider.create();
        String method = Utils.popStack();
        Assertions.assertEquals((Object)"create()Ljakarta/json/bind/JsonbBuilder;", (Object)method);
        Jsonb jsonb = builder.build();
        method = Utils.popStack();
        Assertions.assertEquals((Object)"build()Ljakarta/json/bind/Jsonb;", (Object)method);
    }
}

