/*
 * Copyright 2010, Red Hat, Inc., and individual contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.cdi.tck.tests.interceptors.invocation;

import java.io.Serializable;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;

@SuppressWarnings("serial")
@Interceptor
@AlmightyBinding
@Priority(0)
public class AlmightyInterceptor implements Serializable {

    public static boolean methodIntercepted = false;

    public static boolean timeoutIntercepted = false;

    public static boolean lifecycleCallbackIntercepted = false;

    @AroundInvoke
    public Object alwaysReturnThis(InvocationContext ctx) throws Exception {
        methodIntercepted = true;
        return ctx.proceed();
    }

    @AroundTimeout
    public Object interceptTimeout(InvocationContext ctx) throws Exception {
        timeoutIntercepted = true;
        return ctx.proceed();
    }

    @PostConstruct
    public void postConstruct(InvocationContext ctx) {
        lifecycleCallbackIntercepted = true;
    }

    public static void reset() {
        methodIntercepted = false;
        lifecycleCallbackIntercepted = false;
    }

}
