/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.invokers.basic;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.build.compatible.spi.BeanInfo;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.InvokerFactory;
import jakarta.enterprise.inject.build.compatible.spi.InvokerInfo;
import jakarta.enterprise.inject.build.compatible.spi.Registration;
import jakarta.enterprise.inject.build.compatible.spi.Synthesis;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticComponents;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import java.lang.annotation.Annotation;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.invokers.InvokerHolder;
import org.jboss.cdi.tck.tests.invokers.InvokerHolderCreator;
import org.jboss.cdi.tck.tests.invokers.InvokerHolderExtensionBase;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="4.1")
public class InvokerVisibilityTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(InvokerVisibilityTest.class)).withClasses(MyPublicService.class, MyProtectedService.class, MyPackagePrivateService.class)).withBuildCompatibleExtension(TestExtension.class)).withClasses(InvokerHolder.class, InvokerHolderCreator.class, InvokerHolderExtensionBase.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="building_invoker", id="be")
    public void test(Instance<Object> lookup, InvokerHolder invokers) throws Exception {
        for (Class<MyPackagePrivateService> clazz : List.of(MyPublicService.class, MyProtectedService.class, MyPackagePrivateService.class)) {
            Object service = lookup.select(clazz, new Annotation[0]).get();
            for (String method : List.of("hello", "helloProtected", "helloPackagePrivate", "helloStatic", "helloProtectedStatic", "helloPackagePrivateStatic")) {
                String id = clazz.getSimpleName() + "_" + method;
                Assert.assertEquals((Object)invokers.get(id).invoke(service, null), (Object)id);
            }
        }
    }

    @ApplicationScoped
    public static class MyPublicService {
        public String hello() {
            return "MyPublicService_hello";
        }

        protected String helloProtected() {
            return "MyPublicService_helloProtected";
        }

        String helloPackagePrivate() {
            return "MyPublicService_helloPackagePrivate";
        }

        public static String helloStatic() {
            return "MyPublicService_helloStatic";
        }

        protected static String helloProtectedStatic() {
            return "MyPublicService_helloProtectedStatic";
        }

        static String helloPackagePrivateStatic() {
            return "MyPublicService_helloPackagePrivateStatic";
        }
    }

    @ApplicationScoped
    protected static class MyProtectedService {
        protected MyProtectedService() {
        }

        public String hello() {
            return "MyProtectedService_hello";
        }

        protected String helloProtected() {
            return "MyProtectedService_helloProtected";
        }

        String helloPackagePrivate() {
            return "MyProtectedService_helloPackagePrivate";
        }

        public static String helloStatic() {
            return "MyProtectedService_helloStatic";
        }

        protected static String helloProtectedStatic() {
            return "MyProtectedService_helloProtectedStatic";
        }

        static String helloPackagePrivateStatic() {
            return "MyProtectedService_helloPackagePrivateStatic";
        }
    }

    @ApplicationScoped
    static class MyPackagePrivateService {
        MyPackagePrivateService() {
        }

        public String hello() {
            return "MyPackagePrivateService_hello";
        }

        protected String helloProtected() {
            return "MyPackagePrivateService_helloProtected";
        }

        String helloPackagePrivate() {
            return "MyPackagePrivateService_helloPackagePrivate";
        }

        public static String helloStatic() {
            return "MyPackagePrivateService_helloStatic";
        }

        protected static String helloProtectedStatic() {
            return "MyPackagePrivateService_helloProtectedStatic";
        }

        static String helloPackagePrivateStatic() {
            return "MyPackagePrivateService_helloPackagePrivateStatic";
        }
    }

    public static class TestExtension
    extends InvokerHolderExtensionBase
    implements BuildCompatibleExtension {
        @Registration(types={MyPublicService.class})
        public void myPublicServiceRegistration(BeanInfo bean, InvokerFactory invokers) {
            this.invokersForAllMethods(bean, invokers);
        }

        @Registration(types={MyProtectedService.class})
        public void myProtectedServiceRegistration(BeanInfo bean, InvokerFactory invokers) {
            this.invokersForAllMethods(bean, invokers);
        }

        @Registration(types={MyPackagePrivateService.class})
        public void myPackagePrivateServiceRegistration(BeanInfo bean, InvokerFactory invokers) {
            this.invokersForAllMethods(bean, invokers);
        }

        private void invokersForAllMethods(BeanInfo bean, InvokerFactory invokers) {
            for (MethodInfo method : bean.declaringClass().methods()) {
                this.registerInvoker(bean.declaringClass().simpleName() + "_" + method.name(), (InvokerInfo)invokers.createInvoker(bean, method).build());
            }
        }

        @Synthesis
        public void synthesis(SyntheticComponents syn) {
            this.synthesizeInvokerHolder(syn);
        }
    }
}

