/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.invokers.basic;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.build.compatible.spi.BeanInfo;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.InvokerFactory;
import jakarta.enterprise.inject.build.compatible.spi.InvokerInfo;
import jakarta.enterprise.inject.build.compatible.spi.Registration;
import jakarta.enterprise.inject.build.compatible.spi.Synthesis;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticComponents;
import jakarta.enterprise.invoke.Invoker;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.invokers.InvokerHolder;
import org.jboss.cdi.tck.tests.invokers.InvokerHolderCreator;
import org.jboss.cdi.tck.tests.invokers.InvokerHolderExtensionBase;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="4.1")
public class GoodInstanceInvokerTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(GoodInstanceInvokerTest.class)).withClasses(MyService.class, MyServiceInterface.class)).withBuildCompatibleExtension(TestExtension.class)).withClasses(InvokerHolder.class, InvokerHolderCreator.class, InvokerHolderExtensionBase.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="behavior_of_invoke", id="da"), @SpecAssertion(section="behavior_of_invoke", id="db"), @SpecAssertion(section="behavior_of_invoke", id="dc")})
    public void test(InvokerHolder invokers) throws Exception {
        Invoker hello = invokers.get("hello");
        Assert.assertEquals((String)((String)hello.invoke((Object)this.getContextualReference(MyService.class, new Annotation[0]), new Object[]{"1"})), (String)"foobar_1");
        Assert.assertEquals((String)((String)hello.invoke((Object)new MyService(), new Object[]{"2"})), (String)"foobar_2");
        Invoker helloInterface = invokers.get("helloInterface");
        Assert.assertEquals((String)((String)helloInterface.invoke((Object)this.getContextualReference(MyServiceInterface.class, new Annotation[0]), new Object[]{"3"})), (String)"quux_3");
        Assert.assertEquals((String)((String)helloInterface.invoke((Object)new MyService(), new Object[]{"4"})), (String)"quux_4");
    }

    @ApplicationScoped
    public static class MyService
    implements MyServiceInterface {
        public String hello(String param) {
            return "foobar_" + param;
        }

        @Override
        public String helloInterface(String param) {
            return "quux_" + param;
        }
    }

    public static interface MyServiceInterface {
        public String helloInterface(String var1);
    }

    public static class TestExtension
    extends InvokerHolderExtensionBase
    implements BuildCompatibleExtension {
        @Registration(types={MyService.class})
        public void myServiceRegistration(BeanInfo bean, InvokerFactory invokers) {
            bean.declaringClass().methods().stream().filter(it -> "hello".equals(it.name()) || it.declaringClass().isInterface()).forEach(it -> this.registerInvoker(it.name(), (InvokerInfo)invokers.createInvoker(bean, it).build()));
        }

        @Synthesis
        public void synthesis(SyntheticComponents syn) {
            this.synthesizeInvokerHolder(syn);
        }
    }
}

