/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core;

import com.sun.tdk.signaturetest.core.ClassCorrector;
import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.core.Log;
import com.sun.tdk.signaturetest.core.MethodOverridingChecker;
import com.sun.tdk.signaturetest.core.PrimitiveTypes;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.MemberCollection;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.SuperClass;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.plugin.PluginAPI;
import com.sun.tdk.signaturetest.plugin.Transformer;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MemberCollectionBuilder {
    private final ClassCorrector cc;
    private final Erasurator erasurator = new Erasurator();
    private final Transformer defaultTransformer = new DefaultAfterBuildMembersTransformer();
    private final Log log;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(MemberCollectionBuilder.class);
    private BuildMode mode = BuildMode.NORMAL;
    private ClassHierarchy secondCH;

    public MemberCollectionBuilder(Log log) {
        this.cc = new ClassCorrector(log);
        this.log = log;
    }

    public MemberCollectionBuilder(Log log, String builderName) {
        this(log);
        String builderName1 = builderName;
    }

    public void createMembers(ClassDescription cl, boolean addInherited, boolean fixClass, boolean checkHidding) throws ClassNotFoundException {
        ConstructorDescr[] constr;
        MemberCollection members = this.getMembers(cl, addInherited, checkHidding);
        SuperClass spr = cl.getSuperClass();
        if (spr != null) {
            members.addMember(spr);
        }
        for (ConstructorDescr constructorDescr : constr = cl.getDeclaredConstructors()) {
            members.addMember(constructorDescr);
        }
        cl.setMembers(members);
        Transformer t = PluginAPI.AFTER_BUILD_MEMBERS.getTransformer();
        if (t == null) {
            t = this.defaultTransformer;
        }
        t.transform(cl);
        if (fixClass) {
            t = PluginAPI.CLASS_CORRECTOR.getTransformer();
            if (t == null) {
                t = this.cc;
            }
            t.transform(cl);
        }
        if (this.mode == BuildMode.TESTABLE) {
            this.prepareMembersForAPICheck(cl);
        }
        if ((t = PluginAPI.AFTER_CLASS_CORRECTOR.getTransformer()) != null) {
            t.transform(cl);
        }
    }

    private void prepareMembersForAPICheck(ClassDescription cl) {
        MemberCollection cleaned = new MemberCollection();
        int memcount = 0;
        Iterator<MemberDescription> e = cl.getMembersIterator();
        while (e.hasNext()) {
            String dcn;
            String cn;
            ++memcount;
            MemberDescription mr = e.next();
            MemberType mt = mr.getMemberType();
            if (mt != MemberType.SUPERCLASS && (!this.isAccessible(mr.getDeclaringClassName()) || !mr.getDeclaringClassName().equals(cl.getQualifiedName()) && !this.isAncestor(cn = cl.getQualifiedName(), dcn = mr.getDeclaringClassName()))) continue;
            cleaned.addMember(mr);
        }
        if (cleaned.getAllMembers().size() != memcount) {
            cl.setMembers(cleaned);
        }
    }

    private boolean isAncestor(String clName, String superClName) {
        try {
            SuperInterface[] sis;
            ClassDescription c = this.secondCH.load(clName);
            SuperClass superCl = c.getSuperClass();
            if (superCl != null && superClName.equals(superCl.getQualifiedName())) {
                return true;
            }
            for (SuperInterface si1 : sis = c.getInterfaces()) {
                if (!superClName.equals(si1.getQualifiedName())) continue;
                return true;
            }
            if (superCl != null && this.isAncestor(superCl.getQualifiedName(), superClName)) {
                return true;
            }
            for (SuperInterface si : sis) {
                if (!this.isAncestor(si.getQualifiedName(), superClName)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return false;
    }

    private MemberCollection getMembers(ClassDescription cl, boolean addInherited, boolean checkHidding) throws ClassNotFoundException {
        return this.getMembers(cl, null, true, false, addInherited, checkHidding);
    }

    private MemberCollection getMembers(ClassDescription cl, String actualTypeParams, boolean skipRawTypes, boolean callErasurator, boolean addInherited, boolean checkHidding) throws ClassNotFoundException {
        assert (cl != null);
        this.erasurator.parseTypeParameters(cl);
        List<String> paramList = null;
        MemberCollection retVal = new MemberCollection();
        MemberDescription[] methods = cl.getDeclaredMethods();
        MemberDescription[] fields = cl.getDeclaredFields();
        MemberDescription[] classes = cl.getDeclaredClasses();
        MemberDescription[] intrfs = cl.getInterfaces();
        String clsName = cl.getQualifiedName();
        ClassHierarchy hierarchy = cl.getClassHierarchy();
        if (actualTypeParams != null) {
            paramList = Erasurator.splitParameters(actualTypeParams);
            methods = Erasurator.replaceFormalParameters(clsName, methods, paramList, skipRawTypes);
            fields = Erasurator.replaceFormalParameters(clsName, fields, paramList, skipRawTypes);
            classes = Erasurator.replaceFormalParameters(clsName, classes, paramList, skipRawTypes);
        } else if (callErasurator && cl.getTypeParameters() != null) {
            List<String> boundsList = cl.getTypeBounds();
            methods = Erasurator.replaceFormalParameters(clsName, methods, boundsList, false);
            fields = Erasurator.replaceFormalParameters(clsName, fields, boundsList, false);
            classes = Erasurator.replaceFormalParameters(clsName, classes, boundsList, false);
        }
        if (paramList != null) {
            intrfs = Erasurator.replaceFormalParameters(clsName, intrfs, paramList, skipRawTypes);
        }
        MethodOverridingChecker overridingChecker = new MethodOverridingChecker(this.erasurator);
        overridingChecker.addMethods(methods);
        retVal = this.addSuperMembers(methods, retVal);
        retVal = this.addSuperMembers(fields, retVal);
        retVal = this.addSuperMembers(classes, retVal);
        for (MemberDescription intrf : intrfs) {
            SuperInterface s = (SuperInterface)intrf;
            s.setDirect(true);
            s.setDeclaringClass(cl.getQualifiedName());
        }
        retVal = this.addSuperMembers(intrfs, retVal);
        if (addInherited) {
            this.addInherited(checkHidding, cl, hierarchy, paramList, skipRawTypes, overridingChecker, retVal);
        } else {
            this.fixAnnotations(cl, hierarchy);
        }
        return retVal;
    }

    private void addInherited(boolean checkHidding, ClassDescription cl, ClassHierarchy hierarchy, List<String> paramList, boolean skipRawTypes, MethodOverridingChecker overridingChecker, MemberCollection retVal) throws ClassNotFoundException {
        HashMap<String, MemberDescription> inheritedFields;
        Set<String> internalClasses;
        block9: {
            String clsName = cl.getQualifiedName();
            internalClasses = cl.getInternalClasses();
            inheritedFields = new HashMap<String, MemberDescription>();
            SuperClass superClassDescr = cl.getSuperClass();
            if (superClassDescr != null) {
                try {
                    ClassDescription superClass = hierarchy.load(superClassDescr.getQualifiedName());
                    MemberCollection superMembers = this.getMembers(superClass, superClassDescr.getTypeParameters(), false, true, true, checkHidding);
                    this.findInheritableAnnotations(cl, superClass);
                    superMembers = this.getAccessibleMembers(superMembers, cl, superClass);
                    Collection<MemberDescription> coll = superMembers.getAllMembers();
                    if (paramList != null) {
                        coll = Erasurator.replaceFormalParameters(clsName, coll, paramList, skipRawTypes);
                    }
                    for (MemberDescription supMD : coll) {
                        if (supMD.isMethod()) {
                            if (!this.addInheritedMethod(supMD, overridingChecker, retVal, hierarchy, superClass, cl)) continue;
                            continue;
                        }
                        if (supMD.isField()) {
                            supMD.unmark();
                            inheritedFields.put(supMD.getName(), supMD);
                            continue;
                        }
                        if (supMD.isSuperInterface()) {
                            SuperInterface si = (SuperInterface)supMD.clone();
                            si.setDirect(false);
                            retVal.addMember(si);
                            continue;
                        }
                        if (supMD.isInner()) {
                            if (internalClasses.contains(supMD.getName())) continue;
                            retVal.addMember(supMD);
                            continue;
                        }
                        retVal.addMember(supMD);
                    }
                }
                catch (ClassNotFoundException ex) {
                    if (this.mode == BuildMode.SIGFILE) break block9;
                    throw ex;
                }
            }
        }
        this.addInheritedFromInterfaces(cl, hierarchy, checkHidding, paramList, skipRawTypes, overridingChecker, retVal, inheritedFields, internalClasses);
    }

    private void addInheritedFromInterfaces(ClassDescription cl, ClassHierarchy hierarchy, boolean checkHidding, List<String> paramList, boolean skipRawTypes, MethodOverridingChecker overridingChecker, MemberCollection retVal, Map<String, MemberDescription> inheritedFields, Set<String> internalClasses) throws ClassNotFoundException {
        String clsName = cl.getQualifiedName();
        SuperInterface[] interfaces = cl.getInterfaces();
        HashSet<String> xfCan = new HashSet<String>();
        for (SuperInterface anInterface : interfaces) {
            try {
                ClassDescription intf = hierarchy.load(anInterface.getQualifiedName());
                MemberCollection h = this.getMembers(intf, anInterface.getTypeParameters(), false, true, true, checkHidding);
                Collection<MemberDescription> coll = h.getAllMembers();
                if (paramList != null) {
                    coll = Erasurator.replaceFormalParameters(clsName, coll, paramList, skipRawTypes);
                }
                for (MemberDescription membToAdd : coll) {
                    if (membToAdd.isMethod()) {
                        MemberDescription erased;
                        MethodDescr overriden;
                        MethodDescr m;
                        block21: {
                            m = (MethodDescr)membToAdd;
                            if (m.isStatic() || !m.isAbstract() && m.isPrivate()) continue;
                            overriden = overridingChecker.getOverridingMethod(m, true);
                            erased = this.erasurator.processMember(membToAdd);
                            if (overriden != null) {
                                if (this.mode == BuildMode.TESTABLE) {
                                    overriden = this.apiCheckCorrectIntMethod(overriden, hierarchy, retVal, membToAdd);
                                }
                                String membClass = membToAdd.getDeclaringClassName();
                                String overClass = overriden.getDeclaringClassName();
                                int membMods = membToAdd.getModifiers();
                                int overMods = overriden.getModifiers();
                                if (cl.isInterface() && !membClass.equals(overClass) && membMods != overMods) {
                                    try {
                                        if (hierarchy.getAllImplementedInterfaces(membClass).contains(overClass)) {
                                            if (retVal.contains(overriden)) {
                                                retVal.changeMember(overriden, membToAdd);
                                                retVal.updateMember(membToAdd);
                                                continue;
                                            }
                                            retVal.updateMember(membToAdd);
                                            continue;
                                        }
                                    }
                                    catch (ClassNotFoundException ex) {
                                        if (this.mode == BuildMode.SIGFILE) break block21;
                                        this.log.storeWarning(i18n.getString("MemberCollectionBuilder.warn.type.notresolved", ex.getCause()), null);
                                    }
                                }
                            }
                        }
                        if (overriden == null) {
                            retVal.addMember(m);
                            continue;
                        }
                        if (PrimitiveTypes.isPrimitive(m.getType()) || m.getType().endsWith("]")) continue;
                        try {
                            String newReturnType;
                            String existReturnType = overriden.getType();
                            if (existReturnType.equals(newReturnType = erased.getType()) || !cl.getClassHierarchy().getSuperClasses(newReturnType).contains(existReturnType) && !cl.getClassHierarchy().getAllImplementedInterfaces(newReturnType).contains(existReturnType)) continue;
                            retVal.updateMember(membToAdd);
                        }
                        catch (ClassNotFoundException e) {
                            this.log.storeWarning(i18n.getString("MemberCollectionBuilder.warn.returntype.notresolved", m.getType()), null);
                        }
                        continue;
                    }
                    if (membToAdd.isField()) {
                        MemberDescription storedFid = inheritedFields.get(membToAdd.getName());
                        if (storedFid != null) {
                            if (storedFid.getQualifiedName().equals(membToAdd.getQualifiedName())) continue;
                            storedFid.mark();
                            if (hierarchy.isClassVisibleOutside(membToAdd.getDeclaringClassName())) continue;
                            xfCan.add(membToAdd.getName());
                            continue;
                        }
                        membToAdd.unmark();
                        inheritedFields.put(membToAdd.getName(), membToAdd);
                        continue;
                    }
                    if (membToAdd.isSuperInterface()) {
                        SuperInterface si = (SuperInterface)membToAdd.clone();
                        si.setDirect(false);
                        retVal.addMember(si);
                        continue;
                    }
                    if (membToAdd.isInner()) {
                        if (!internalClasses.contains(membToAdd.getName()) && retVal.findSimilar(membToAdd) == null) {
                            retVal.addMember(membToAdd);
                            continue;
                        }
                        if (hierarchy.isClassVisibleOutside(membToAdd.getDeclaringClassName())) continue;
                        cl.addXClasses(membToAdd.getName());
                        continue;
                    }
                    retVal.addMember(membToAdd);
                }
            }
            catch (ClassNotFoundException ex) {
                if (this.mode == BuildMode.SIGFILE) continue;
                throw ex;
            }
        }
        this.postProcessInterfaceFields(cl, checkHidding, retVal, inheritedFields, xfCan);
    }

    private void postProcessInterfaceFields(ClassDescription cl, boolean checkHidding, MemberCollection retVal, Map<String, MemberDescription> inheritedFields, Set<String> xfCan) {
        Set<Object> internalFields = Collections.emptySet();
        Set<Object> xFields = Collections.emptySet();
        if (checkHidding) {
            internalFields = cl.getInternalFields();
            xFields = cl.getXFields();
        }
        for (MemberDescription field : inheritedFields.values()) {
            String fiName = field.getName();
            if (!(field.isMarked() || internalFields.contains(fiName) || xFields.contains(fiName))) {
                retVal.addMember(field);
                continue;
            }
            if (!xfCan.contains(field.getName())) continue;
            System.err.println("Phantom field found " + field.getQualifiedName());
            cl.addXFields(fiName);
        }
        if (!cl.getXClasses().isEmpty()) {
            for (String xClass : cl.getXClasses()) {
                Iterator<MemberDescription> rvi = retVal.iterator();
                while (rvi.hasNext()) {
                    MemberDescription rm = rvi.next();
                    if (!rm.isInner() || !rm.getName().equals(xClass)) continue;
                    System.err.println("Phantom class found " + rm.getQualifiedName());
                    rvi.remove();
                }
            }
        }
    }

    private boolean addInheritedMethod(MemberDescription supMD, MethodOverridingChecker overridingChecker, MemberCollection retVal, ClassHierarchy hierarchy, ClassDescription superClass, ClassDescription cl) {
        block6: {
            MethodDescr m = (MethodDescr)supMD;
            MethodDescr overriden = overridingChecker.getOverridingMethod(m, true);
            MemberDescription erased = this.erasurator.processMember(supMD);
            if (overriden == null) {
                retVal.addMember(m);
                return false;
            }
            if (!PrimitiveTypes.isPrimitive(m.getType()) && !m.getType().endsWith("]")) {
                try {
                    String newReturnType;
                    if (!hierarchy.isAccessible(superClass)) {
                        return true;
                    }
                    String existReturnType = overriden.getType();
                    if (!existReturnType.equals(newReturnType = erased.getType()) && (cl.getClassHierarchy().getSuperClasses(newReturnType).contains(existReturnType) || cl.getClassHierarchy().getAllImplementedInterfaces(newReturnType).contains(existReturnType))) {
                        retVal.updateMember(supMD);
                    }
                }
                catch (ClassNotFoundException e) {
                    if (this.mode == BuildMode.SIGFILE) break block6;
                    this.log.storeWarning(i18n.getString("MemberCollectionBuilder.warn.returntype.notresolved", m.getType()), null);
                }
            }
        }
        return false;
    }

    private void fixAnnotations(ClassDescription cl, ClassHierarchy hierarchy) throws ClassNotFoundException {
        block3: {
            SuperClass superClassDescr = cl.getSuperClass();
            if (superClassDescr != null) {
                try {
                    ClassDescription superClass = hierarchy.load(superClassDescr.getQualifiedName());
                    this.findInheritableAnnotations(cl, superClass);
                }
                catch (ClassNotFoundException ex) {
                    if (this.mode == BuildMode.SIGFILE) break block3;
                    throw ex;
                }
            }
        }
    }

    private MemberCollection addSuperMembers(MemberDescription[] from, MemberCollection to) {
        for (MemberDescription memberDescription : from) {
            to.addMember(memberDescription);
        }
        return to;
    }

    private MethodDescr apiCheckCorrectIntMethod(MethodDescr overriden, ClassHierarchy hierarchy, MemberCollection retVal, MemberDescription memb) {
        if (!this.isAccessible(overriden.getDeclaringClassName())) {
            boolean doFix = false;
            int mods = 0;
            try {
                mods = hierarchy.getClassModifiers(overriden.getDeclaringClassName());
            }
            catch (ClassNotFoundException ex) {
                doFix = true;
            }
            if (doFix && Modifier.hasModifier(mods, Modifier.PUBLIC) || Modifier.hasModifier(mods, Modifier.PROTECTED)) {
                retVal.changeMember(overriden, memb);
                overriden = null;
            }
        }
        return overriden;
    }

    private boolean isAccessible(String qualifiedName) {
        try {
            this.secondCH.load(qualifiedName);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    private MemberCollection getAccessibleMembers(MemberCollection members, ClassDescription subclass, ClassDescription superClass) {
        String pkg = subclass.getPackageName();
        boolean isSamePackage = pkg.equals(superClass.getPackageName());
        MemberCollection retVal = new MemberCollection();
        Iterator<MemberDescription> e = members.iterator();
        while (e.hasNext()) {
            MemberDescription mbr = e.next();
            if (!mbr.isPublic() && !mbr.isProtected() && !isSamePackage && !mbr.isSuperInterface() || mbr.isPrivate()) continue;
            retVal.addMember(mbr);
        }
        return retVal;
    }

    private void findInheritableAnnotations(ClassDescription subclass, ClassDescription superClass) {
        AnnotationItem[] superClassAnnoList = superClass.getAnnoList();
        if (superClassAnnoList.length != 0) {
            TreeSet<AnnotationItem> tmp = new TreeSet<AnnotationItem>();
            AnnotationItem[] subClassAnnoList = subclass.getAnnoList();
            for (AnnotationItem annotationItem1 : superClassAnnoList) {
                if (!annotationItem1.isInheritable()) continue;
                tmp.add(annotationItem1);
            }
            tmp.addAll(Arrays.asList(subClassAnnoList));
            if (tmp.size() != subClassAnnoList.length) {
                AnnotationItem[] newAnnoList = new AnnotationItem[tmp.size()];
                tmp.toArray(newAnnoList);
                subclass.setAnnoList(newAnnoList);
            }
        }
    }

    public void setBuildMode(BuildMode bm) {
        this.mode = bm;
    }

    public void setSecondClassHierarchy(ClassHierarchy signatureClassesHierarchy) {
        this.secondCH = signatureClassesHierarchy;
    }

    class DefaultAfterBuildMembersTransformer
    implements Transformer {
        DefaultAfterBuildMembersTransformer() {
        }

        @Override
        public ClassDescription transform(ClassDescription cls) {
            Iterator<MemberDescription> it = cls.getMembersIterator();
            while (it.hasNext()) {
                MemberDescription mr = it.next();
                boolean isSynthetic = mr.hasModifier(Modifier.ACC_SYNTHETIC);
                if (isSynthetic) {
                    it.remove();
                    continue;
                }
                if (mr.isPublic() || mr.isProtected() || mr.isSuperInterface() || mr.isSuperClass()) continue;
                it.remove();
            }
            return cls;
        }
    }

    public static class BuildMode {
        public static final BuildMode NORMAL = new BuildMode("NORMAL");
        public static final BuildMode SIGFILE = new BuildMode("SIGFILE");
        public static final BuildMode TESTABLE = new BuildMode("TESTABLE");
        private final String name;

        private BuildMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

