/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.modelingunit.update;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.SaveException;
import org.eclipse.mylyn.docs.intent.core.compiler.ModelElementChangeStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.ReferenceChangeStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.StructuralFeatureChangeStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerCompilationStatus;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.modelingunit.AbstractValue;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ContributionInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstructionReference;
import org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation;
import org.eclipse.mylyn.docs.intent.modelingunit.update.AbstractModelingUnitUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncStatusUpdater
extends AbstractModelingUnitUpdater {
    public SyncStatusUpdater(RepositoryAdapter repositoryAdapter) {
        super(repositoryAdapter);
    }

    private void initMatch(SynchronizerCompilationStatus status) {
        Resource compiledResource = this.repositoryAdapter.getResource(status.getCompiledResourceURI());
        Resource workingCopyResource = this.resourceSet.getResource(URI.createURI((String)status.getWorkingCopyResourceURI().replaceAll("\"", "")), true);
        this.includeMatch(compiledResource, workingCopyResource);
    }

    public void fixSynchronizationStatus(final SynchronizerCompilationStatus ... statusToFix) {
        this.repositoryAdapter.execute(new IntentCommand(){

            public void execute() {
                SynchronizerCompilationStatus[] synchronizerCompilationStatusArray = statusToFix;
                int n = statusToFix.length;
                int n2 = 0;
                while (n2 < n) {
                    SynchronizerCompilationStatus status = synchronizerCompilationStatusArray[n2];
                    SyncStatusUpdater.this.initMatch(status);
                    switch (status.eClass().getClassifierID()) {
                        case 19: {
                            SyncStatusUpdater.this.fixModelElementChange((ModelElementChangeStatus)status);
                            break;
                        }
                        case 21: 
                        case 22: {
                            SyncStatusUpdater.this.fixStructuralFeatureChange((StructuralFeatureChangeStatus)status);
                            break;
                        }
                    }
                    ++n2;
                }
                try {
                    SyncStatusUpdater.this.repositoryAdapter.save();
                }
                catch (ReadOnlyException e) {
                    IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, e.getMessage());
                }
                catch (SaveException e) {
                    IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, e.getMessage());
                }
            }
        });
    }

    private void fixModelElementChange(ModelElementChangeStatus status) {
        IntentGenericElement target = status.getTarget();
        switch (status.getChangeState().getValue()) {
            case 2: {
                IntentGenericElement container = SyncStatusUpdater.getContainer(target, 12, 5);
                if (container instanceof ContributionInstruction) {
                    ContributionInstruction contribution = (ContributionInstruction)container;
                    container = contribution.getContributionReference().getReferencedInstruction();
                }
                if (!(container instanceof InstanciationInstruction)) break;
                InstanciationInstruction instanciation = (InstanciationInstruction)container;
                EObject workingCopyObject = this.getWorkingCopyEObject(status.getWorkingCopyElementURIFragment());
                ArrayList<EObject> newObjects = new ArrayList<EObject>();
                TreeIterator iterator = workingCopyObject.eAllContents();
                while (iterator.hasNext()) {
                    newObjects.add((EObject)iterator.next());
                }
                this.setNewObjects(newObjects);
                StructuralFeatureAffectation affectation = this.generateSingleAffectation(workingCopyObject.eContainingFeature(), workingCopyObject);
                if (affectation == null) break;
                instanciation.getStructuralFeatures().add((Object)affectation);
                break;
            }
            case 3: {
                IntentGenericElement affectation = SyncStatusUpdater.getContainer(target, 6);
                if (affectation != null) {
                    this.removeFromContainer((EObject)affectation);
                    break;
                }
                if (!(target instanceof InstanciationInstruction)) break;
                InstanciationInstruction instanciation = (InstanciationInstruction)target;
                ModelingUnitInstructionReference reference = this.query.getModelingUnitInstructionReference(instanciation);
                if (reference != null) {
                    this.removeFromContainer((EObject)reference);
                }
                this.removeFromContainer((EObject)instanciation);
                break;
            }
            default: {
                IntentLogger.getInstance().log(IIntentLogger.LogType.INFO, "UNSUPPORTED MODEL ELEMENT CHANGE: " + status.getMessage() + '(' + status.getChangeState() + ')');
            }
        }
    }

    private void fixStructuralFeatureChange(StructuralFeatureChangeStatus status) {
        EObject element = this.getWorkingCopyEObject(status.getWorkingCopyElementURIFragment());
        EStructuralFeature feature = element.eClass().getEStructuralFeature(status.getFeatureName());
        Object newValue = null;
        if (status instanceof ReferenceChangeStatus) {
            newValue = this.getWorkingCopyEObject(((ReferenceChangeStatus)status).getWorkingCopyTargetURIFragment());
        }
        if (newValue == null) {
            newValue = element.eGet(feature);
        }
        switch (status.getChangeState().getValue()) {
            case 0: {
                if (status.getTarget() instanceof AbstractValue) {
                    if (newValue == null) {
                        IntentGenericElement affectation = SyncStatusUpdater.getContainer(status.getTarget(), 6);
                        if (!(affectation instanceof StructuralFeatureAffectation)) break;
                        this.removeFromContainer((EObject)((StructuralFeatureAffectation)affectation));
                        break;
                    }
                    this.setValue((AbstractValue)status.getTarget(), newValue);
                    break;
                }
                if (!(status.getTarget() instanceof InstanciationInstruction)) break;
                this.addAffectations(status.getTarget(), this.generateAffectations(feature, newValue));
                break;
            }
            case 3: {
                IntentGenericElement affectation = SyncStatusUpdater.getContainer(status.getTarget(), 6);
                if (!(affectation instanceof StructuralFeatureAffectation)) break;
                this.removeFromContainer((EObject)((StructuralFeatureAffectation)affectation));
                break;
            }
            case 2: {
                IntentGenericElement container = SyncStatusUpdater.getContainer(status.getTarget(), 12, 5);
                this.addAffectations(container, this.generateAffectations(feature, newValue));
                break;
            }
            default: {
                IntentLogger.getInstance().log(IIntentLogger.LogType.INFO, "UNSUPPORTED CHANGE: " + status.getMessage() + " (" + status.getChangeState() + ')');
            }
        }
    }

    private void addAffectations(IntentGenericElement container, List<StructuralFeatureAffectation> affectations) {
        if (container instanceof ContributionInstruction) {
            ContributionInstruction contribution = (ContributionInstruction)container;
            contribution.getContributions().addAll(affectations);
        } else if (container instanceof InstanciationInstruction) {
            InstanciationInstruction instanciation = (InstanciationInstruction)container;
            instanciation.getStructuralFeatures().addAll(affectations);
        }
    }
}

