/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.common.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.docs.intent.collab.common.internal.repository.contribution.IntentRepositoryManagerContributionRegistry;
import org.eclipse.mylyn.docs.intent.collab.common.repository.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.common.repository.contribution.IntentRepositoryManagerContribution;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;

public final class IntentRepositoryManagerImpl
implements IntentRepositoryManager {
    private Map<String, Repository> repositoriesByProject = new HashMap<String, Repository>();
    private boolean lock;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Repository getRepository(String identifier) throws RepositoryConnectionException, CoreException {
        Assert.isTrue((!this.lock ? 1 : 0) != 0);
        Repository repository = null;
        String normalizedIdentifier = this.normalizeIdentifier(identifier);
        this.lock = true;
        try {
            if (this.repositoriesByProject.get(normalizedIdentifier) != null) {
                repository = this.repositoriesByProject.get(normalizedIdentifier);
            }
            Iterator<IntentRepositoryManagerContribution> iterator = IntentRepositoryManagerContributionRegistry.getRepositoryManagerContributions().iterator();
            while (iterator.hasNext() && repository == null) {
                IntentRepositoryManagerContribution repositoryManagerContribution = iterator.next();
                if (!repositoryManagerContribution.canCreateRepository(normalizedIdentifier) || (repository = repositoryManagerContribution.createRepository(identifier)) == null) continue;
                this.repositoriesByProject.put(normalizedIdentifier, repository);
            }
        }
        finally {
            this.lock = false;
        }
        if (repository == null) {
            throw new RepositoryConnectionException("Could not find Intent Repository with id '" + identifier + "'");
        }
        return repository;
    }

    public synchronized boolean isManagedProject(String identifier) {
        String normalizedIdentifier = this.normalizeIdentifier(identifier);
        return this.repositoriesByProject.get(normalizedIdentifier) != null;
    }

    public synchronized void deleteRepository(String identifier) {
        String normalizedIdentifier = this.normalizeIdentifier(identifier);
        this.repositoriesByProject.remove(normalizedIdentifier);
    }

    public synchronized void register(String identifier, Repository repository) {
        String normalizedIdentifier = this.normalizeIdentifier(identifier);
        this.repositoriesByProject.put(normalizedIdentifier, repository);
    }

    private String normalizeIdentifier(String identifier) {
        for (IntentRepositoryManagerContribution repositoryManagerContribution : IntentRepositoryManagerContributionRegistry.getRepositoryManagerContributions()) {
            String normalizedIdentifier = repositoryManagerContribution.normalizeIdentifier(identifier);
            if (normalizedIdentifier.equals(identifier)) continue;
            return normalizedIdentifier;
        }
        return identifier;
    }
}

