/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.mylyn.docs.intent.client.ui.IntentEditorActivator;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentDocumentProvider;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorDocument;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorInput;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentPairMatcher;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.image.IntentImageAnnotationPainter;
import org.eclipse.mylyn.docs.intent.client.ui.editor.configuration.ColorManager;
import org.eclipse.mylyn.docs.intent.client.ui.editor.configuration.IntentEditorConfiguration;
import org.eclipse.mylyn.docs.intent.client.ui.editor.drop.IntentEditorDropSupport;
import org.eclipse.mylyn.docs.intent.client.ui.editor.outline.IntentOutlinePage;
import org.eclipse.mylyn.docs.intent.client.ui.editor.outline.IntentQuickOutlineControl;
import org.eclipse.mylyn.docs.intent.client.ui.editor.outline.QuickOutlineInformationProvider;
import org.eclipse.mylyn.docs.intent.client.ui.editor.renderers.IEditorRendererExtension;
import org.eclipse.mylyn.docs.intent.client.ui.editor.scanner.ModelingUnitDecorationPainter;
import org.eclipse.mylyn.docs.intent.client.ui.internal.renderers.IEditorRendererExtensionRegistry;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.client.ui.preferences.IntentPreferenceService;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnitInstructionReference;
import org.eclipse.mylyn.docs.intent.core.query.IntentHelper;
import org.eclipse.mylyn.docs.intent.serializer.ParsedElementPosition;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dnd.IDragAndDropService;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentEditorImpl
extends TextEditor
implements IntentEditor {
    private static final String EDITOR_CONTEXT = "org.eclipse.mylyn.docs.intent.client.ui.editor.context";
    private final ColorManager colorManager = new ColorManager();
    private IntentOutlinePage contentOutlinePage;
    private ISelectionChangedListener selectionChangedListener;
    private IntentQuickOutlineControl currentQuickOutline;
    private ProjectionSupport projectionSupport;
    private ProjectionAnnotationModel annotationModel;
    private IntentPairMatcher blockMatcher = new IntentPairMatcher();
    private IntentEditorConfiguration sourceViewerConfiguration;
    private boolean isInitialFoldingStructureComplete;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IntentEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IntentEditorInput");
        }
        super.init(site, input);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        this.sourceViewerConfiguration = new IntentEditorConfiguration(this, this.getPreferenceStore());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.sourceViewerConfiguration);
        this.setDocumentProvider((IDocumentProvider)new IntentDocumentProvider(this));
        super.doSetInput(input);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        viewer.doOperation(19);
        this.annotationModel = viewer.getProjectionAnnotationModel();
        viewer.addPainter((IPainter)new ModelingUnitDecorationPainter((ITextViewer)viewer, this.colorManager));
    }

    @Override
    public ProjectionViewer getProjectionViewer() {
        return (ProjectionViewer)this.getSourceViewer();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        int stylesToApply = styles;
        if (this.isTextWrapActivated()) {
            stylesToApply = styles | 0x40;
        }
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), stylesToApply);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        IntentImageAnnotationPainter imagePainter = new IntentImageAnnotationPainter(this, (ISourceViewer)viewer);
        viewer.addPainter((IPainter)imagePainter);
        viewer.addTextPresentationListener((ITextPresentationListener)imagePainter);
        return viewer;
    }

    @Override
    public void updateFoldingStructure(Map<Annotation, Position> addedAnnotations, List<Annotation> deletedAnnotations, Map<Annotation, Position> modifiedAnnotations) {
        Annotation[] deleted = new Annotation[deletedAnnotations.size() + modifiedAnnotations.size()];
        int i = 0;
        while (i < deletedAnnotations.size()) {
            deleted[i] = deletedAnnotations.get(i);
            ++i;
        }
        Iterator<Annotation> modifiedIterator = modifiedAnnotations.keySet().iterator();
        int i2 = deletedAnnotations.size();
        while (i2 < deleted.length) {
            deleted[i2] = modifiedIterator.next();
            ++i2;
        }
        addedAnnotations.putAll(modifiedAnnotations);
        if (this.annotationModel != null) {
            this.annotationModel.modifyAnnotations(deleted, addedAnnotations, null);
        }
        this.isInitialFoldingStructureComplete = true;
    }

    @Override
    public boolean isInitialFoldingStructureComplete() {
        return this.isInitialFoldingStructureComplete;
    }

    public void dispose() {
        ((IntentDocumentProvider)this.getDocumentProvider()).close();
        super.dispose();
        if (this.blockMatcher != null) {
            this.blockMatcher.dispose();
            this.blockMatcher = null;
        }
        this.colorManager.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IContentOutlinePage.class)) {
            return this.getOutlinePage();
        }
        return super.getAdapter(adapter);
    }

    private Object getOutlinePage() {
        if (this.contentOutlinePage == null) {
            this.contentOutlinePage = new IntentOutlinePage(this);
            this.selectionChangedListener = this.createSelectionChangeListener();
            this.contentOutlinePage.addSelectionChangedListener(this.selectionChangedListener);
        }
        return this.contentOutlinePage;
    }

    protected void selectionChangedDetected(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
        if (selectedElement instanceof ModelingUnitInstructionReference) {
            selectedElement = ((ModelingUnitInstructionReference)selectedElement).eContainer();
        }
        this.selectRange((IntentGenericElement)selectedElement);
    }

    protected ISelectionChangedListener createSelectionChangeListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IntentEditorImpl.this.selectionChangedDetected(event);
            }
        };
    }

    @Override
    public ColorManager getColorManager() {
        return this.colorManager;
    }

    @Override
    public IInformationPresenter createQuickOutlinePresenter() {
        InformationPresenter informationPresenter = new InformationPresenter(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new IntentQuickOutlineControl(parent, 16, IntentEditorImpl.this, true);
            }
        });
        informationPresenter.install((ITextViewer)this.getSourceViewer());
        QuickOutlineInformationProvider provider = new QuickOutlineInformationProvider(this);
        informationPresenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        informationPresenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        informationPresenter.setInformationProvider((IInformationProvider)provider, "__Intent__modelingunit");
        informationPresenter.setInformationProvider((IInformationProvider)provider, "__Intent__structuralcontent");
        informationPresenter.setSizeConstraints(50, 30, true, false);
        informationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        return informationPresenter;
    }

    @Override
    public IntentQuickOutlineControl getCurrentQuickOutline() {
        return this.currentQuickOutline;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{EDITOR_CONTEXT});
    }

    @Override
    public EObject getIntentContent() {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        if (document instanceof IntentEditorDocument) {
            return (EObject)((IntentEditorDocument)document).getAST();
        }
        return null;
    }

    @Override
    public boolean selectRange(IntentGenericElement element) {
        ParsedElementPosition position = null;
        int begin = 0;
        int length = 0;
        position = ((IntentEditorDocument)this.getDocumentProvider().getDocument((Object)this.getEditorInput())).getIntentPosition((EObject)element);
        if (element != null) {
            IntentGenericElement container = element;
            while (position == null && container != null) {
                length = -1;
                position = ((IntentEditorDocument)this.getDocumentProvider().getDocument((Object)this.getEditorInput())).getIntentPosition((EObject)container);
                container = container.eContainer();
            }
            if (position != null) {
                begin = position.getOffset();
                length = length != -1 ? position.getLength() : 1;
            }
            if (begin > -1 && length >= 0) {
                ISourceViewer viewer = this.getSourceViewer();
                StyledText widget = viewer.getTextWidget();
                widget.setRedraw(false);
                this.setHighlightRange(begin, length, true);
                this.selectAndReveal(begin, length);
                widget.setRedraw(true);
                return true;
            }
        }
        return false;
    }

    @Override
    public void refreshOutlineView(EObject newAST) {
        ((IntentOutlinePage)((Object)this.getOutlinePage())).refresh(newAST);
    }

    @Override
    public boolean containsElement(IntentGenericElement elementToOpen) {
        boolean containsElement = IntentHelper.containsElement((IntentGenericElement)((IntentGenericElement)this.getIntentContent()), (IntentGenericElement)elementToOpen);
        return containsElement;
    }

    @Override
    public void refreshTitle(EObject newAST) {
        String titleFromElement = ((IntentEditorInput)this.getEditorInput()).getTitleFromElement(((IntentDocumentProvider)this.getDocumentProvider()).getListenedElementsHandler().getRepositoryAdapter(), newAST);
        this.setPartName(titleFromElement);
    }

    @Override
    public IntentPairMatcher getBlockMatcher() {
        return this.blockMatcher;
    }

    @Override
    public SourceViewerConfiguration getViewerConfiguration() {
        return this.sourceViewerConfiguration;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.blockMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("org.eclipse.mylyn.docs.intent.client.ui.preferences.matching_brackets", "org.eclipse.mylyn.docs.intent.client.ui.preferences.matching_brackets_color");
        IPreferenceStore pref = IntentEditorActivator.getDefault().getPreferenceStore();
        IPreferenceStore[] stores = new IPreferenceStore[]{this.getPreferenceStore(), pref};
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(stores));
        support.install(this.getPreferenceStore());
        super.configureSourceViewerDecorationSupport(support);
    }

    protected void initializeDragAndDrop(ISourceViewer viewer) {
        StyledText text = viewer.getTextWidget();
        int operations = 19;
        ArrayList supportedTransfers = Lists.newArrayList();
        supportedTransfers.add(LocalTransfer.getInstance());
        for (IEditorRendererExtension editorRendererExtension : IEditorRendererExtensionRegistry.getEditorRendererExtensions()) {
            if (editorRendererExtension.getAdditionalTransfers() != null) {
                supportedTransfers.addAll(editorRendererExtension.getAdditionalTransfers());
                continue;
            }
            String errorMessage = "An error occured during Intent Editor's Drag and drop initialization ";
            errorMessage = String.valueOf(errorMessage) + "extension " + editorRendererExtension + " provides an invalid value for additional transfers";
            IntentUiLogger.logError(errorMessage, new IllegalArgumentException());
        }
        IDragAndDropService service = (IDragAndDropService)this.getSite().getService(IDragAndDropService.class);
        service.addMergedDropTarget((Control)text, operations, supportedTransfers.toArray(new Transfer[supportedTransfers.size()]), (DropTargetListener)new IntentEditorDropSupport(this));
    }

    private boolean isTextWrapActivated() {
        return IntentPreferenceService.getBoolean("org.eclipse.mylyn.docs.intent.client.ui.preferences.text_wrap");
    }
}

