/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.compare.ui.editor.ModelCompareEditorInput;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorDocument;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.AbstractIntentFix;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.IntentCompareConfiguration;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerCompilationStatus;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;

public class EMFCompareFix
extends AbstractIntentFix {
    private static final String COMPARE_EDITOR_TITLE = "Comparing Intent Document and Working Copy";

    public EMFCompareFix(Annotation annotation) {
        super(annotation);
    }

    protected void applyFix(RepositoryAdapter repositoryAdapter, IntentEditorDocument document) {
        String workingCopyResourceURI = ((SynchronizerCompilationStatus)this.syncAnnotation.getCompilationStatus()).getWorkingCopyResourceURI().replace("\"", "");
        String generatedResourceURI = ((SynchronizerCompilationStatus)this.syncAnnotation.getCompilationStatus()).getCompiledResourceURI().replace("\"", "");
        Resource generatedResource = repositoryAdapter.getResource(generatedResourceURI);
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource workingCopyResource = rs.getResource(URI.createURI((String)workingCopyResourceURI), true);
        try {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("match.ignore.xmi.id", Boolean.TRUE);
            MatchModel match = MatchService.doResourceMatch((Resource)generatedResource, (Resource)workingCopyResource, options);
            DiffModel diff = DiffService.doDiff((MatchModel)match, (boolean)false);
            ComparisonResourceSnapshot snapshot = DiffFactory.eINSTANCE.createComparisonResourceSnapshot();
            snapshot.setDiff(diff);
            snapshot.setMatch(match);
            IntentCompareConfiguration compareConfig = new IntentCompareConfiguration(generatedResource, workingCopyResource);
            IntentCompareEditorInput input = new IntentCompareEditorInput((ComparisonSnapshot)snapshot, compareConfig);
            compareConfig.setContainer((ICompareContainer)input);
            input.setTitle("Comparing Intent Document and Working Copy (" + workingCopyResourceURI + ")");
            CompareUI.openCompareDialog((CompareEditorInput)input);
        }
        catch (InterruptedException interruptedException) {}
    }

    public String getDisplayString() {
        return "See differences in Compare Editor";
    }

    private class IntentCompareEditorInput
    extends ModelCompareEditorInput {
        private CompareConfiguration compareConfig;
        private ListenerList listenerList;
        private boolean isDirty;

        public IntentCompareEditorInput(ComparisonSnapshot snapshot, CompareConfiguration compareConfig) {
            super(snapshot);
            this.listenerList = new ListenerList();
            this.compareConfig = compareConfig;
        }

        public CompareConfiguration getCompareConfiguration() {
            return this.compareConfig;
        }

        public IWorkbenchPart getWorkbenchPart() {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }

        public IServiceLocator getServiceLocator() {
            return new IServiceLocator(){

                public boolean hasService(Class api) {
                    return api.equals(IHandlerService.class);
                }

                public Object getService(Class api) {
                    if (api.equals(IHandlerService.class)) {
                        return new IntentCompareHandlerService();
                    }
                    return null;
                }
            };
        }

        public void addPropertyChangeListener(IPropertyChangeListener listener) {
            if (listener != null) {
                this.listenerList.add((Object)listener);
            }
            super.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(IPropertyChangeListener listener) {
            if (this.listenerList != null) {
                this.listenerList.remove((Object)listener);
            }
            super.removePropertyChangeListener(listener);
        }

        public void setDirty(boolean dirty) {
            boolean oldDirty = this.isDirty;
            this.isDirty = dirty;
            if (oldDirty != this.isDirty) {
                Utilities.firePropertyChange((ListenerList)this.listenerList, (Object)((Object)this), (String)"DIRTY_STATE", (Object)oldDirty, (Object)this.isSaveNeeded());
            }
        }

        public boolean isDirty() {
            return this.isDirty;
        }
    }

    private class IntentCompareHandlerService
    implements IHandlerService {
        private IntentCompareHandlerService() {
        }

        public void dispose() {
        }

        public void removeSourceProvider(ISourceProvider provider) {
        }

        public void addSourceProvider(ISourceProvider provider) {
        }

        public void setHelpContextId(IHandler handler, String helpContextId) {
        }

        public void readRegistry() {
        }

        public IEvaluationContext getCurrentState() {
            return null;
        }

        public Object executeCommandInContext(ParameterizedCommand command, Event event, IEvaluationContext context) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
            return null;
        }

        public Object executeCommand(ParameterizedCommand command, Event event) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
            return null;
        }

        public Object executeCommand(String commandId, Event event) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
            return null;
        }

        public void deactivateHandlers(Collection activations) {
        }

        public void deactivateHandler(IHandlerActivation activation) {
        }

        public ExecutionEvent createExecutionEvent(ParameterizedCommand command, Event event) {
            return null;
        }

        public ExecutionEvent createExecutionEvent(Command command, Event event) {
            return null;
        }

        public IEvaluationContext createContextSnapshot(boolean includeSelection) {
            return null;
        }

        public IHandlerActivation activateHandler(String commandId, IHandler handler, Expression expression, int sourcePriorities) {
            return null;
        }

        public IHandlerActivation activateHandler(String commandId, IHandler handler, Expression expression, boolean global) {
            return null;
        }

        public IHandlerActivation activateHandler(String commandId, IHandler handler, Expression expression) {
            return null;
        }

        public IHandlerActivation activateHandler(String commandId, IHandler handler) {
            return null;
        }

        public IHandlerActivation activateHandler(IHandlerActivation activation) {
            return null;
        }
    }
}

