/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.core.query;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.core.document.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.document.descriptionunit.DescriptionBloc;
import org.eclipse.mylyn.docs.intent.core.document.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;
import org.eclipse.mylyn.docs.intent.markup.markup.Paragraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntentHelper {
    private IntentHelper() {
    }

    public static boolean canBeOpenedByIntentEditor(Object element) {
        return element instanceof IntentStructuredElement;
    }

    public static EList<CompilationStatus> getAllStatus(IntentGenericElement element) {
        BasicEList allCompilationStatus = new BasicEList();
        allCompilationStatus.addAll(element.getCompilationStatus());
        for (EObject object : element.eContents()) {
            if (!(object instanceof IntentGenericElement)) continue;
            allCompilationStatus.addAll(IntentHelper.getAllStatus((IntentGenericElement)object));
        }
        return allCompilationStatus;
    }

    public static boolean containsElement(IntentGenericElement root, IntentGenericElement searchedElement) {
        boolean containsElement;
        boolean bl = containsElement = root == searchedElement;
        if (!containsElement && root != null) {
            Iterator containedElementsIterator = root.eContents().iterator();
            while (!containsElement && containedElementsIterator.hasNext()) {
                EObject containedElement = (EObject)containedElementsIterator.next();
                if (!(containedElement instanceof IntentGenericElement)) continue;
                containsElement = IntentHelper.containsElement((IntentGenericElement)containedElement, searchedElement);
            }
        }
        return containsElement;
    }

    public static <T> Collection<T> getAllContainedElements(Class<T> clazz, IntentGenericElement root) {
        LinkedHashSet containedElements = Sets.newLinkedHashSet();
        if (root instanceof IntentSection) {
            for (IntentSection section : ((IntentSection)root).getSubSections()) {
                containedElements.addAll(IntentHelper.getAllContainedElements(clazz, section));
            }
            for (DescriptionUnit descriptionUnit : ((IntentSection)root).getDescriptionUnits()) {
                containedElements.addAll(IntentHelper.getAllContainedElements(clazz, descriptionUnit));
            }
            for (ModelingUnit unit : ((IntentSection)root).getModelingUnits()) {
                containedElements.addAll(IntentHelper.getAllContainedElements(clazz, unit));
            }
        }
        if (root instanceof ModelingUnit) {
            containedElements.addAll(Sets.newLinkedHashSet((Iterable)Iterables.filter(((ModelingUnit)root).getInstructions(), clazz)));
        }
        if (root instanceof DescriptionUnit) {
            for (UnitInstruction bloc : ((DescriptionUnit)root).getInstructions()) {
                if (!(bloc instanceof DescriptionBloc)) continue;
                for (Paragraph paragraph : Iterables.filter((Iterable)((DescriptionBloc)bloc).getDescriptionBloc().getContent(), Paragraph.class)) {
                    containedElements.addAll(Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)paragraph.getContent(), clazz)));
                }
            }
        }
        return containedElements;
    }

    public static Object getAllImageLinks(IntentGenericElement documentRoot) {
        return null;
    }
}

