/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.exporter.services;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndex;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndexEntry;
import org.eclipse.mylyn.docs.intent.exporter.services.IntentAcceleoServices;
import org.eclipse.mylyn.docs.intent.markup.gen.services.ImageServices;

public class CopyImageUtils {
    private static AdapterFactoryItemDelegator itemDelegator;
    private static ResourceSetImpl resourceSet;

    public static String copyImageAndGetImageID(EObject any, RepositoryAdapter repositoryAdapter, File outputFolder) {
        String qualifiedImageID = "";
        Object imageURL = CopyImageUtils.getImageURL(any);
        if (imageURL instanceof URL) {
            try {
                URL resolvedURL = FileLocator.resolve((URL)((URL)imageURL));
                Object classifier = null;
                classifier = any instanceof EClassifier ? (EClassifier)any : any.eClass();
                if (resolvedURL.toString().contains("org.eclipse.emf.edit") && resolvedURL.toString().endsWith("/icons/full/obj16/Item.gif") && (imageURL = CopyImageUtils.getImageFromWorkspace(classifier, repositoryAdapter)) != null) {
                    resolvedURL = (URL)imageURL;
                }
                if (resolvedURL != null) {
                    qualifiedImageID = CopyImageUtils.copyImageIfNeeded(classifier, outputFolder, resolvedURL, resolvedURL.openStream());
                }
            }
            catch (IOException e) {
                IntentUiLogger.logError((Throwable)e);
            }
        }
        return qualifiedImageID;
    }

    private static URL getImageFromWorkspace(EClassifier any, RepositoryAdapter repositoryAdapter) {
        TraceabilityIndex projectTraceabilityIndex;
        if (EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE && (projectTraceabilityIndex = IntentAcceleoServices.getTraceabilityIndex(repositoryAdapter)) != null) {
            for (TraceabilityIndexEntry entry : projectTraceabilityIndex.getEntries()) {
                URI metamodelURI;
                if (!any.eResource().getURI().toString().contains(entry.getGeneratedResourcePath()) || (metamodelURI = entry.getResourceDeclaration().getUri()) == null || !metamodelURI.toString().replace("\"", "").endsWith("ecore")) continue;
                URI genModelURI = URI.createURI((String)metamodelURI.toString().replace("\"", "").replace("ecore", "genmodel"));
                try {
                    Resource resource = CopyImageUtils.getResourceSet().getResource(genModelURI, true);
                    if (resource.getContents().isEmpty() || !(resource.getContents().iterator().next() instanceof GenModel)) continue;
                    String editIconsDirectory = ((GenModel)resource.getContents().iterator().next()).getEditIconsDirectory();
                    IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(String.valueOf(editIconsDirectory) + "/full/obj16"));
                    if (!folder.exists()) continue;
                    String[] stringArray = new String[]{"gif", "png"};
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String imageExtension = stringArray[n2];
                        if (folder.getFile(String.valueOf(any.getName()) + "." + imageExtension).exists()) {
                            return new URL("file:/" + folder.getFile(String.valueOf(any.getName()) + "." + imageExtension).getLocation().toString());
                        }
                        ++n2;
                    }
                }
                catch (RuntimeException runtimeException) {
                    IntentUiLogger.logInfo((String)("Cannot find genmodel at " + genModelURI + ". Default image will be use to display " + any.getName()));
                }
                catch (MalformedURLException e) {
                    IntentUiLogger.logError((Throwable)e);
                }
            }
        }
        return null;
    }

    private static Object getImageURL(EObject any) {
        Object imageURL = null;
        if (any instanceof EClass && ((EClassifier)any).getEPackage() != null) {
            EObject instance = ((EClassifier)any).getEPackage().getEFactoryInstance().create((EClass)any);
            imageURL = CopyImageUtils.getItemDelegator(any).getImage((Object)instance);
        } else {
            imageURL = CopyImageUtils.getItemDelegator(any).getImage((Object)any);
        }
        if (!(imageURL instanceof URL)) {
            if (imageURL instanceof URI) {
                try {
                    imageURL = new URL(imageURL.toString());
                }
                catch (MalformedURLException malformedURLException) {}
            } else if (imageURL instanceof ComposedImage) {
                imageURL = ((ComposedImage)imageURL).getImages().iterator().next();
            }
        }
        return imageURL;
    }

    private static String copyImageIfNeeded(EClassifier classifier, File outputFolder, URL imageURL, InputStream sourceStream) throws IOException {
        String packageName = "";
        if (classifier.getEPackage() != null) {
            packageName = classifier.getEPackage().getName();
        }
        File targetFile = new File(String.valueOf(outputFolder.getAbsolutePath()) + "/icons/generated/" + packageName + imageURL.getFile().substring(imageURL.getFile().lastIndexOf(47)));
        new File(String.valueOf(outputFolder.getAbsolutePath()) + "/icons/generated/" + packageName).mkdirs();
        if (!targetFile.exists()) {
            ImageServices.copyFile((InputStream)sourceStream, (File)targetFile);
        }
        String copiedImagePath = targetFile.getAbsolutePath().toString();
        String outputFolderPath = outputFolder.getAbsolutePath();
        return "../" + copiedImagePath.substring(outputFolderPath.length());
    }

    private static AdapterFactoryItemDelegator getItemDelegator(EObject any) {
        if (itemDelegator == null) {
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
            adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
            itemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)adapterFactory);
        }
        return itemDelegator;
    }

    private static ResourceSet getResourceSet() {
        if (resourceSet == null) {
            resourceSet = new ResourceSetImpl();
        }
        return resourceSet;
    }

    public static void dispose() {
        if (itemDelegator != null) {
            ((ComposedAdapterFactory)itemDelegator.getAdapterFactory()).dispose();
        }
        resourceSet = null;
        itemDelegator = null;
    }
}

