/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.bridge.java;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ClassifierKind implements Enumerator
{
    CLASS(0, "CLASS", "CLASS"),
    INTERFACE(1, "INTERFACE", "INTERFACE"),
    ENUM(2, "ENUM", "ENUM");

    public static final int CLASS_VALUE = 0;
    public static final int INTERFACE_VALUE = 1;
    public static final int ENUM_VALUE = 2;
    private static final ClassifierKind[] VALUES_ARRAY;
    public static final List<ClassifierKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ClassifierKind[]{CLASS, INTERFACE, ENUM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ClassifierKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClassifierKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ClassifierKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ClassifierKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ClassifierKind get(int value) {
        switch (value) {
            case 0: {
                return CLASS;
            }
            case 1: {
                return INTERFACE;
            }
            case 2: {
                return ENUM;
            }
        }
        return null;
    }

    private ClassifierKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

