/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.linkresolver.repository;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.docs.intent.client.linkresolver.resolver.LinkResolver;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.IntentCommand;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.SaveException;

public class LinkResolverJob
extends Job {
    private static final String LINK_RESOLVER_JOB_NAME = "Resolving references inside Intent Document";
    private RepositoryAdapter repositoryAdapter;
    private LinkResolver linkResolver;

    public LinkResolverJob(RepositoryAdapter repositoryAdapter) {
        super(LINK_RESOLVER_JOB_NAME);
        this.repositoryAdapter = repositoryAdapter;
        this.linkResolver = new LinkResolver(repositoryAdapter);
    }

    protected IStatus run(final IProgressMonitor monitor) {
        this.repositoryAdapter.execute(new IntentCommand(){

            public void execute() {
                try {
                    LinkResolverJob.this.repositoryAdapter.openSaveContext();
                    LinkResolverJob.this.linkResolver.resolve(monitor);
                    LinkResolverJob.this.repositoryAdapter.setSendSessionWarningBeforeSaving((Collection)Lists.newArrayList((Object[])new String[]{"/INTENT/"}));
                    LinkResolverJob.this.repositoryAdapter.save();
                }
                catch (ReadOnlyException readOnlyException) {
                    IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, "Failed to resolve links inside the Intent Document: insufficiant rights");
                }
                catch (SaveException e) {
                    IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, "Failed to resolve links inside the Intent Document:" + e.getMessage());
                }
            }
        });
        return Status.OK_STATUS;
    }
}

