/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.synchronizer.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mylyn.docs.intent.client.synchronizer.factory.SynchronizerMessageProvider;
import org.eclipse.mylyn.docs.intent.core.compiler.AttributeChangeStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationMessageType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusSeverity;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilerFactory;
import org.eclipse.mylyn.docs.intent.core.compiler.InstructionTraceabilityEntry;
import org.eclipse.mylyn.docs.intent.core.compiler.ReferenceChangeStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerChangeState;
import org.eclipse.mylyn.docs.intent.core.compiler.TraceabilityIndexEntry;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.NativeValueForStructuralFeature;
import org.eclipse.mylyn.docs.intent.core.modelingunit.NewObjectValueForStructuralFeature;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ReferenceValueForStructuralFeature;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ValueForStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SynchronizerStatusFactory {
    private SynchronizerStatusFactory() {
    }

    public static List<CompilationStatus> createStatusFromDiff(TraceabilityIndexEntry indexEntry, Diff difference) {
        ArrayList<CompilationStatus> statusList = new ArrayList<CompilationStatus>();
        AttributeChangeStatus status = null;
        if (difference.getMatch().getLeft() != null) {
            if (difference instanceof AttributeChange) {
                status = SynchronizerStatusFactory.createStatusFromAttributeChange(indexEntry, (AttributeChange)difference);
            } else if (difference instanceof ReferenceChange) {
                status = SynchronizerStatusFactory.createStatusFromReferenceChange(indexEntry, (ReferenceChange)difference);
            }
            if (status != null) {
                if (difference.getKind().equals((Object)DifferenceKind.MOVE)) {
                    status.setSeverity(CompilationStatusSeverity.INFO);
                } else {
                    status.setSeverity(CompilationStatusSeverity.WARNING);
                }
                status.setType(CompilationMessageType.SYNCHRONIZER_WARNING);
                status.setMessage(SynchronizerMessageProvider.createMessageFromDiff(difference));
                status.setWorkingCopyResourceURI(indexEntry.getResourceDeclaration().getUri().toString());
                status.setCompiledResourceURI(indexEntry.getGeneratedResourcePath());
                statusList.add((CompilationStatus)status);
            }
        }
        return statusList;
    }

    private static ReferenceChangeStatus createStatusFromReferenceChange(TraceabilityIndexEntry indexEntry, ReferenceChange difference) {
        EObject content;
        EObject compiledElement = difference.getMatch().getLeft();
        IntentGenericElement target = null;
        ReferenceChangeStatus status = CompilerFactory.eINSTANCE.createReferenceChangeStatus();
        status.setCompiledElement(compiledElement);
        status.setFeatureName(difference.getReference().getName());
        status.setWorkingCopyElementURIFragment(SynchronizerStatusFactory.createURIFragment(difference.getMatch().getRight()));
        status.setChangeState(SynchronizerStatusFactory.convertDifferenceKindToState(difference.getKind()));
        target = SynchronizerStatusFactory.getInstructionFromAffectation(indexEntry, compiledElement, (EStructuralFeature)difference.getReference(), difference.getValue());
        if (target instanceof NewObjectValueForStructuralFeature && !target.eContents().isEmpty() && (content = (EObject)target.eContents().get(0)) instanceof InstanciationInstruction) {
            target = (InstanciationInstruction)content;
        }
        if (status != null) {
            if (target == null && compiledElement != null) {
                target = SynchronizerStatusFactory.getInstructionFromCompiledElement(indexEntry, compiledElement);
            }
            status.setTarget(target);
        }
        return status;
    }

    private static AttributeChangeStatus createStatusFromAttributeChange(TraceabilityIndexEntry indexEntry, AttributeChange difference) {
        EObject compiledElement = difference.getMatch().getLeft();
        IntentGenericElement target = null;
        AttributeChangeStatus status = CompilerFactory.eINSTANCE.createAttributeChangeStatus();
        status.setCompiledElement(compiledElement);
        status.setFeatureName(difference.getAttribute().getName());
        status.setWorkingCopyElementURIFragment(SynchronizerStatusFactory.createURIFragment(difference.getMatch().getRight()));
        status.setChangeState(SynchronizerStatusFactory.convertDifferenceKindToState(difference.getKind()));
        target = SynchronizerStatusFactory.getInstructionFromAffectation(indexEntry, compiledElement, (EStructuralFeature)difference.getAttribute(), difference.getValue());
        if (status != null) {
            if (target == null && compiledElement != null) {
                target = SynchronizerStatusFactory.getInstructionFromCompiledElement(indexEntry, compiledElement);
            }
            status.setTarget(target);
        }
        return status;
    }

    private static IntentGenericElement getInstructionFromCompiledElement(TraceabilityIndexEntry indexEntry, EObject compiledElement) {
        EList instructionEntries = (EList)indexEntry.getContainedElementToInstructions().get((Object)compiledElement);
        if (instructionEntries != null) {
            for (InstructionTraceabilityEntry entry : instructionEntries) {
                IntentGenericElement instruction = entry.getInstruction();
                if (!(instruction instanceof InstanciationInstruction)) continue;
                return instruction;
            }
        }
        return null;
    }

    private static IntentGenericElement getInstructionFromAffectation(TraceabilityIndexEntry indexEntry, EObject compiledElement, EStructuralFeature feature, Object diffValue) {
        EList instructionEntries = (EList)indexEntry.getContainedElementToInstructions().get((Object)compiledElement);
        if (instructionEntries != null) {
            for (InstructionTraceabilityEntry entry : instructionEntries) {
                EList values = (EList)entry.getFeatures().get((Object)feature.getName());
                if (values == null) continue;
                for (ValueForStructuralFeature value : values) {
                    boolean isRefValueEquals;
                    Object compiledValue = SynchronizerStatusFactory.getCompiledValue(indexEntry, value);
                    boolean isNativeValueEquals = value instanceof NativeValueForStructuralFeature && diffValue != null && diffValue.toString().equals(compiledValue);
                    boolean isRefValue = value instanceof ReferenceValueForStructuralFeature || value instanceof NewObjectValueForStructuralFeature;
                    boolean refValueEquals = diffValue == null && compiledValue == null || diffValue != null && diffValue.equals(compiledValue);
                    boolean bl = isRefValueEquals = isRefValue && refValueEquals;
                    if (!isNativeValueEquals && !isRefValueEquals) continue;
                    return value;
                }
            }
        }
        return null;
    }

    private static Object getCompiledValue(TraceabilityIndexEntry indexEntry, ValueForStructuralFeature value) {
        String res = null;
        switch (value.eClass().getClassifierID()) {
            case 15: {
                res = ((NativeValueForStructuralFeature)value).getValue().replaceAll("\"", "");
                break;
            }
            case 17: {
                InstanciationInstruction referencedInstanciation = ((ReferenceValueForStructuralFeature)value).getInstanciationReference().getInstanciation();
                if (referencedInstanciation != null) {
                    res = SynchronizerStatusFactory.getCompiledElement(indexEntry, referencedInstanciation);
                    break;
                }
                res = ((ReferenceValueForStructuralFeature)value).getReferencedMetaType();
                break;
            }
            case 16: {
                InstanciationInstruction instanciation = ((NewObjectValueForStructuralFeature)value).getValue();
                if (instanciation == null) break;
                res = SynchronizerStatusFactory.getCompiledElement(indexEntry, instanciation);
                break;
            }
        }
        return res;
    }

    private static EObject getCompiledElement(TraceabilityIndexEntry indexEntry, InstanciationInstruction instantiation) {
        for (Map.Entry entry : indexEntry.getContainedElementToInstructions().entrySet()) {
            for (InstructionTraceabilityEntry instructionEntry : (EList)entry.getValue()) {
                IntentGenericElement instruction = instructionEntry.getInstruction();
                if (!(instruction instanceof InstanciationInstruction) || !instantiation.equals(instruction)) continue;
                return (EObject)entry.getKey();
            }
        }
        return null;
    }

    private static SynchronizerChangeState convertDifferenceKindToState(DifferenceKind differenceKind) {
        SynchronizerChangeState state = null;
        switch (differenceKind.getValue()) {
            case 0: {
                state = SynchronizerChangeState.COMPILED_TARGET;
                break;
            }
            case 3: {
                state = SynchronizerChangeState.ORDER;
                break;
            }
            case 1: {
                state = SynchronizerChangeState.WORKING_COPY_TARGET;
                break;
            }
            case 2: {
                state = SynchronizerChangeState.UPDATE;
                break;
            }
        }
        return state;
    }

    private static String createURIFragment(EObject eo) {
        if (eo != null) {
            return EcoreUtil.getURI((EObject)eo).toString();
        }
        return null;
    }
}

