/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.outline;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.docs.intent.client.ui.IntentEditorActivator;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentDocumentProvider;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.outline.IntentOutlineInformationHolder;
import org.eclipse.mylyn.docs.intent.client.ui.editor.outline.IntentOutlinePageItemProviderAdapterFactory;
import org.eclipse.mylyn.docs.intent.client.ui.editor.outline.IntentOutlinePageLabelProvider;
import org.eclipse.mylyn.docs.intent.client.ui.editor.outline.OutlineContentProvider;
import org.eclipse.mylyn.docs.intent.client.ui.editor.outline.QuickOutlinePatternFilter;
import org.eclipse.mylyn.docs.intent.collab.common.query.IndexQuery;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndex;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndexEntry;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class IntentQuickOutlineControl
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener {
    private static final String KEY_SEQUENCE_FOR_TOGGLING = "M1+O";
    protected final IntentEditor editor;
    private AdapterFactory adapterFactory;
    private FilteredTree filteredTree;
    private TreeViewer treeViewer;
    private EObject editorScopedOutlineRoot;
    private EObject wholeScopedOutlineRoot;
    private boolean considerOnlyLocalASTElements;
    private KeyAdapter togglingKeyAdapter;

    public IntentQuickOutlineControl(Shell parentShell, int shellStyle, IntentEditor intentEditor, boolean considerOnlyLocalASTElements) {
        super(parentShell, shellStyle, true, true, false, false, false, null, null);
        this.editor = intentEditor;
        this.considerOnlyLocalASTElements = considerOnlyLocalASTElements;
        this.editorScopedOutlineRoot = this.editor.getIntentContent();
        if (!(this.editorScopedOutlineRoot instanceof IntentDocument)) {
            this.setInfoText("Press 'Ctrl+O' to search in the whole document");
        } else {
            System.err.println(this.editorScopedOutlineRoot + "/" + this.wholeScopedOutlineRoot);
            this.setInfoText("Searching in the whole document");
        }
        this.create();
    }

    private EObject getQuickOutlineRoot() {
        if (this.considerOnlyLocalASTElements) {
            if (this.editorScopedOutlineRoot != this.wholeScopedOutlineRoot) {
                this.setInfoText("Press 'Ctrl+O' to search in the whole document scope");
            }
            return this.editorScopedOutlineRoot;
        }
        if (this.editorScopedOutlineRoot != this.wholeScopedOutlineRoot) {
            this.setInfoText("Press 'Ctrl+O' to search in the current editor scope");
        }
        if (this.wholeScopedOutlineRoot == null) {
            this.wholeScopedOutlineRoot = this.getSuperRoot(this.editor.getIntentContent());
        }
        return this.wholeScopedOutlineRoot;
    }

    public void toggleQuickOutlineMode() {
        this.setConsiderOnlyLocalASTElements(!this.considerOnlyLocalASTElements);
        this.setInput(null);
    }

    public void setConsiderOnlyLocalASTElements(boolean considerOnlyLocalASTElements) {
        this.considerOnlyLocalASTElements = considerOnlyLocalASTElements;
    }

    private EObject getSuperRoot(EObject content) {
        if (content instanceof IntentDocument) {
            return content;
        }
        EObject container = content;
        while (container != null && !(container instanceof IntentDocument) && !(container instanceof Resource)) {
            container = container.eContainer();
        }
        if (container == null) {
            container = this.getSuperRootFromIndex(container);
        }
        return container;
    }

    private EObject getSuperRootFromIndex(EObject content) {
        EObject root = null;
        RepositoryAdapter repositoryAdapter = ((IntentDocumentProvider)this.editor.getDocumentProvider()).getListenedElementsHandler().getRepositoryAdapter();
        IntentIndex index = new IndexQuery(repositoryAdapter).getOrCreateIntentIndex();
        if (index.getEntries().size() > 0) {
            root = ((IntentIndexEntry)index.getEntries().get(0)).getReferencedElement();
        }
        if (root == null) {
            root = content;
        }
        return root;
    }

    private KeyAdapter getKeyAdapterForToggling() {
        if (this.togglingKeyAdapter == null) {
            this.togglingKeyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                    KeySequence keySequence = KeySequence.getInstance((KeyStroke)SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
                    try {
                        KeySequence expectedKeySequence = KeySequence.getInstance((String)IntentQuickOutlineControl.KEY_SEQUENCE_FOR_TOGGLING);
                        if (expectedKeySequence.equals((Object)keySequence)) {
                            IntentQuickOutlineControl.this.toggleQuickOutlineMode();
                        }
                    }
                    catch (ParseException parseException) {}
                }
            };
        }
        return this.togglingKeyAdapter;
    }

    public void setInformation(String information) {
    }

    public void setInput(Object input) {
        IntentOutlineInformationHolder newInputHolder = new IntentOutlineInformationHolder(this.getQuickOutlineRoot(), true);
        if (this.considerOnlyLocalASTElements) {
            this.treeViewer.setSelection(null);
        }
        this.treeViewer.setInput((Object)newInputHolder);
        this.treeViewer.expandToLevel(2);
    }

    public void setLocation(Point location) {
        if (!this.getPersistLocation()) {
            this.getShell().setLocation(location);
        }
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public void widgetDisposed(DisposeEvent event) {
        this.adapterFactory = null;
        this.filteredTree = null;
        this.treeViewer = null;
    }

    protected boolean hasInfoArea() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.createTreeViewer(parent);
        this.treeViewer.getControl().addKeyListener((KeyListener)this.getKeyAdapterForToggling());
        this.filteredTree.getFilterControl().addKeyListener((KeyListener)this.getKeyAdapterForToggling());
        this.addDisposeListener(this);
        return this.treeViewer.getControl();
    }

    protected void createTreeViewer(Composite parent) {
        this.createFilteredTree(parent);
        this.treeViewer = this.filteredTree.getViewer();
        final Tree tree = this.treeViewer.getTree();
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\r' || event.character == '\u1000050') {
                    TreeItem[] selection = tree.getSelection();
                    Object selected = selection[0].getData();
                    if (selected instanceof IntentGenericElement) {
                        IntentGenericElement element = (IntentGenericElement)selection[0].getData();
                        IntentQuickOutlineControl.this.editor.selectRange(element);
                        IntentQuickOutlineControl.this.dispose();
                    }
                } else if (event.character == '\u001b') {
                    IntentQuickOutlineControl.this.dispose();
                }
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (tree.equals(event.getSource())) {
                    if (tree.getSelectionCount() != 1 || event.button != 1) {
                        return;
                    }
                    TreeItem[] selection = tree.getSelection();
                    if (selection[0].getData() instanceof IntentGenericElement) {
                        IntentGenericElement element = (IntentGenericElement)selection[0].getData();
                        IntentQuickOutlineControl.this.editor.selectRange(element);
                        IntentQuickOutlineControl.this.dispose();
                    }
                }
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new OutlineContentProvider(this.getAdapterFactory(), this.getQuickOutlineRoot(), true));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new IntentOutlinePageLabelProvider(this.getAdapterFactory()));
        this.treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof IntentGenericElement;
            }
        });
    }

    private void createFilteredTree(Composite parent) {
        Constructor filteredTreeConstructor = null;
        try {
            filteredTreeConstructor = FilteredTree.class.getConstructor(Composite.class, Integer.TYPE, PatternFilter.class, Boolean.TYPE);
            this.filteredTree = (FilteredTree)filteredTreeConstructor.newInstance(new Object[]{parent, 772, new QuickOutlinePatternFilter(), true});
            this.filteredTree.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                }
            });
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                filteredTreeConstructor = FilteredTree.class.getConstructor(Composite.class, Integer.TYPE, PatternFilter.class);
                this.filteredTree = (FilteredTree)filteredTreeConstructor.newInstance(new Object[]{parent, 772, new QuickOutlinePatternFilter()});
            }
            catch (NoSuchMethodException ee) {
                IntentEditorActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.docs.intent.client.ui", ee.getMessage()));
            }
            catch (IllegalArgumentException ee) {
                IntentEditorActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.docs.intent.client.ui", ee.getMessage()));
            }
            catch (InstantiationException ee) {
                IntentEditorActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.docs.intent.client.ui", ee.getMessage()));
            }
            catch (IllegalAccessException ee) {
                IntentEditorActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.docs.intent.client.ui", ee.getMessage()));
            }
            catch (InvocationTargetException ee) {
                IntentEditorActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.docs.intent.client.ui", ee.getMessage()));
            }
        }
        catch (IllegalArgumentException e) {
            IntentEditorActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.docs.intent.client.ui", e.getMessage()));
        }
        catch (InstantiationException e) {
            IntentEditorActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.docs.intent.client.ui", e.getMessage()));
        }
        catch (IllegalAccessException e) {
            IntentEditorActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.docs.intent.client.ui", e.getMessage()));
        }
        catch (InvocationTargetException e) {
            IntentEditorActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.docs.intent.client.ui", e.getMessage()));
        }
    }

    protected AdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            ArrayList<ReflectiveItemProviderAdapterFactory> factories = new ArrayList<ReflectiveItemProviderAdapterFactory>();
            factories.add(new IntentOutlinePageItemProviderAdapterFactory(true));
            factories.add((ReflectiveItemProviderAdapterFactory)new ResourceItemProviderAdapterFactory());
            factories.add((ReflectiveItemProviderAdapterFactory)new EcoreItemProviderAdapterFactory());
            factories.add(new ReflectiveItemProviderAdapterFactory());
            this.adapterFactory = new ComposedAdapterFactory(factories);
        }
        return this.adapterFactory;
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.filteredTree.setFocus();
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public boolean hasContents() {
        return true;
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public void dispose() {
        this.filteredTree.dispose();
        this.close();
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public boolean isFocusControl() {
        return this.getShell() == Display.getCurrent().getActiveShell();
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }
}

