/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentDocumentProvider;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorDocument;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IIntentLogger;
import org.eclipse.mylyn.docs.intent.collab.common.logger.IntentLogger;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ModelingUnit;
import org.eclipse.mylyn.docs.intent.modelingunit.update.MergeUpdater;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;

public class IntentEditorDropSupport
extends DropTargetAdapter {
    private IntentEditor editor;
    private IntentEditorDocument document;

    public IntentEditorDropSupport(IntentEditor editor) {
        this.editor = editor;
        this.document = (IntentEditorDocument)editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
    }

    public void drop(DropTargetEvent event) {
        if (event.data instanceof IStructuredSelection) {
            EObject intentElement;
            ArrayList<EObject> droppedEObjects = new ArrayList<EObject>();
            for (Object data : (IStructuredSelection)event.data) {
                if (!(data instanceof EObject)) continue;
                droppedEObjects.add((EObject)data);
            }
            IntentDocumentProvider documentProvider = (IntentDocumentProvider)this.editor.getDocumentProvider();
            RepositoryAdapter repositoryAdapter = documentProvider.getListenedElementsHandler().getRepositoryAdapter();
            MergeUpdater updater = new MergeUpdater(repositoryAdapter);
            EObject parent = intentElement = this.document.getElementAtOffset(this.editor.getProjectionViewer().getTextWidget().getCaretOffset());
            while (parent != null && !(parent instanceof ModelingUnit) && !(parent instanceof IntentSection)) {
                parent = parent.eContainer();
            }
            if (parent instanceof ModelingUnit) {
                updater.create((ModelingUnit)parent, droppedEObjects);
            } else if (parent instanceof IntentSection) {
                updater.create((IntentSection)parent, droppedEObjects);
            } else {
                IntentLogger.getInstance().log(IIntentLogger.LogType.ERROR, "Only modeling units & sections support drops.");
            }
            this.document.reloadFromAST();
        }
    }
}

