/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.markup;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Formatting implements Enumerator
{
    NONE(0, "none", "none"),
    EMPHASIS(1, "emphasis", "emphasis"),
    STRONG(2, "strong", "strong"),
    ITALIC(3, "italic", "italic"),
    BOLD(4, "bold", "bold"),
    CITATION(5, "citation", "citation"),
    DELETED(6, "deleted", "deleted"),
    INSERTED(7, "inserted", "inserted"),
    SUPERSCRIPT(8, "superscript", "superscript"),
    SUBSCRIPT(9, "subscript", "subscript"),
    SPAN(10, "span", "span"),
    CODE(11, "code", "code"),
    MONOSPACE(12, "monospace", "monospace"),
    UNDERLINED(13, "underlined", "underlined"),
    QUOTE(14, "quote", "quote");

    public static final int NONE_VALUE = 0;
    public static final int EMPHASIS_VALUE = 1;
    public static final int STRONG_VALUE = 2;
    public static final int ITALIC_VALUE = 3;
    public static final int BOLD_VALUE = 4;
    public static final int CITATION_VALUE = 5;
    public static final int DELETED_VALUE = 6;
    public static final int INSERTED_VALUE = 7;
    public static final int SUPERSCRIPT_VALUE = 8;
    public static final int SUBSCRIPT_VALUE = 9;
    public static final int SPAN_VALUE = 10;
    public static final int CODE_VALUE = 11;
    public static final int MONOSPACE_VALUE = 12;
    public static final int UNDERLINED_VALUE = 13;
    public static final int QUOTE_VALUE = 14;
    private static final Formatting[] VALUES_ARRAY;
    public static final List<Formatting> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Formatting[]{NONE, EMPHASIS, STRONG, ITALIC, BOLD, CITATION, DELETED, INSERTED, SUPERSCRIPT, SUBSCRIPT, SPAN, CODE, MONOSPACE, UNDERLINED, QUOTE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Formatting get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Formatting result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Formatting getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Formatting result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Formatting get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return EMPHASIS;
            }
            case 2: {
                return STRONG;
            }
            case 3: {
                return ITALIC;
            }
            case 4: {
                return BOLD;
            }
            case 5: {
                return CITATION;
            }
            case 6: {
                return DELETED;
            }
            case 7: {
                return INSERTED;
            }
            case 8: {
                return SUPERSCRIPT;
            }
            case 9: {
                return SUBSCRIPT;
            }
            case 10: {
                return SPAN;
            }
            case 11: {
                return CODE;
            }
            case 12: {
                return MONOSPACE;
            }
            case 13: {
                return UNDERLINED;
            }
            case 14: {
                return QUOTE;
            }
        }
        return null;
    }

    private Formatting(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

