/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.synchronizer.strategy;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.client.synchronizer.factory.SynchronizerMessageProvider;
import org.eclipse.mylyn.docs.intent.client.synchronizer.strategy.SynchronizerStrategy;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationMessageType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusSeverity;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilerFactory;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerCompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerResourceState;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSynchronizerStrategy
implements SynchronizerStrategy {
    @Override
    public Resource handleNullExternalResource(ResourceDeclaration resourceDeclaration, Resource internalResource, String externalResourceURI) {
        return null;
    }

    @Override
    public Resource handleEmptyExternalResource(ResourceDeclaration resourceDeclaration, Resource internalResource, String externalResourceURI) {
        return null;
    }

    @Override
    public Resource handleNullInternalResource(String internalResourceURI, Resource externalResource) {
        return null;
    }

    @Override
    public Resource getLeftResource(Resource internalResource, Resource externalResource) {
        return internalResource;
    }

    @Override
    public Resource getRightResource(Resource internalResource, Resource externalResource) {
        return externalResource;
    }

    @Override
    public Collection<? extends CompilationStatus> getStatusForNullExternalResource(ResourceDeclaration resourceDeclaration, String resourcePath) {
        SynchronizerCompilationStatus status = CompilerFactory.eINSTANCE.createSynchronizerCompilationStatus();
        status.setCompiledResourceURI(resourcePath);
        status.setWorkingCopyResourceURI(resourceDeclaration.getUri().toString());
        status.setSeverity(CompilationStatusSeverity.WARNING);
        status.setTarget((IntentGenericElement)resourceDeclaration);
        status.setType(CompilationMessageType.SYNCHRONIZER_WARNING);
        status.setMessage(SynchronizerMessageProvider.createMessageForNullExternalResource(resourceDeclaration));
        status.setWorkingCopyResourceState(SynchronizerResourceState.NULL);
        return Lists.newArrayList((Object[])new SynchronizerCompilationStatus[]{status});
    }

    @Override
    public Collection<? extends CompilationStatus> getStatusForEmptyExternalResource(ResourceDeclaration resourceDeclaration, String resourcePath) {
        SynchronizerCompilationStatus status = CompilerFactory.eINSTANCE.createSynchronizerCompilationStatus();
        status.setCompiledResourceURI(resourcePath);
        status.setWorkingCopyResourceURI(resourceDeclaration.getUri().toString());
        status.setSeverity(CompilationStatusSeverity.WARNING);
        status.setTarget((IntentGenericElement)resourceDeclaration);
        status.setType(CompilationMessageType.SYNCHRONIZER_WARNING);
        status.setMessage(SynchronizerMessageProvider.createMessageForEmptyExternalResource(resourceDeclaration));
        status.setWorkingCopyResourceState(SynchronizerResourceState.EMPTY);
        return Lists.newArrayList((Object[])new SynchronizerCompilationStatus[]{status});
    }

    @Override
    public Collection<? extends CompilationStatus> getStatusForEmptyInternalResource(ResourceDeclaration resourceDeclaration, String resourcePath) {
        SynchronizerCompilationStatus status = CompilerFactory.eINSTANCE.createSynchronizerCompilationStatus();
        status.setWorkingCopyResourceURI(resourceDeclaration.getUri().toString());
        status.setSeverity(CompilationStatusSeverity.WARNING);
        status.setTarget((IntentGenericElement)resourceDeclaration);
        status.setType(CompilationMessageType.SYNCHRONIZER_WARNING);
        status.setMessage(SynchronizerMessageProvider.createMessageForEmptyInternalResource(resourceDeclaration));
        status.setCompiledResourceState(SynchronizerResourceState.EMPTY);
        return Lists.newArrayList((Object[])new SynchronizerCompilationStatus[]{status});
    }
}

