/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.ui.popup.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.acceleo.engine.service.AbstractAcceleoGenerator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.docs.intent.markup.resource.WikitextResourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenerateActions {
    private GenerateActions() {
    }

    static void run(ISelection selection, Class<? extends AbstractAcceleoGenerator> generator) {
        Object file;
        if (selection instanceof StructuredSelection && (file = ((StructuredSelection)selection).getFirstElement()) instanceof IFile) {
            GenerateActions.generateFileWithGenerator((IFile)file, generator);
        }
    }

    private static void generateFileWithGenerator(IFile iFile, Class<? extends AbstractAcceleoGenerator> generatorClass) {
        try {
            File file = GenerateActions.resolve(iFile.getLocationURI().toURL());
            FileInputStream input = new FileInputStream(file);
            URI textileUri = URI.createURI((String)iFile.getLocationURI().toString());
            Resource resourceTextile = new WikitextResourceFactory().createResource(textileUri);
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", "UTF8");
            resourceTextile.load((InputStream)input, options);
            EObject model = (EObject)resourceTextile.getContents().iterator().next();
            AbstractAcceleoGenerator generator = GenerateActions.createGenerator(generatorClass, file, model);
            generator.doGenerate((Monitor)new BasicMonitor());
            iFile.getParent().refreshLocal(1, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static AbstractAcceleoGenerator createGenerator(Class<? extends AbstractAcceleoGenerator> generatorClass, File file, EObject model) {
        try {
            Constructor<? extends AbstractAcceleoGenerator> c = generatorClass.getConstructor(EObject.class, File.class, List.class);
            AbstractAcceleoGenerator generator = c.newInstance(model, file.getParentFile(), new ArrayList());
            return generator;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static File resolve(URL url) {
        File resultFile = null;
        URL resolved = url;
        try {
            if (!url.getProtocol().equals("file")) {
                resolved = FileLocator.resolve((URL)resolved);
            }
            resultFile = new File(resolved.toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultFile;
    }
}

