/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.servlet.artemis;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.VcsChangeType;
import org.eclipse.hawk.core.VcsCommit;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.VcsRepositoryDelta;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.model.IHawkClass;
import org.eclipse.hawk.core.model.IHawkObject;
import org.eclipse.hawk.core.model.IHawkPackage;
import org.eclipse.hawk.service.api.CommitItem;
import org.eclipse.hawk.service.api.CommitItemChangeType;
import org.eclipse.hawk.service.api.HawkAttributeRemovalEvent;
import org.eclipse.hawk.service.api.HawkAttributeUpdateEvent;
import org.eclipse.hawk.service.api.HawkChangeEvent;
import org.eclipse.hawk.service.api.HawkFileAdditionEvent;
import org.eclipse.hawk.service.api.HawkFileRemovalEvent;
import org.eclipse.hawk.service.api.HawkModelElementAdditionEvent;
import org.eclipse.hawk.service.api.HawkModelElementRemovalEvent;
import org.eclipse.hawk.service.api.HawkReferenceAdditionEvent;
import org.eclipse.hawk.service.api.HawkReferenceRemovalEvent;
import org.eclipse.hawk.service.api.HawkSynchronizationEndEvent;
import org.eclipse.hawk.service.api.HawkSynchronizationStartEvent;
import org.eclipse.hawk.service.api.SubscriptionDurability;
import org.eclipse.hawk.service.api.utils.APIUtils;
import org.eclipse.hawk.service.api.utils.ActiveMQBufferTransport;
import org.eclipse.hawk.service.servlet.utils.HawkModelElementEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtemisProducerGraphChangeListener
implements IGraphChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtemisProducerGraphChangeListener.class);
    private final ServerLocator locator;
    private final ClientSessionFactory sessionFactory;
    private final boolean messagesAreDurable;
    private final String queueAddress;
    private final TProtocolFactory protocolFactory;
    private ClientSession session;
    private ClientProducer producer;
    private final Pattern repositoryURIPattern;
    private final Pattern filePathPattern;
    private final List<HawkChangeEventFactory> collectedEventFactories = new ArrayList<HawkChangeEventFactory>();
    private boolean isSessionOpenedFromSync = false;

    public ArtemisProducerGraphChangeListener(String hawkInstance, String repositoryUri, List<String> filePaths, SubscriptionDurability durability, APIUtils.ThriftProtocol protocol) throws Exception {
        this.repositoryURIPattern = Pattern.compile(repositoryUri.replace("*", ".*"));
        StringBuffer sbuf = new StringBuffer();
        boolean first = true;
        for (String filePath : filePaths) {
            if (first) {
                first = false;
            } else {
                sbuf.append("|");
            }
            sbuf.append(filePath.replace("*", ".*"));
        }
        this.filePathPattern = Pattern.compile(sbuf.toString());
        this.protocolFactory = protocol.getProtocolFactory();
        this.locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(InVMConnectorFactory.class.getName())});
        this.locator.setCompressLargeMessage(true);
        this.locator.setMinLargeMessageSize(10240);
        this.sessionFactory = this.locator.createSessionFactory();
        this.messagesAreDurable = durability == SubscriptionDurability.DURABLE;
        this.queueAddress = String.format("hawk.graphchanges.%s.%s.%s.%s.%s", hawkInstance, protocol.toString().toLowerCase(), repositoryUri.hashCode(), filePaths.hashCode(), durability.toString().toLowerCase());
    }

    public String getQueueAddress() {
        return this.queueAddress;
    }

    public String getName() {
        return "Artemis graph change listener";
    }

    public void synchroniseStart() {
        this.openSession();
        this.isSessionOpenedFromSync = true;
        HawkSynchronizationStartEvent ev = new HawkSynchronizationStartEvent(System.nanoTime());
        HawkChangeEvent change = new HawkChangeEvent();
        change.setSyncStart(ev);
        this.sendEvent(change);
        try {
            this.session.commit();
        }
        catch (ActiveMQException e) {
            LOGGER.error("Could not commit the synchronisation start event", (Throwable)e);
        }
    }

    public void synchroniseEnd() {
        try {
            try {
                HawkSynchronizationEndEvent ev = new HawkSynchronizationEndEvent(System.nanoTime());
                HawkChangeEvent change = new HawkChangeEvent();
                change.setSyncEnd(ev);
                this.sendEvent(change);
                this.session.commit();
            }
            catch (ActiveMQException e) {
                LOGGER.error("Could not commit the transaction", (Throwable)e);
                this.closeSession();
            }
        }
        finally {
            this.closeSession();
        }
    }

    public void changeStart() {
        this.collectedEventFactories.clear();
        this.openSession();
    }

    public void changeSuccess() {
        try {
            try {
                for (HawkChangeEventFactory eventFactory : this.collectedEventFactories) {
                    this.sendEvent(eventFactory.create());
                }
                this.session.commit();
            }
            catch (ActiveMQException e) {
                LOGGER.error("Could not commit the transaction", (Throwable)e);
                try {
                    this.session.rollback();
                }
                catch (ActiveMQException e1) {
                    LOGGER.error("Could not rollback the transaction", (Throwable)e1);
                }
                this.collectedEventFactories.clear();
                if (!this.isSessionOpenedFromSync) {
                    this.closeSession();
                }
            }
        }
        finally {
            this.collectedEventFactories.clear();
            if (!this.isSessionOpenedFromSync) {
                this.closeSession();
            }
        }
    }

    public void changeFailure() {
        try {
            try {
                this.session.rollback();
                LOGGER.debug("Session rolled back");
            }
            catch (ActiveMQException e) {
                LOGGER.error("Could not rollback the transaction", (Throwable)e);
                this.collectedEventFactories.clear();
                if (!this.isSessionOpenedFromSync) {
                    this.closeSession();
                }
            }
        }
        finally {
            this.collectedEventFactories.clear();
            if (!this.isSessionOpenedFromSync) {
                this.closeSession();
            }
        }
    }

    public void metamodelAddition(IHawkPackage pkg, IGraphNode pkgNode) {
    }

    public void classAddition(IHawkClass cls, IGraphNode clsNode) {
    }

    public void fileAddition(VcsCommitItem s, IGraphNode fileNode) {
        if (!this.isAcceptedByFilter(s)) {
            return;
        }
        HawkFileAdditionEvent ev = new HawkFileAdditionEvent();
        ev.setVcsItem(this.mapToThrift(s));
        final HawkChangeEvent change = new HawkChangeEvent();
        change.setFileAddition(ev);
        this.collectedEventFactories.add(new HawkChangeEventFactory(){

            @Override
            public HawkChangeEvent create() {
                return change;
            }
        });
    }

    public void fileRemoval(VcsCommitItem s, IGraphNode fileNode) {
        if (!this.isAcceptedByFilter(s)) {
            return;
        }
        HawkFileRemovalEvent ev = new HawkFileRemovalEvent();
        ev.setVcsItem(this.mapToThrift(s));
        final HawkChangeEvent change = new HawkChangeEvent();
        change.setFileRemoval(ev);
        this.collectedEventFactories.add(new HawkChangeEventFactory(){

            @Override
            public HawkChangeEvent create() {
                return change;
            }
        });
    }

    public void modelElementAddition(final VcsCommitItem s, final IHawkObject element, final IGraphNode elementNode, boolean isTransient) {
        if (isTransient || !this.isAcceptedByFilter(s)) {
            return;
        }
        try {
            this.collectedEventFactories.add(new HawkChangeEventFactory(){

                @Override
                public HawkChangeEvent create() {
                    HawkModelElementAdditionEvent ev = new HawkModelElementAdditionEvent();
                    ev.setVcsItem(ArtemisProducerGraphChangeListener.this.mapToThrift(s));
                    ev.setMetamodelURI(element.getType().getPackageNSURI());
                    ev.setTypeName(element.getType().getName());
                    ev.setId(elementNode.getId().toString());
                    HawkChangeEvent change = new HawkChangeEvent();
                    change.setModelElementAddition(ev);
                    return change;
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Could not encode a model element", (Throwable)e);
        }
    }

    public void modelElementRemoval(final VcsCommitItem s, final IGraphNode elementNode, boolean isTransient) {
        if (isTransient || !this.isAcceptedByFilter(s)) {
            return;
        }
        this.collectedEventFactories.add(new HawkChangeEventFactory(){

            @Override
            public HawkChangeEvent create() {
                HawkModelElementRemovalEvent ev = new HawkModelElementRemovalEvent();
                ev.setVcsItem(ArtemisProducerGraphChangeListener.this.mapToThrift(s));
                ev.setId(elementNode.getId().toString());
                HawkChangeEvent change = new HawkChangeEvent();
                change.setModelElementRemoval(ev);
                return change;
            }
        });
    }

    public void modelElementAttributeUpdate(final VcsCommitItem s, IHawkObject eObject, final String attrName, Object oldValue, final Object newValue, final IGraphNode elementNode, boolean isTransient) {
        if (isTransient || !this.isAcceptedByFilter(s)) {
            return;
        }
        this.collectedEventFactories.add(new HawkChangeEventFactory(){

            @Override
            public HawkChangeEvent create() {
                HawkAttributeUpdateEvent ev = new HawkAttributeUpdateEvent();
                ev.setAttribute(attrName);
                ev.setId(elementNode.getId().toString());
                ev.setValue(HawkModelElementEncoder.encodeAttributeSlot((String)attrName, (Object)newValue).value);
                ev.setVcsItem(ArtemisProducerGraphChangeListener.this.mapToThrift(s));
                HawkChangeEvent change = new HawkChangeEvent();
                change.setModelElementAttributeUpdate(ev);
                return change;
            }
        });
    }

    public void modelElementAttributeRemoval(final VcsCommitItem s, IHawkObject eObject, final String attrName, final IGraphNode elementNode, boolean isTransient) {
        if (isTransient || !this.isAcceptedByFilter(s)) {
            return;
        }
        this.collectedEventFactories.add(new HawkChangeEventFactory(){

            @Override
            public HawkChangeEvent create() {
                HawkAttributeRemovalEvent ev = new HawkAttributeRemovalEvent();
                ev.setAttribute(attrName);
                ev.setId(elementNode.getId().toString());
                ev.setVcsItem(ArtemisProducerGraphChangeListener.this.mapToThrift(s));
                HawkChangeEvent change = new HawkChangeEvent();
                change.setModelElementAttributeRemoval(ev);
                return change;
            }
        });
    }

    public void referenceAddition(final VcsCommitItem s, final IGraphNode source, final IGraphNode target, final String refName, boolean isTransient) {
        if (isTransient || !this.isAcceptedByFilter(s)) {
            return;
        }
        this.collectedEventFactories.add(new HawkChangeEventFactory(){

            @Override
            public HawkChangeEvent create() {
                HawkReferenceAdditionEvent ev = new HawkReferenceAdditionEvent();
                ev.setSourceId(source.getId().toString());
                ev.setTargetId(target.getId().toString());
                ev.setVcsItem(ArtemisProducerGraphChangeListener.this.mapToThrift(s));
                ev.setRefName(refName);
                HawkChangeEvent change = new HawkChangeEvent();
                change.setReferenceAddition(ev);
                return change;
            }
        });
    }

    public void referenceRemoval(final VcsCommitItem s, final IGraphNode source, final IGraphNode target, final String refName, boolean isTransient) {
        if (isTransient || !this.isAcceptedByFilter(s)) {
            return;
        }
        this.collectedEventFactories.add(new HawkChangeEventFactory(){

            @Override
            public HawkChangeEvent create() {
                HawkReferenceRemovalEvent ev = new HawkReferenceRemovalEvent();
                ev.setSourceId(source.getId().toString());
                ev.setTargetId(target.getId().toString());
                ev.setVcsItem(ArtemisProducerGraphChangeListener.this.mapToThrift(s));
                ev.setRefName(refName);
                HawkChangeEvent change = new HawkChangeEvent();
                change.setReferenceRemoval(ev);
                return change;
            }
        });
    }

    private boolean isAcceptedByFilter(VcsCommitItem s) {
        VcsCommit commit = s.getCommit();
        VcsRepositoryDelta delta = commit.getDelta();
        String repositoryURL = delta.getManager().getLocation();
        return this.repositoryURIPattern.matcher(repositoryURL).matches() && this.filePathPattern.matcher(s.getPath()).matches();
    }

    private CommitItem mapToThrift(VcsCommitItem s) {
        VcsCommit commit = s.getCommit();
        String repoURL = commit.getDelta().getManager().getLocation();
        String revision = commit.getRevision();
        String path = s.getPath();
        CommitItemChangeType changeType = this.mapToThrift(s.getChangeType());
        return new CommitItem(repoURL, revision, path, changeType);
    }

    private CommitItemChangeType mapToThrift(VcsChangeType changeType) {
        switch (changeType) {
            case ADDED: {
                return CommitItemChangeType.ADDED;
            }
            case DELETED: {
                return CommitItemChangeType.DELETED;
            }
            case REPLACED: {
                return CommitItemChangeType.REPLACED;
            }
            case UPDATED: {
                return CommitItemChangeType.UPDATED;
            }
        }
        return CommitItemChangeType.UNKNOWN;
    }

    private void sendEvent(HawkChangeEvent change) {
        try {
            ClientMessage msg = this.session.createMessage((byte)4, this.messagesAreDurable);
            ActiveMQBufferTransport trans = new ActiveMQBufferTransport(msg.getBodyBuffer());
            TProtocol proto = this.protocolFactory.getProtocol((TTransport)trans);
            change.write(proto);
            this.producer.send((Message)msg);
        }
        catch (TException ex) {
            LOGGER.error("Serialization error", (Throwable)ex);
        }
        catch (ActiveMQException ex) {
            LOGGER.error("Error while sending event", (Throwable)ex);
        }
    }

    private void openSession() {
        if (this.session == null || this.session.isClosed()) {
            try {
                this.session = this.sessionFactory.createSession(false, false, false);
                this.producer = this.session.createProducer(this.queueAddress);
            }
            catch (ActiveMQException e) {
                LOGGER.error("Could not start a new Artemis session", (Throwable)e);
            }
        }
    }

    private void closeSession() {
        try {
            try {
                if (this.producer != null) {
                    this.producer.close();
                }
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (ActiveMQException e) {
                LOGGER.error("Could not close the session", (Throwable)e);
                this.session = null;
                this.isSessionOpenedFromSync = false;
            }
        }
        finally {
            this.session = null;
            this.isSessionOpenedFromSync = false;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.queueAddress == null ? 0 : this.queueAddress.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtemisProducerGraphChangeListener other = (ArtemisProducerGraphChangeListener)obj;
        return !(this.queueAddress == null ? other.queueAddress != null : !this.queueAddress.equals(other.queueAddress));
    }

    public void setModelIndexer(IModelIndexer m) {
    }

    private static interface HawkChangeEventFactory {
        public HawkChangeEvent create();
    }
}

